/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.backend;

import me.neznamy.tab.shared.GroupManager;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.backend.BackendTabPlayer;
import me.neznamy.tab.shared.features.PlaceholderManagerImpl;
import me.neznamy.tab.shared.features.redis.RedisSupport;
import me.neznamy.tab.shared.hook.LuckPermsHook;
import me.neznamy.tab.shared.placeholders.UniversalPlaceholderRegistry;
import me.neznamy.tab.shared.platform.Platform;
import org.jetbrains.annotations.NotNull;

public interface BackendPlatform
extends Platform {
    @Override
    @NotNull
    default public GroupManager detectPermissionPlugin() {
        if (LuckPermsHook.getInstance().isInstalled()) {
            return new GroupManager("LuckPerms", LuckPermsHook.getInstance().getGroupFunction());
        }
        return new GroupManager("None", p -> "NONE");
    }

    @Override
    default public RedisSupport getRedisSupport() {
        return null;
    }

    @Override
    default public void registerPlaceholders() {
        UniversalPlaceholderRegistry registry = new UniversalPlaceholderRegistry();
        PlaceholderManagerImpl manager = TAB.getInstance().getPlaceholderManager();
        manager.registerPlayerPlaceholder("%health%", 100, p -> (int)Math.ceil(((BackendTabPlayer)p).getHealth()));
        manager.registerPlayerPlaceholder("%displayname%", 500, p -> ((BackendTabPlayer)p).getDisplayName());
        manager.registerServerPlaceholder("%tps%", 1000, () -> registry.getDecimal2().format(Math.min(20.0, this.getTPS())));
        manager.registerServerPlaceholder("%mspt%", 1000, () -> registry.getDecimal2().format(this.getMSPT()));
        registry.registerPlaceholders(manager);
    }

    @Override
    default public boolean isProxy() {
        return false;
    }

    default public void registerDummyPlaceholder(@NotNull String identifier) {
        if (identifier.startsWith("%rel_")) {
            TAB.getInstance().getPlaceholderManager().registerRelationalPlaceholder(identifier, -1, (viewer, target) -> identifier);
        } else {
            TAB.getInstance().getPlaceholderManager().registerServerPlaceholder(identifier, -1, () -> identifier);
        }
    }

    public double getTPS();

    public double getMSPT();
}

