/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.command;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.command.SubCommand;
import me.neznamy.tab.shared.features.nametags.NameTag;
import me.neznamy.tab.shared.features.nametags.unlimited.NameTagX;
import me.neznamy.tab.shared.platform.TabPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NameTagCommand
extends SubCommand {
    public NameTagCommand() {
        super("nametag", null);
    }

    @Override
    public void execute(@Nullable TabPlayer sender, @NotNull String[] args) {
        if (args.length == 0 || args.length > 3) {
            this.sendMessages(sender, this.getMessages().getNameTagHelpMenu());
            return;
        }
        boolean silent = args.length == 3 && args[2].equals("-s");
        switch (args[0].toLowerCase(Locale.US)) {
            case "preview": {
                this.preview(sender, this.getTarget(sender, args, "tab.nametag.preview.other", "tab.nametag.preview"), silent);
                break;
            }
            case "toggle": {
                this.toggle(sender, this.getTarget(sender, args, "tab.nametag.toggle.other", "tab.nametag.toggle"), silent);
                break;
            }
            default: {
                this.sendMessages(sender, this.getMessages().getNameTagHelpMenu());
            }
        }
    }

    private void preview(@Nullable TabPlayer sender, @Nullable TabPlayer target, boolean silent) {
        if (target == null) {
            return;
        }
        NameTagX nameTagX = (NameTagX)TAB.getInstance().getFeatureManager().getFeature("NameTagX");
        if (nameTagX == null) {
            this.sendMessage(sender, this.getMessages().getUnlimitedNametagModeNotEnabled());
            return;
        }
        if (nameTagX.hasDisabledArmorStands(target)) {
            this.sendMessage(sender, this.getMessages().getArmorStandsDisabledCannotPreview());
            return;
        }
        nameTagX.toggleNameTagPreview(target, !silent);
    }

    private void toggle(@Nullable TabPlayer sender, @Nullable TabPlayer target, boolean silent) {
        if (target == null) {
            return;
        }
        NameTag teams = TAB.getInstance().getNameTagManager();
        if (teams == null) {
            this.sendMessage(sender, this.getMessages().getNameTagFeatureNotEnabled());
            return;
        }
        teams.toggleNameTagVisibilityView(target, !silent);
    }

    @Nullable
    private TabPlayer getTarget(@Nullable TabPlayer sender, @NotNull String[] args, @NotNull String permissionOther, @NotNull String permission) {
        if (args.length >= 2 && TAB.getInstance().getPlayer(args[1]) != null) {
            if (this.hasPermission(sender, permissionOther)) {
                return TAB.getInstance().getPlayer(args[1]);
            }
            this.sendMessage(sender, this.getMessages().getNoPermission());
        } else {
            if (this.hasPermission(sender, permission)) {
                return sender;
            }
            this.sendMessage(sender, this.getMessages().getNoPermission());
        }
        return null;
    }

    @Override
    @NotNull
    public List<String> complete(@Nullable TabPlayer sender, @NotNull String[] arguments) {
        if (arguments.length == 1) {
            return this.getStartingArgument(Arrays.asList("toggle", "preview"), arguments[0]);
        }
        if (arguments.length == 2) {
            return this.getOnlinePlayers(arguments[1]);
        }
        if (arguments.length == 3) {
            return this.getStartingArgument(Collections.singletonList("-s"), arguments[2]);
        }
        return Collections.emptyList();
    }
}

