/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.command;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import me.neznamy.tab.api.placeholder.Placeholder;
import me.neznamy.tab.shared.Property;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.chat.EnumChatFormat;
import me.neznamy.tab.shared.chat.TabComponent;
import me.neznamy.tab.shared.command.SubCommand;
import me.neznamy.tab.shared.platform.TabPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParseCommand
extends SubCommand {
    public ParseCommand() {
        super("parse", "tab.parse");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void execute(@Nullable TabPlayer sender, @NotNull String[] args) {
        TabPlayer target;
        if (args.length < 2) {
            this.sendMessage(sender, this.getMessages().getParseCommandUsage());
            return;
        }
        if (args[0].equals("me")) {
            if (sender == null) {
                this.sendMessage(null, "&cThe \"me\" argument instead of player name is only available in-game and parses the placeholder for player who ran the command. If you wish to use the parse command from the console, use name of an online player instead of \"me\".");
                return;
            }
            target = sender;
        } else {
            target = TAB.getInstance().getPlayer(args[0]);
            if (target == null) {
                this.sendMessage(sender, this.getMessages().getPlayerNotFound(args[0]));
                return;
            }
        }
        String replaced = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
        if (!replaced.contains("%")) {
            this.sendMessage(sender, "&cThe provided input (" + replaced + ") does not contain any placeholders, therefore there's nothing to test.");
            return;
        }
        String message = EnumChatFormat.color("&6Replacing placeholder &e%placeholder% &6for player &e" + target.getName()).replace("%placeholder%", replaced);
        this.sendRawMessage(sender, message);
        try {
            replaced = new Property(null, null, target, replaced, null).get();
        }
        catch (Exception e) {
            this.sendMessage(sender, "&cThe placeholder threw an exception when parsing. Check console for more info.");
            TAB.getInstance().getErrorManager().parseCommandError(replaced, target, e);
            return;
        }
        TabComponent colored = TabComponent.optimized(EnumChatFormat.color("&3Colored output: &e\"&r" + replaced + "&e\""));
        if (sender != null) {
            sender.sendMessage(colored);
        } else {
            TAB.getInstance().getPlatform().logInfo(colored);
        }
        this.sendRawMessage(sender, EnumChatFormat.color("&3Raw colors: &e\"&r") + EnumChatFormat.decolor(replaced) + EnumChatFormat.color("&e\""));
        this.sendMessage(sender, "&3Output length: &e" + replaced.length() + " &3characters");
    }

    @Override
    @NotNull
    public List<String> complete(@Nullable TabPlayer sender, @NotNull String[] arguments) {
        if (arguments.length == 1) {
            List<String> suggestions = this.getOnlinePlayers(arguments[0]);
            if ("me".startsWith(arguments[0].toLowerCase())) {
                suggestions.add("me");
            }
            return suggestions;
        }
        if (arguments.length == 2) {
            return TAB.getInstance().getPlaceholderManager().getAllPlaceholders().stream().map(Placeholder::getIdentifier).filter(placeholder -> placeholder.toLowerCase().startsWith(arguments[1].toLowerCase())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

