/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.config.helper;

import java.util.Collection;
import me.neznamy.tab.api.bossbar.BossBar;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.chat.EnumChatFormat;
import me.neznamy.tab.shared.chat.TabComponent;
import me.neznamy.tab.shared.features.sorting.types.SortingType;
import me.neznamy.tab.shared.platform.TabPlayer;
import me.neznamy.tab.shared.proxy.ProxyTabPlayer;
import org.jetbrains.annotations.NotNull;

public class RuntimeErrorPrinter {
    public void invalidNumberForBossBarProgress(@NotNull BossBar bossBar, @NotNull String output, @NotNull String configuredValue, @NotNull TabPlayer player) {
        if (player instanceof ProxyTabPlayer && !((ProxyTabPlayer)player).isBridgeConnected()) {
            return;
        }
        if (configuredValue.contains("%")) {
            this.error(String.format("Placeholder \"%s\" used in progress of BossBar \"%s\" returned \"%s\" for player %s, which cannot be evaluated to a number between 0 and 100.", configuredValue, bossBar.getName(), output, player.getName()));
        } else {
            this.error(String.format("BossBar \"%s\" has invalid input configured for progress (\"%s\"). Expecting a number between 0 and 100 or a placeholder returning one.", bossBar.getName(), configuredValue));
        }
    }

    public void invalidInputForNumericSorting(@NotNull SortingType type, @NotNull String placeholder, @NotNull String output, @NotNull TabPlayer player) {
        if (player instanceof ProxyTabPlayer && !((ProxyTabPlayer)player).isBridgeConnected()) {
            return;
        }
        this.error(String.format("Placeholder %s used in sorting type %s returned \"%s\" for player %s, which is not a valid number.", placeholder, type.getDisplayName(), output, player.getName()));
    }

    public void invalidNumberForCondition(@NotNull String placeholder, @NotNull String output, @NotNull TabPlayer player) {
        if (player instanceof ProxyTabPlayer && !((ProxyTabPlayer)player).isBridgeConnected()) {
            return;
        }
        this.error(String.format("Placeholder %s used in a numeric condition returned \"%s\" for player %s, which is not a valid number.", placeholder, output, player.getName()));
    }

    public void invalidNumberForBelowName(@NotNull TabPlayer target, @NotNull String configuredValue, @NotNull String output) {
        if (target instanceof ProxyTabPlayer && !((ProxyTabPlayer)target).isBridgeConnected()) {
            return;
        }
        this.error(EnumChatFormat.decolor(String.format("Belowname number is configured to show \"%s\", but returned \"%s\" for player %s, which cannot be evaluated to a number.", configuredValue, output, target.getName())));
    }

    public void floatInBelowName(@NotNull TabPlayer target, @NotNull String configuredValue, @NotNull String output) {
        if (target instanceof ProxyTabPlayer && !((ProxyTabPlayer)target).isBridgeConnected()) {
            return;
        }
        this.error(EnumChatFormat.decolor(String.format("Belowname number is configured to show \"%s\", but returned \"%s\" for player %s, which is a decimal number. Truncating to an integer.", configuredValue, output, target.getName())));
    }

    public void invalidNumberForPlayerlistObjective(@NotNull TabPlayer target, @NotNull String configuredValue, @NotNull String output) {
        if (target instanceof ProxyTabPlayer && !((ProxyTabPlayer)target).isBridgeConnected()) {
            return;
        }
        this.error(EnumChatFormat.decolor(String.format("Playerlist objective number is configured to show \"%s\", but returned \"%s\" for player %s, which cannot be evaluated to a number.", configuredValue, output, target.getName())));
    }

    public void floatInPlayerlistObjective(@NotNull TabPlayer target, @NotNull String configuredValue, @NotNull String output) {
        if (target instanceof ProxyTabPlayer && !((ProxyTabPlayer)target).isBridgeConnected()) {
            return;
        }
        this.error(EnumChatFormat.decolor(String.format("Playerlist objective number is configured to show \"%s\", but returned \"%s\" for player %s, which is a decimal number. Truncating to an integer.", configuredValue, output, target.getName())));
    }

    public void groupNotInSortingList(@NotNull Collection<String> list, @NotNull String group, @NotNull TabPlayer player) {
        if (player instanceof ProxyTabPlayer && !((ProxyTabPlayer)player).isBridgeConnected()) {
            return;
        }
        this.error(String.format("Player %s's group (%s) is not in sorting list! Sorting list: %s. Player will be sorted on the bottom.", player.getName(), group, String.join((CharSequence)",", list)));
    }

    public void noPermissionFromSortingList(@NotNull Collection<String> list, @NotNull TabPlayer player) {
        this.error(String.format("Player %s does not have any of the defined permissions in sorting list! Sorting list: %s. Player will be sorted on the bottom.", player.getName(), String.join((CharSequence)",", list)));
    }

    public void valueNotInPredefinedValues(@NotNull String placeholder, @NotNull Collection<String> list, @NotNull String output, @NotNull TabPlayer player) {
        this.error(String.format("Sorting placeholder %s with pre-defined values [%s] returned \"%s\" for player %s, which is not defined. Player will be sorted on the bottom.", placeholder, String.join((CharSequence)",", list), output, player.getName()));
    }

    public void unknownMineSkin(@NotNull String id) {
        this.error("Failed to load skin by id: No skin with the id '" + id + "' was found");
    }

    public void unknownPlayerSkin(@NotNull String name) {
        this.error("Failed to load skin by player: No user with the name '" + name + "' was found");
    }

    private void error(@NotNull String message) {
        TAB.getInstance().getPlatform().logWarn(TabComponent.fromColoredText(message));
    }
}

