/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.TabConstants;
import me.neznamy.tab.shared.chat.TabComponent;
import me.neznamy.tab.shared.features.PlayerList;
import me.neznamy.tab.shared.features.types.GameModeListener;
import me.neznamy.tab.shared.features.types.JoinListener;
import me.neznamy.tab.shared.features.types.Loadable;
import me.neznamy.tab.shared.features.types.QuitListener;
import me.neznamy.tab.shared.features.types.Refreshable;
import me.neznamy.tab.shared.features.types.ServerSwitchListener;
import me.neznamy.tab.shared.features.types.TabFeature;
import me.neznamy.tab.shared.features.types.TabListClearListener;
import me.neznamy.tab.shared.features.types.UnLoadable;
import me.neznamy.tab.shared.features.types.VanishListener;
import me.neznamy.tab.shared.platform.TabList;
import me.neznamy.tab.shared.platform.TabPlayer;
import org.jetbrains.annotations.NotNull;

public class GlobalPlayerList
extends TabFeature
implements JoinListener,
QuitListener,
VanishListener,
GameModeListener,
Loadable,
UnLoadable,
ServerSwitchListener,
TabListClearListener,
Refreshable {
    private final List<String> spyServers = this.config().getStringList("global-playerlist.spy-servers", Collections.singletonList("spyserver1")).stream().map(String::toLowerCase).collect(Collectors.toList());
    private final Map<String, List<String>> sharedServers = this.config().getConfigurationSection("global-playerlist.server-groups");
    private final boolean othersAsSpectators = this.config().getBoolean("global-playerlist.display-others-as-spectators", false);
    private final boolean vanishedAsSpectators = this.config().getBoolean("global-playerlist.display-vanished-players-as-spectators", true);
    private final boolean isolateUnlistedServers = this.config().getBoolean("global-playerlist.isolate-unlisted-servers", false);
    private final Map<String, String> serverToGroup = new HashMap<String, String>();
    private final PlayerList playerlist = (PlayerList)TAB.getInstance().getFeatureManager().getFeature("PlayerList");

    public GlobalPlayerList() {
        for (Map.Entry<String, List<String>> entry : this.sharedServers.entrySet()) {
            TAB.getInstance().getPlaceholderManager().registerServerPlaceholder(TabConstants.Placeholder.globalPlayerListGroup(entry.getKey()), 1000, () -> {
                int count = 0;
                for (TabPlayer player : TAB.getInstance().getOnlinePlayers()) {
                    if (!((List)entry.getValue()).contains(player.getServer()) || player.isVanished()) continue;
                    ++count;
                }
                return count;
            });
        }
    }

    @Override
    public void load() {
        this.addUsedPlaceholder("%ping%");
        for (TabPlayer viewer : TAB.getInstance().getOnlinePlayers()) {
            ArrayList<TabList.Entry> entries = new ArrayList<TabList.Entry>();
            for (TabPlayer displayed : TAB.getInstance().getOnlinePlayers()) {
                if (viewer.getServer().equals(displayed.getServer()) || !this.shouldSee(viewer, displayed)) continue;
                entries.add(this.getAddInfoData(displayed, viewer));
            }
            if (entries.isEmpty()) continue;
            viewer.getTabList().addEntries(entries);
        }
    }

    public boolean shouldSee(@NotNull TabPlayer viewer, @NotNull TabPlayer displayed) {
        if (displayed == viewer) {
            return true;
        }
        if (!TAB.getInstance().getPlatform().canSee(viewer, displayed)) {
            return false;
        }
        if (this.isSpyServer(viewer.getServer())) {
            return true;
        }
        return this.getServerGroup(viewer.getServer()).equals(this.getServerGroup(displayed.getServer()));
    }

    @NotNull
    public String getServerGroup(@NotNull String playerServer) {
        return this.serverToGroup.computeIfAbsent(playerServer, server -> {
            for (Map.Entry<String, List<String>> group : this.sharedServers.entrySet()) {
                for (String serverDefinition : group.getValue()) {
                    if (!(serverDefinition.endsWith("*") ? server.toLowerCase().startsWith(serverDefinition.substring(0, serverDefinition.length() - 1).toLowerCase()) : (serverDefinition.startsWith("*") ? server.toLowerCase().endsWith(serverDefinition.substring(1).toLowerCase()) : server.equalsIgnoreCase(serverDefinition)))) continue;
                    return group.getKey();
                }
            }
            return this.isolateUnlistedServers ? "isolated:" + server : "DEFAULT";
        });
    }

    @Override
    public void unload() {
        for (TabPlayer displayed : TAB.getInstance().getOnlinePlayers()) {
            for (TabPlayer viewer : TAB.getInstance().getOnlinePlayers()) {
                if (displayed.getServer().equals(viewer.getServer())) continue;
                viewer.getTabList().removeEntry(displayed.getTablistId());
            }
        }
    }

    @Override
    public void onJoin(@NotNull TabPlayer connectedPlayer) {
        for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
            if (connectedPlayer.getServer().equals(all.getServer())) continue;
            if (this.shouldSee(all, connectedPlayer)) {
                all.getTabList().addEntry(this.getAddInfoData(connectedPlayer, all));
            }
            if (!this.shouldSee(connectedPlayer, all)) continue;
            connectedPlayer.getTabList().addEntry(this.getAddInfoData(all, connectedPlayer));
        }
    }

    @Override
    public void onQuit(@NotNull TabPlayer disconnectedPlayer) {
        for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
            if (all == disconnectedPlayer) continue;
            all.getTabList().removeEntry(disconnectedPlayer.getTablistId());
        }
    }

    @Override
    public void onServerChange(@NotNull TabPlayer changed, @NotNull String from, @NotNull String to) {
        TAB.getInstance().getCPUManager().runTaskLater(200, this.getFeatureName(), "Server Switch", () -> {
            for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
                if (all.getServer().equals(changed.getServer())) continue;
                all.getTabList().removeEntry(changed.getTablistId());
                if (!this.shouldSee(all, changed)) continue;
                all.getTabList().addEntry(this.getAddInfoData(changed, all));
            }
        });
    }

    @Override
    public void onTabListClear(@NotNull TabPlayer player) {
        for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
            if (all.getServer().equals(player.getServer()) || !this.shouldSee(player, all)) continue;
            player.getTabList().addEntry(this.getAddInfoData(all, player));
        }
    }

    @NotNull
    public TabList.Entry getAddInfoData(@NotNull TabPlayer p, @NotNull TabPlayer viewer) {
        TabComponent format = null;
        if (this.playerlist != null && !p.disabledPlayerList.get()) {
            format = this.playerlist.getTabFormat(p, viewer);
        }
        int gameMode = this.othersAsSpectators && !p.getServer().equals(viewer.getServer()) || this.vanishedAsSpectators && p.isVanished() ? 3 : p.getGamemode();
        return new TabList.Entry(p.getTablistId(), p.getNickname(), p.getSkin(), true, p.getPing(), gameMode, viewer.getVersion().getMinorVersion() >= 8 ? format : null);
    }

    @Override
    public void onGameModeChange(@NotNull TabPlayer player) {
        for (TabPlayer viewer : TAB.getInstance().getOnlinePlayers()) {
            if (player.getServer().equals(viewer.getServer())) continue;
            viewer.getTabList().updateGameMode(player.getTablistId(), this.othersAsSpectators ? 3 : player.getGamemode());
        }
    }

    @Override
    public void onVanishStatusChange(@NotNull TabPlayer p) {
        if (p.isVanished()) {
            for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
                if (all == p || this.shouldSee(all, p)) continue;
                all.getTabList().removeEntry(p.getTablistId());
            }
        } else {
            for (TabPlayer viewer : TAB.getInstance().getOnlinePlayers()) {
                if (viewer == p || !this.shouldSee(viewer, p)) continue;
                viewer.getTabList().addEntry(this.getAddInfoData(p, viewer));
            }
        }
    }

    public boolean isSpyServer(@NotNull String server) {
        return this.spyServers.contains(server.toLowerCase());
    }

    @Override
    public void refresh(@NotNull TabPlayer refreshed, boolean force) {
        for (TabPlayer viewer : TAB.getInstance().getOnlinePlayers()) {
            if (refreshed.getServer().equals(viewer.getServer()) || !viewer.getTabList().containsEntry(refreshed.getTablistId())) continue;
            viewer.getTabList().updateLatency(refreshed.getTablistId(), refreshed.getPing());
        }
    }

    @Override
    @NotNull
    public String getRefreshDisplayName() {
        return "Updating latency";
    }

    @Override
    @NotNull
    public String getFeatureName() {
        return "Global PlayerList";
    }
}

