/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features.nametags;

import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.features.nametags.NameTag;
import me.neznamy.tab.shared.features.types.JoinListener;
import me.neznamy.tab.shared.features.types.Loadable;
import me.neznamy.tab.shared.features.types.Refreshable;
import me.neznamy.tab.shared.features.types.TabFeature;
import me.neznamy.tab.shared.placeholders.conditions.Condition;
import me.neznamy.tab.shared.platform.TabPlayer;
import org.jetbrains.annotations.NotNull;

public class CollisionManager
extends TabFeature
implements JoinListener,
Loadable,
Refreshable {
    private final NameTag nameTags;
    private final Condition refreshCondition = Condition.getCondition(this.config().getString("scoreboard-teams.enable-collision", "true"));

    @Override
    public void load() {
        TAB.getInstance().getPlaceholderManager().registerPlayerPlaceholder("%collision%", 500, p -> {
            boolean newCollision;
            TabPlayer player = (TabPlayer)p;
            if (player.teamData.forcedCollision != null) {
                return player.teamData.forcedCollision;
            }
            player.teamData.collisionRule = newCollision = !((TabPlayer)p).isDisguised() && this.refreshCondition.isMet((TabPlayer)p);
            return newCollision;
        });
        this.addUsedPlaceholder("%collision%");
        for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
            this.onJoin(all);
        }
    }

    @Override
    public void onJoin(@NotNull TabPlayer connectedPlayer) {
        connectedPlayer.teamData.collisionRule = this.refreshCondition.isMet(connectedPlayer);
    }

    @Override
    public void refresh(@NotNull TabPlayer p, boolean force) {
        if (p.disabledNametags.get()) {
            return;
        }
        this.nameTags.updateTeamData(p);
    }

    @Override
    @NotNull
    public String getRefreshDisplayName() {
        return "Updating collision";
    }

    @Override
    @NotNull
    public String getFeatureName() {
        return this.nameTags.getFeatureName();
    }

    public CollisionManager(NameTag nameTags) {
        this.nameTags = nameTags;
    }
}

