/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.platform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.chat.EnumChatFormat;
import me.neznamy.tab.shared.chat.TabComponent;
import me.neznamy.tab.shared.chat.rgb.RGBUtils;
import me.neznamy.tab.shared.platform.TabPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Scoreboard<T extends TabPlayer, C> {
    private static String lastTeamOverrideMessage;
    protected final T player;
    private final Set<String> registeredTeams = new HashSet<String>();
    private final Set<String> registeredObjectives = new HashSet<String>();
    private final Map<String, String> expectedTeams = new HashMap<String, String>();
    private final Map<String, String> blockedTeamAdds = new HashMap<String, String>();
    private final Map<String, String> allowedTeamAdds = new HashMap<String, String>();
    private boolean frozen;
    private boolean antiOverrideTeams;

    public final void setDisplaySlot(int slot, @NonNull String objective) {
        if (objective == null) {
            throw new NullPointerException("objective is marked non-null but is null");
        }
        if (this.frozen) {
            return;
        }
        this.setDisplaySlot0(slot, objective);
    }

    public final void setScore(@NonNull String objective, @NonNull String scoreHolder, int score, @Nullable TabComponent displayName, @Nullable TabComponent numberFormat) {
        if (objective == null) {
            throw new NullPointerException("objective is marked non-null but is null");
        }
        if (scoreHolder == null) {
            throw new NullPointerException("scoreHolder is marked non-null but is null");
        }
        if (this.frozen) {
            return;
        }
        if (!this.registeredObjectives.contains(objective)) {
            this.error("Tried to update score (%s) without the existence of its requested objective '%s' to player ", scoreHolder, objective);
            return;
        }
        this.setScore0(objective, scoreHolder, score, displayName == null ? null : (C)displayName.convert(((TabPlayer)this.player).getVersion()), numberFormat == null ? null : (C)numberFormat.convert(((TabPlayer)this.player).getVersion()));
    }

    public final void removeScore(@NonNull String objective, @NonNull String scoreHolder) {
        if (objective == null) {
            throw new NullPointerException("objective is marked non-null but is null");
        }
        if (scoreHolder == null) {
            throw new NullPointerException("scoreHolder is marked non-null but is null");
        }
        if (this.frozen) {
            return;
        }
        if (!this.registeredObjectives.contains(objective)) {
            this.error("Tried to remove score (%s) without the existence of its requested objective '%s' to player ", scoreHolder, objective);
            return;
        }
        this.removeScore0(objective, scoreHolder);
    }

    public final void registerObjective(@NonNull String objectiveName, @NonNull String title, int display, @Nullable TabComponent numberFormat) {
        if (objectiveName == null) {
            throw new NullPointerException("objectiveName is marked non-null but is null");
        }
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (this.frozen) {
            return;
        }
        if (!this.registeredObjectives.add(objectiveName)) {
            this.error("Tried to register duplicated objective %s to player ", objectiveName);
            return;
        }
        this.registerObjective0(objectiveName, this.cutTo(title, 32), display, numberFormat == null ? null : (C)numberFormat.convert(((TabPlayer)this.player).getVersion()));
    }

    public final void unregisterObjective(@NonNull String objectiveName) {
        if (objectiveName == null) {
            throw new NullPointerException("objectiveName is marked non-null but is null");
        }
        if (this.frozen) {
            return;
        }
        if (!this.registeredObjectives.remove(objectiveName)) {
            this.error("Tried to unregister non-existing objective %s for player ", objectiveName);
            return;
        }
        this.unregisterObjective0(objectiveName);
    }

    public final void updateObjective(@NonNull String objectiveName, @NonNull String title, int display, @Nullable TabComponent numberFormat) {
        if (objectiveName == null) {
            throw new NullPointerException("objectiveName is marked non-null but is null");
        }
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (this.frozen) {
            return;
        }
        if (!this.registeredObjectives.contains(objectiveName)) {
            this.error("Tried to modify non-existing objective %s for player ", objectiveName);
            return;
        }
        this.updateObjective0(objectiveName, this.cutTo(title, 32), display, numberFormat == null ? null : (C)numberFormat.convert(((TabPlayer)this.player).getVersion()));
    }

    public final void registerTeam(@NonNull String name, @NonNull String prefix, @NonNull String suffix, @NonNull NameVisibility visibility, @NonNull CollisionRule collision, @NonNull Collection<String> players, int options, @NonNull EnumChatFormat color) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (prefix == null) {
            throw new NullPointerException("prefix is marked non-null but is null");
        }
        if (suffix == null) {
            throw new NullPointerException("suffix is marked non-null but is null");
        }
        if (visibility == null) {
            throw new NullPointerException("visibility is marked non-null but is null");
        }
        if (collision == null) {
            throw new NullPointerException("collision is marked non-null but is null");
        }
        if (players == null) {
            throw new NullPointerException("players is marked non-null but is null");
        }
        if (color == null) {
            throw new NullPointerException("color is marked non-null but is null");
        }
        if (this.frozen) {
            return;
        }
        if (!this.registeredTeams.add(name)) {
            this.error("Tried to register duplicated team %s to player ", name);
            return;
        }
        for (String player : players) {
            this.expectedTeams.put(player, name);
        }
        this.registerTeam0(name, this.cutTo(prefix, 16), this.cutTo(suffix, 16), visibility, collision, players, options, color);
    }

    public final void unregisterTeam(@NonNull String teamName) {
        if (teamName == null) {
            throw new NullPointerException("teamName is marked non-null but is null");
        }
        if (this.frozen) {
            return;
        }
        if (!this.registeredTeams.remove(teamName)) {
            this.error("Tried to unregister non-existing team %s for player ", teamName);
            return;
        }
        for (Map.Entry<String, String> entry : this.expectedTeams.entrySet()) {
            if (!entry.getValue().equals(teamName)) continue;
            this.expectedTeams.remove(entry.getKey());
            break;
        }
        this.unregisterTeam0(teamName);
    }

    public final void updateTeam(@NonNull String name, @NonNull String prefix, @NonNull String suffix, @NonNull NameVisibility visibility, @NonNull CollisionRule collision, int options, @NonNull EnumChatFormat color) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (prefix == null) {
            throw new NullPointerException("prefix is marked non-null but is null");
        }
        if (suffix == null) {
            throw new NullPointerException("suffix is marked non-null but is null");
        }
        if (visibility == null) {
            throw new NullPointerException("visibility is marked non-null but is null");
        }
        if (collision == null) {
            throw new NullPointerException("collision is marked non-null but is null");
        }
        if (color == null) {
            throw new NullPointerException("color is marked non-null but is null");
        }
        if (this.frozen) {
            return;
        }
        if (!this.registeredTeams.contains(name)) {
            this.error("Tried to modify non-existing team %s for player ", name);
            return;
        }
        this.updateTeam0(name, this.cutTo(prefix, 16), this.cutTo(suffix, 16), visibility, collision, options, color);
    }

    private void error(@NonNull String format, Object ... args) {
        if (format == null) {
            throw new NullPointerException("format is marked non-null but is null");
        }
        if (args == null) {
            throw new NullPointerException("args is marked non-null but is null");
        }
        TAB.getInstance().debug(String.format(format, args) + ((TabPlayer)this.player).getName());
    }

    public void freeze() {
        this.frozen = true;
    }

    public void unfreeze() {
        this.registeredTeams.clear();
        this.registeredObjectives.clear();
        this.frozen = false;
    }

    private String cutTo(@Nullable String string, int length) {
        if (((TabPlayer)this.player).getVersion().getMinorVersion() >= 13) {
            return string;
        }
        if (string == null) {
            return "";
        }
        String legacyText = string;
        if (string.contains("#")) {
            legacyText = RGBUtils.getInstance().convertRGBtoLegacy(string);
        }
        if (legacyText.length() <= length) {
            return legacyText;
        }
        if (legacyText.charAt(length - 1) == '\u00a7') {
            return legacyText.substring(0, length - 1);
        }
        return legacyText.substring(0, length);
    }

    public void onPacketSend(@NonNull Object packet) {
        if (packet == null) {
            throw new NullPointerException("packet is marked non-null but is null");
        }
    }

    public boolean containsTeam(@NonNull String teamName) {
        if (teamName == null) {
            throw new NullPointerException("teamName is marked non-null but is null");
        }
        return this.registeredTeams.contains(teamName);
    }

    @NotNull
    public Collection<String> onTeamPacket(int action, @NonNull String teamName, @NonNull Collection<String> players) {
        if (teamName == null) {
            throw new NullPointerException("teamName is marked non-null but is null");
        }
        if (players == null) {
            throw new NullPointerException("players is marked non-null but is null");
        }
        ArrayList<String> newList = new ArrayList<String>();
        if (action == 0 || action == 3) {
            for (String entry2 : players) {
                String expectedTeam = this.expectedTeams.get(entry2);
                if (expectedTeam == null) {
                    this.blockedTeamAdds.remove(entry2);
                    this.allowedTeamAdds.put(entry2, teamName);
                    newList.add(entry2);
                    continue;
                }
                if (teamName.equals(expectedTeam)) {
                    newList.add(entry2);
                    this.allowedTeamAdds.remove(entry2);
                    continue;
                }
                this.blockedTeamAdds.put(entry2, teamName);
                Scoreboard.logTeamOverride(teamName, entry2, expectedTeam);
            }
            return newList;
        }
        if (action == 4) {
            for (String entry3 : players) {
                String expectedTeam = this.expectedTeams.get(entry3);
                if (expectedTeam != null) {
                    this.allowedTeamAdds.remove(entry3);
                    this.blockedTeamAdds.remove(entry3);
                    continue;
                }
                if (this.allowedTeamAdds.containsKey(entry3)) {
                    this.allowedTeamAdds.remove(entry3);
                    newList.add(entry3);
                    continue;
                }
                this.blockedTeamAdds.remove(entry3);
            }
            return newList;
        }
        if (action == 1) {
            this.allowedTeamAdds.entrySet().removeIf(entry -> ((String)entry.getValue()).equals(teamName));
            this.blockedTeamAdds.entrySet().removeIf(entry -> ((String)entry.getValue()).equals(teamName));
        }
        return players;
    }

    public static void logTeamOverride(@NonNull String team, @NonNull String player, @NonNull String expectedTeam) {
        if (team == null) {
            throw new NullPointerException("team is marked non-null but is null");
        }
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (expectedTeam == null) {
            throw new NullPointerException("expectedTeam is marked non-null but is null");
        }
        String message = "Blocked attempt to add player " + player + " into team " + team + " (expected team: " + expectedTeam + ")";
        if (!message.equals(lastTeamOverrideMessage)) {
            lastTeamOverrideMessage = message;
            TAB.getInstance().getErrorManager().printError(message, Collections.emptyList(), false, TAB.getInstance().getErrorManager().getAntiOverrideLog());
        }
    }

    protected abstract void setDisplaySlot0(int var1, @NonNull String var2);

    protected abstract void setScore0(@NonNull String var1, @NonNull String var2, int var3, @Nullable C var4, @Nullable C var5);

    protected abstract void removeScore0(@NonNull String var1, @NonNull String var2);

    protected abstract void registerObjective0(@NonNull String var1, @NonNull String var2, int var3, @Nullable C var4);

    protected abstract void unregisterObjective0(@NonNull String var1);

    protected abstract void updateObjective0(@NonNull String var1, @NonNull String var2, int var3, @Nullable C var4);

    protected abstract void registerTeam0(@NonNull String var1, @NonNull String var2, @NonNull String var3, @NonNull NameVisibility var4, @NonNull CollisionRule var5, @NonNull Collection<String> var6, int var7, @NonNull EnumChatFormat var8);

    protected abstract void unregisterTeam0(@NonNull String var1);

    protected abstract void updateTeam0(@NonNull String var1, @NonNull String var2, @NonNull String var3, @NonNull NameVisibility var4, @NonNull CollisionRule var5, int var6, @NonNull EnumChatFormat var7);

    public Scoreboard(T player) {
        this.player = player;
    }

    public boolean isAntiOverrideTeams() {
        return this.antiOverrideTeams;
    }

    public void setAntiOverrideTeams(boolean antiOverrideTeams) {
        this.antiOverrideTeams = antiOverrideTeams;
    }

    public static enum NameVisibility {
        ALWAYS("always"),
        NEVER("never"),
        HIDE_FOR_OTHER_TEAMS("hideForOtherTeams"),
        HIDE_FOR_OWN_TEAM("hideForOwnTeam");

        private static final Map<String, NameVisibility> BY_NAME;
        private final String string;

        public String toString() {
            return this.string;
        }

        public static NameVisibility getByName(String name) {
            return BY_NAME.getOrDefault(name, ALWAYS);
        }

        private NameVisibility(String string2) {
            this.string = string2;
        }

        static {
            BY_NAME = Arrays.stream(NameVisibility.values()).collect(Collectors.toMap(visibility -> visibility.string, visibility -> visibility));
        }
    }

    public static enum CollisionRule {
        ALWAYS("always"),
        NEVER("never"),
        PUSH_OTHER_TEAMS("pushOtherTeams"),
        PUSH_OWN_TEAM("pushOwnTeam");

        private static final Map<String, CollisionRule> BY_NAME;
        private final String string;

        public String toString() {
            return this.string;
        }

        @NotNull
        public static CollisionRule getByName(@NotNull String name) {
            return BY_NAME.getOrDefault(name, ALWAYS);
        }

        private CollisionRule(String string2) {
            this.string = string2;
        }

        static {
            BY_NAME = Arrays.stream(CollisionRule.values()).collect(Collectors.toMap(collisionRule -> collisionRule.string, collisionRule -> collisionRule));
        }
    }

    public static class TeamAction {
        public static final int CREATE = 0;
        public static final int REMOVE = 1;
        public static final int UPDATE = 2;
        public static final int ADD_PLAYER = 3;
        public static final int REMOVE_PLAYER = 4;
    }

    public static class ScoreAction {
        public static final int CHANGE = 0;
        public static final int REMOVE = 1;
    }

    public static class DisplaySlot {
        public static final int PLAYER_LIST = 0;
        public static final int SIDEBAR = 1;
        public static final int BELOW_NAME = 2;
    }

    public static class HealthDisplay {
        public static final int INTEGER = 0;
        public static final int HEARTS = 1;
    }

    public static class ObjectiveAction {
        public static final int REGISTER = 0;
        public static final int UNREGISTER = 1;
        public static final int UPDATE = 2;
    }
}

