/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.chatbox;

import cc.reconnected.chatbox.RccChatbox;
import cc.reconnected.chatbox.api.events.ChatboxMessageEvents;
import cc.reconnected.chatbox.license.Capability;
import cc.reconnected.chatbox.models.User;
import cc.reconnected.chatbox.packets.clientPackets.SayPacket;
import cc.reconnected.chatbox.packets.serverPackets.ErrorPacket;
import cc.reconnected.chatbox.packets.serverPackets.SuccessPacket;
import cc.reconnected.chatbox.packets.serverPackets.events.ChatboxChatEvent;
import cc.reconnected.chatbox.utils.DateUtils;
import cc.reconnected.chatbox.utils.TextComponents;
import cc.reconnected.chatbox.utils.Webhook;
import cc.reconnected.chatbox.ws.ClientErrors;
import cc.reconnected.library.data.PlayerMeta;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.json.JSONComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import org.java_websocket.WebSocket;
import org.jetbrains.annotations.Nullable;

public class ClientPacketsHandler {
    public static final int maxMessageQueSize = 5;
    private static final ConcurrentHashMap<UUID, ConcurrentLinkedQueue<ClientMessage>> messageQueue = new ConcurrentHashMap();
    private static MinecraftServer mcServer;

    private static boolean tryEnqueue(UUID licenseId, ClientMessage message) {
        ConcurrentLinkedQueue queue = messageQueue.computeIfAbsent(licenseId, id -> new ConcurrentLinkedQueue());
        if (queue.size() >= 5) {
            return false;
        }
        return queue.offer(message);
    }

    private static void tickQueue(MinecraftServer server) {
        if (server.method_3780() % 10 != 0) {
            return;
        }
        for (Map.Entry<UUID, ConcurrentLinkedQueue<ClientMessage>> entry : messageQueue.entrySet()) {
            UUID uuid = entry.getKey();
            ConcurrentLinkedQueue<ClientMessage> queue = entry.getValue();
            ClientMessage msg = queue.poll();
            if (msg == null) {
                messageQueue.remove(uuid);
                continue;
            }
            if (msg.type == MessageTypes.SAY) {
                Webhook.send(uuid, msg, null);
                mcServer.method_3760().method_14571().forEach(player -> player.sendMessage(msg.message));
                msg.conn.send(RccChatbox.GSON.toJson((Object)new SuccessPacket("message_sent", msg.id)));
                if (msg.sayPacket == null) continue;
                ChatboxChatEvent chatboxChatPacket = new ChatboxChatEvent();
                chatboxChatPacket.text = PlainTextComponentSerializer.plainText().serialize(Objects.requireNonNull(msg.content));
                chatboxChatPacket.name = PlainTextComponentSerializer.plainText().serialize(Objects.requireNonNull(msg.label));
                chatboxChatPacket.rawText = msg.sayPacket.text;
                chatboxChatPacket.rawName = msg.sayPacket.name != null ? msg.sayPacket.name : chatboxChatPacket.name;
                String json = (String)JSONComponentSerializer.json().serialize(msg.content);
                class_5250 mcText = class_2561.class_2562.method_10877((String)json);
                chatboxChatPacket.renderedText = class_2561.class_2562.method_10868((class_2561)mcText);
                chatboxChatPacket.time = DateUtils.getTime(new Date());
                chatboxChatPacket.user = msg.ownerUser;
                RccChatbox.getInstance().wss().broadcastEvent(chatboxChatPacket, Capability.READ);
                continue;
            }
            if (msg.type != MessageTypes.TELL) continue;
            class_3222 player2 = server.method_3760().method_14602(msg.player);
            if (player2 == null) {
                ClientErrors err = ClientErrors.UNKNOWN_USER;
                msg.conn.send(RccChatbox.GSON.toJson((Object)new ErrorPacket(err.getErrorMessage(), err.message, msg.id)));
                continue;
            }
            Webhook.send(uuid, msg, player2);
            player2.sendMessage(msg.message);
            msg.conn.send(RccChatbox.GSON.toJson((Object)new SuccessPacket("message_sent", msg.id)));
        }
    }

    private static String enqueueAndResult(UUID licenseId, ClientMessage message, int id) {
        if (ClientPacketsHandler.tryEnqueue(licenseId, message)) {
            return RccChatbox.GSON.toJson((Object)new SuccessPacket("message_queued", id));
        }
        ClientErrors err = ClientErrors.RATE_LIMITED;
        return RccChatbox.GSON.toJson((Object)new ErrorPacket(err.getErrorMessage(), err.message, id));
    }

    public static void register() {
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            mcServer = server;
        });
        ServerTickEvents.END_SERVER_TICK.register(ClientPacketsHandler::tickQueue);
        ChatboxMessageEvents.SAY.register((client, packet) -> {
            UUID ownerId = client.license.userId();
            PlayerMeta owner = PlayerMeta.getPlayer((UUID)ownerId);
            String name = packet.name != null ? packet.name : owner.getEffectiveName();
            Component label = TextComponents.formatLabel(name);
            Component content = TextComponents.formatContent(packet.text, packet.mode);
            Component message = ((TextComponent)Component.empty().append(TextComponents.sayPrefix)).appendSpace().append(TextComponents.buildChatbotMessage(label, content, owner));
            ClientMessage fullMessage = new ClientMessage(client.webSocket, packet.id != null ? packet.id : -1, MessageTypes.SAY, message, null, client.license.user, packet, label, content);
            client.webSocket.send(ClientPacketsHandler.enqueueAndResult(client.license.uuid(), fullMessage, packet.id));
        });
        ChatboxMessageEvents.TELL.register((client, packet) -> {
            UUID ownerId = client.license.userId();
            PlayerMeta owner = PlayerMeta.getPlayer((UUID)ownerId);
            class_3222 player = mcServer.method_3760().method_14566(packet.user);
            if (player == null) {
                ClientErrors err = ClientErrors.UNKNOWN_USER;
                client.webSocket.send(RccChatbox.GSON.toJson((Object)new ErrorPacket(err.getErrorMessage(), err.message, packet.id)));
                return;
            }
            String name = packet.name != null ? packet.name : owner.getEffectiveName();
            Component label = TextComponents.formatLabel(name);
            Component content = TextComponents.formatContent(packet.text, packet.mode);
            Component message = ((TextComponent)Component.empty().append(TextComponents.tellPrefix)).appendSpace().append(TextComponents.buildChatbotMessage(label, content, owner));
            ClientMessage fullMessage = new ClientMessage(client.webSocket, packet.id != null ? packet.id : -1, MessageTypes.TELL, message, player.method_5667(), client.license.user, null, null, null);
            client.webSocket.send(ClientPacketsHandler.enqueueAndResult(client.license.uuid(), fullMessage, packet.id));
        });
    }

    public record ClientMessage(WebSocket conn, int id, MessageTypes type, Component message, @Nullable UUID player, User ownerUser, @Nullable SayPacket sayPacket, @Nullable Component label, @Nullable Component content) {
    }

    public static enum MessageTypes {
        TELL,
        SAY;

    }
}

