/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.chatbox.listeners;

import cc.reconnected.chatbox.RccChatbox;
import cc.reconnected.chatbox.license.Capability;
import cc.reconnected.chatbox.models.DiscordUser;
import cc.reconnected.chatbox.packets.serverPackets.events.DiscordChatEvent;
import cc.reconnected.chatbox.utils.DateUtils;
import cc.reconnected.discordbridge.events.DiscordMessageEvents;
import cc.reconnected.library.text.parser.MarkdownParser;
import java.time.OffsetDateTime;
import java.util.Date;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.minecraft.class_2561;

public class DiscordEvents {
    public static void register() {
        DiscordMessageEvents.MESSAGE_CREATE.register((message, member) -> DiscordEvents.emitDiscordChatEvent(message, member, false));
        DiscordMessageEvents.MESSAGE_EDIT.register((message, member) -> DiscordEvents.emitDiscordChatEvent(message, member, true));
    }

    private static void emitDiscordChatEvent(Message message, Member member, boolean isEdited) {
        DiscordUser user = DiscordUser.fromMember(member, true);
        DiscordChatEvent packet = new DiscordChatEvent();
        packet.text = message.getContentStripped();
        packet.rawText = message.getContentRaw();
        packet.renderedText = class_2561.class_2562.method_10868((class_2561)MarkdownParser.defaultParser.parseNode(message.getContentDisplay()).toText());
        packet.discordId = message.getId();
        packet.discordUser = user;
        packet.edited = isEdited;
        OffsetDateTime messageOffsetDate = isEdited ? message.getTimeEdited() : message.getTimeCreated();
        Date messageDate = messageOffsetDate != null ? new Date(messageOffsetDate.toInstant().toEpochMilli()) : new Date();
        packet.time = DateUtils.getTime(messageDate);
        RccChatbox.getInstance().wss().broadcastEvent(packet, Capability.READ);
    }
}

