/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.chatbox.models;

import cc.reconnected.chatbox.models.DiscordRole;
import cc.reconnected.chatbox.models.User;
import cc.reconnected.discordbridge.RccDiscord;
import java.util.List;
import java.util.UUID;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Role;
import org.jetbrains.annotations.Nullable;

public class DiscordUser {
    public String type = "discord";
    public String id;
    public String name;
    public String displayName;
    public String discriminator;
    public String avatar;
    public DiscordRole[] roles;
    @Nullable
    public User linkedUser;

    public static DiscordUser fromMember(Member member, boolean resolveLinkedUser) {
        DiscordUser user = new DiscordUser();
        user.id = member.getUser().getId();
        user.discriminator = member.getUser().getDiscriminator();
        user.name = member.getUser().getName();
        user.displayName = member.getEffectiveName();
        user.avatar = member.getUser().getAvatarUrl();
        user.linkedUser = null;
        List roles = member.getRoles();
        user.roles = new DiscordRole[roles.size()];
        for (int i = 0; i < roles.size(); ++i) {
            DiscordRole lRole;
            Role role = (Role)roles.get(i);
            user.roles[i] = lRole = new DiscordRole();
            lRole.id = role.getId();
            lRole.name = role.getName();
            lRole.colour = role.getColorRaw();
        }
        if (resolveLinkedUser && RccDiscord.discordLinks.containsKey(user.id)) {
            UUID playerUuid = (UUID)RccDiscord.discordLinks.get(user.id);
            user.linkedUser = User.tryGet(playerUuid, false);
        }
        return user;
    }

    public static DiscordUser fromMember(Member member) {
        return DiscordUser.fromMember(member, false);
    }
}

