/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.chatbox.utils;

import cc.reconnected.chatbox.parsers.MiniMessageSerializer;
import cc.reconnected.library.data.PlayerMeta;
import cc.reconnected.library.text.parser.MarkdownParser;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.serializer.json.JSONComponentSerializer;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public class TextComponents {
    public static final LegacyComponentSerializer legacySerializer = LegacyComponentSerializer.legacyAmpersand();
    public static final Component tellPrefix = ((TextComponent)((TextComponent)Component.empty().append((Component)Component.text((String)"[", (TextColor)NamedTextColor.GRAY))).append(((TextComponent)Component.text((String)"CB PM").color((TextColor)NamedTextColor.DARK_GRAY)).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"This message was privately sent to you by an automated chatbot."))))).append((Component)Component.text((String)"]", (TextColor)NamedTextColor.GRAY));
    public static final Component sayPrefix = ((TextComponent)((TextComponent)Component.empty().append((Component)Component.text((String)"[", (TextColor)NamedTextColor.GRAY))).append(((TextComponent)Component.text((String)"CB").color((TextColor)NamedTextColor.DARK_GRAY)).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"This message was publicly sent by an automated chatbot."))))).append((Component)Component.text((String)"]", (TextColor)NamedTextColor.GRAY));

    public static Component addLabelInfo(Component name, PlayerMeta owner) {
        TextComponent ownerMeta = Component.text((String)("Owned by " + owner.getEffectiveName()));
        return name.hoverEvent((HoverEventSource)HoverEvent.showText((Component)ownerMeta));
    }

    public static Component formatLabel(String name) {
        return legacySerializer.deserialize(name.trim());
    }

    public static Component formatContent(String content, @Nullable String type) {
        content = content.trim();
        return switch (type = type != null ? type : "unknown") {
            case "format" -> legacySerializer.deserialize(content);
            case "markdown" -> {
                class_2561 rawContent = MarkdownParser.defaultParser.parseNode(content).toText();
                JSONComponentSerializer json = JSONComponentSerializer.json();
                yield json.deserialize((Object)class_2561.class_2562.method_10867((class_2561)rawContent));
            }
            case "minimessage" -> MiniMessageSerializer.defaultSerializer.deserialize((Object)content);
            default -> Component.text((String)content);
        };
    }

    public static Component buildChatbotMessage(Component label, Component content, PlayerMeta owner) {
        return ((TextComponent)((TextComponent)Component.empty().append(TextComponents.addLabelInfo(label, owner))).append((Component)Component.text((char)':', (TextColor)NamedTextColor.GRAY))).appendSpace().append(content);
    }
}

