/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.chatbox.utils;

import cc.reconnected.chatbox.ClientPacketsHandler;
import cc.reconnected.chatbox.RccChatbox;
import cc.reconnected.chatbox.license.License;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.UUID;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class Webhook {
    private static final HttpClient http = HttpClient.newHttpClient();

    private static void send(JsonObject body) {
        String url = RccChatbox.CONFIG.webhook;
        if (url == null) {
            return;
        }
        try {
            HttpRequest request = HttpRequest.newBuilder().POST(HttpRequest.BodyPublishers.ofString(body.toString())).uri(URI.create(url)).header("Content-Type", "application/json").build();
            HttpResponse<String> response = http.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() / 100 != 2) {
                RccChatbox.LOGGER.error("Received {} as status code!\n{}", (Object)response.statusCode(), (Object)response.body());
            }
        }
        catch (Exception e) {
            RccChatbox.LOGGER.error("Could not send webhook message!", (Throwable)e);
        }
    }

    public static void send(UUID licenseId, ClientPacketsHandler.ClientMessage message, @Nullable class_3222 recipient) {
        License license = RccChatbox.licenseManager().getLicense(licenseId);
        String label = null;
        if (message.label() != null) {
            label = PlainTextComponentSerializer.plainText().serialize(message.label());
        }
        String text = PlainTextComponentSerializer.plainText().serialize(message.message());
        String recipientName = null;
        if (recipient != null) {
            recipientName = recipient.method_7334().getName();
        }
        JsonObject json = Webhook.build(license, label, text, message.type(), recipientName);
        Webhook.send(json);
    }

    public static JsonObject build(License license, String label, String content, ClientPacketsHandler.MessageTypes type, @Nullable String toUser) {
        JsonObject json = new JsonObject();
        json.addProperty("flags", (Number)4096);
        JsonObject embed = new JsonObject();
        embed.addProperty("title", label != null ? label : license.user.name);
        embed.addProperty("description", content);
        int color = switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case ClientPacketsHandler.MessageTypes.TELL -> NamedTextColor.BLUE.value();
            case ClientPacketsHandler.MessageTypes.SAY -> NamedTextColor.GOLD.value();
        };
        embed.addProperty("color", (Number)color);
        JsonArray fields = new JsonArray();
        JsonObject typeField = new JsonObject();
        typeField.addProperty("name", "Type");
        typeField.addProperty("value", type.toString());
        typeField.addProperty("inline", Boolean.valueOf(true));
        JsonObject licenseField = new JsonObject();
        licenseField.addProperty("name", "License");
        licenseField.addProperty("value", license.uuid().toString());
        licenseField.addProperty("inline", Boolean.valueOf(true));
        fields.add((JsonElement)typeField);
        fields.add((JsonElement)licenseField);
        if (toUser != null) {
            JsonObject userField = new JsonObject();
            userField.addProperty("name", "Recipient");
            userField.addProperty("value", toUser);
            userField.addProperty("inline", Boolean.valueOf(true));
            fields.add((JsonElement)userField);
        }
        JsonObject author = new JsonObject();
        author.addProperty("name", String.format("%s (%s)", license.user.name, license.user.uuid));
        embed.add("fields", (JsonElement)fields);
        embed.add("author", (JsonElement)author);
        JsonArray embeds = new JsonArray();
        embeds.add((JsonElement)embed);
        json.add("embeds", (JsonElement)embeds);
        return json;
    }
}

