/*
 * Decompiled with CFR 0.152.
 */
package io.sc3.plethora.core;

import dan200.computercraft.api.peripheral.IComputerAccess;
import io.sc3.plethora.api.method.IAttachable;
import io.sc3.plethora.core.MethodWrapperPeripheral;
import io.sc3.plethora.core.RegisteredMethod;
import io.sc3.plethora.core.UnbakedContext;
import io.sc3.plethora.core.executor.TaskRunner;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import net.minecraft.class_3545;

public class AttachableWrapperPeripheral
extends MethodWrapperPeripheral {
    private final Collection<IAttachable> attachments;
    private final AtomicInteger count = new AtomicInteger(0);

    public AttachableWrapperPeripheral(String name, Object owner, class_3545<List<RegisteredMethod<?>>, List<UnbakedContext<?>>> methods, TaskRunner runner, Collection<IAttachable> attachments) {
        super(name, owner, methods, runner);
        this.attachments = attachments;
    }

    @Override
    public void attach(@Nonnull IComputerAccess access) {
        super.attach(access);
        int count = this.count.getAndIncrement();
        if (count == 0) {
            for (IAttachable attachable : this.attachments) {
                attachable.attach();
            }
        }
    }

    @Override
    public void detach(@Nonnull IComputerAccess access) {
        super.detach(access);
        int count = this.count.decrementAndGet();
        if (count == 0) {
            for (IAttachable attachable : this.attachments) {
                attachable.detach();
            }
        }
    }
}

