/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.server;

import cc.reconnected.server.api.events.RccEvents;
import cc.reconnected.server.commands.admin.FlyCommand;
import cc.reconnected.server.commands.admin.GodCommand;
import cc.reconnected.server.commands.admin.RccCommand;
import cc.reconnected.server.commands.admin.RestartCommand;
import cc.reconnected.server.commands.admin.TimeBarCommand;
import cc.reconnected.server.commands.home.DeleteHomeCommand;
import cc.reconnected.server.commands.home.HomeCommand;
import cc.reconnected.server.commands.home.SetHomeCommand;
import cc.reconnected.server.commands.misc.AfkCommand;
import cc.reconnected.server.commands.misc.NearCommand;
import cc.reconnected.server.commands.spawn.SetSpawnCommand;
import cc.reconnected.server.commands.spawn.SpawnCommand;
import cc.reconnected.server.commands.teleport.BackCommand;
import cc.reconnected.server.commands.teleport.TeleportAcceptCommand;
import cc.reconnected.server.commands.teleport.TeleportAskCommand;
import cc.reconnected.server.commands.teleport.TeleportAskHereCommand;
import cc.reconnected.server.commands.teleport.TeleportDenyCommand;
import cc.reconnected.server.commands.tell.ReplyCommand;
import cc.reconnected.server.commands.tell.TellCommand;
import cc.reconnected.server.commands.warp.DeleteWarpCommand;
import cc.reconnected.server.commands.warp.SetWarpCommand;
import cc.reconnected.server.commands.warp.WarpCommand;
import cc.reconnected.server.config.Config;
import cc.reconnected.server.config.ConfigManager;
import cc.reconnected.server.core.AfkTracker;
import cc.reconnected.server.core.AutoRestart;
import cc.reconnected.server.core.BackTracker;
import cc.reconnected.server.core.BossBarManager;
import cc.reconnected.server.core.HttpApiServer;
import cc.reconnected.server.core.TabList;
import cc.reconnected.server.core.TeleportTracker;
import cc.reconnected.server.core.customChat.CustomChatMessage;
import cc.reconnected.server.data.PlayerState;
import cc.reconnected.server.data.ServerState;
import cc.reconnected.server.data.StateManager;
import cc.reconnected.server.struct.ServerPosition;
import com.mojang.brigadier.CommandDispatcher;
import java.util.Date;
import java.util.UUID;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.message.v1.ServerMessageEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.kyori.adventure.platform.fabric.FabricServerAudiences;
import net.kyori.adventure.text.Component;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.minecraft.class_2168;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.class_5321;
import net.minecraft.class_7471;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RccServer
implements ModInitializer {
    public static final String MOD_ID = "rcc-server";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"rcc-server");
    public static Config CONFIG = ConfigManager.load();
    public static final StateManager state = new StateManager();
    private static RccServer INSTANCE;
    private LuckPerms luckPerms;
    public static MinecraftServer server;
    private volatile FabricServerAudiences adventure;
    public static final class_5321<class_2556> CHAT_TYPE;

    public static RccServer getInstance() {
        return INSTANCE;
    }

    public RccServer() {
        INSTANCE = this;
    }

    public LuckPerms luckPerms() {
        return this.luckPerms;
    }

    public FabricServerAudiences adventure() {
        FabricServerAudiences ret = this.adventure;
        if (ret == null) {
            throw new IllegalStateException("Tried to access Adventure without a running server!");
        }
        return ret;
    }

    public void onInitialize() {
        LOGGER.info("Starting rcc-server");
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            RccServer.server = server;
            state.register(server.method_27050(class_5218.field_24188).resolve("data").resolve(MOD_ID));
            this.adventure = FabricServerAudiences.of((MinecraftServer)server);
        });
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> {
            this.adventure = null;
        });
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            RccCommand.register((CommandDispatcher<class_2168>)dispatcher);
            AfkCommand.register((CommandDispatcher<class_2168>)dispatcher);
            TellCommand.register((CommandDispatcher<class_2168>)dispatcher);
            ReplyCommand.register((CommandDispatcher<class_2168>)dispatcher);
            TeleportAskCommand.register((CommandDispatcher<class_2168>)dispatcher);
            TeleportAskHereCommand.register((CommandDispatcher<class_2168>)dispatcher);
            TeleportAcceptCommand.register((CommandDispatcher<class_2168>)dispatcher);
            TeleportDenyCommand.register((CommandDispatcher<class_2168>)dispatcher);
            BackCommand.register((CommandDispatcher<class_2168>)dispatcher);
            FlyCommand.register((CommandDispatcher<class_2168>)dispatcher);
            GodCommand.register((CommandDispatcher<class_2168>)dispatcher);
            SetSpawnCommand.register((CommandDispatcher<class_2168>)dispatcher);
            SpawnCommand.register((CommandDispatcher<class_2168>)dispatcher);
            HomeCommand.register((CommandDispatcher<class_2168>)dispatcher);
            SetHomeCommand.register((CommandDispatcher<class_2168>)dispatcher);
            DeleteHomeCommand.register((CommandDispatcher<class_2168>)dispatcher);
            WarpCommand.register((CommandDispatcher<class_2168>)dispatcher);
            SetWarpCommand.register((CommandDispatcher<class_2168>)dispatcher);
            DeleteWarpCommand.register((CommandDispatcher<class_2168>)dispatcher);
            TimeBarCommand.register((CommandDispatcher<class_2168>)dispatcher);
            RestartCommand.register((CommandDispatcher<class_2168>)dispatcher);
            NearCommand.register((CommandDispatcher<class_2168>)dispatcher);
        });
        AfkTracker.register();
        TeleportTracker.register();
        BackTracker.register();
        TabList.register();
        HttpApiServer.register();
        BossBarManager.register();
        AutoRestart.register();
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            this.luckPerms = LuckPermsProvider.get();
            ((RccEvents.Ready)RccEvents.READY.invoker()).onReady(server, this.luckPerms);
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            class_3222 player = handler.method_32311();
            PlayerState playerState = state.getPlayerState(player.method_5667());
            if (playerState.firstJoinedDate == null) {
                LOGGER.info("Player {} joined for the first time!", (Object)player.method_7334().getName());
                playerState.firstJoinedDate = new Date();
                ((RccEvents.Welcome)RccEvents.WELCOME.invoker()).onWelcome(player, server);
                ServerState serverState = state.getServerState();
                ServerPosition spawnPosition = serverState.spawn;
                if (spawnPosition != null) {
                    spawnPosition.teleport(player, false);
                }
            }
            if (playerState.username != null && !playerState.username.equals(player.method_7334().getName())) {
                LOGGER.info("Player {} has changed their username from {}", (Object)player.method_7334().getName(), (Object)playerState.username);
                ((RccEvents.UsernameChange)RccEvents.USERNAME_CHANGE.invoker()).onUsernameChange(player, playerState.username);
            }
            playerState.username = player.method_7334().getName();
            state.savePlayerState(player.method_5667(), playerState);
        });
    }

    public void broadcastComponent(MinecraftServer server, Component message) {
        for (class_3222 player : server.method_3760().method_14571()) {
            player.sendMessage(message);
        }
    }

    public void broadcast(class_2561 text) {
        server.method_3760().method_43514(text, false);
    }

    public void sendChatAsPlayer(class_3222 player, String message) {
        class_2556 msgType = (class_2556)server.method_30611().method_30530(class_7924.field_41237).method_31140(class_2556.field_11737);
        class_7471 signedMessage = class_7471.method_45098((UUID)player.method_5667(), (String)message);
        class_2556.class_7602 pars = new class_2556.class_7602(msgType, class_2561.method_30163((String)message), class_2561.method_30163((String)message));
        boolean allowed = ((ServerMessageEvents.AllowChatMessage)ServerMessageEvents.ALLOW_CHAT_MESSAGE.invoker()).allowChatMessage(signedMessage, player, pars);
        if (!allowed) {
            return;
        }
        ((ServerMessageEvents.ChatMessage)ServerMessageEvents.CHAT_MESSAGE.invoker()).onChatMessage(signedMessage, player, pars);
        class_2561 formatted = CustomChatMessage.getFormattedMessage(signedMessage, player);
        for (class_3222 pl : server.method_3760().method_14571()) {
            pl.method_43496(formatted);
        }
    }

    static {
        CHAT_TYPE = class_5321.method_29179((class_5321)class_7924.field_41237, (class_2960)new class_2960(MOD_ID, "chat"));
    }
}

