/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.server.commands.teleport;

import cc.reconnected.server.RccServer;
import cc.reconnected.server.core.TeleportTracker;
import cc.reconnected.server.struct.ServerPosition;
import cc.reconnected.server.util.Components;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import eu.pb4.placeholders.api.PlaceholderContext;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedDeque;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_5242;

public class TeleportAcceptCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralCommandNode node = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tpaccept").executes(context -> {
            if (!((class_2168)context.getSource()).method_43737()) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_30163((String)"This command can only be executed by players!"), false);
                return 1;
            }
            class_3222 player = ((class_2168)context.getSource()).method_44023();
            UUID playerUuid = player.method_5667();
            ConcurrentLinkedDeque<TeleportTracker.TeleportRequest> playerRequests = TeleportTracker.teleportRequests.get(playerUuid);
            PlaceholderContext playerContext = PlaceholderContext.of((class_3222)player);
            TeleportTracker.TeleportRequest request = playerRequests.pollLast();
            if (request == null) {
                ((class_2168)context.getSource()).method_9226(() -> Components.parse(RccServer.CONFIG.textFormats.commands.teleportRequest.noPending, playerContext), false);
                return 1;
            }
            TeleportAcceptCommand.execute((CommandContext<class_2168>)context, request);
            return 1;
        })).then(class_2170.method_9244((String)"uuid", (ArgumentType)class_5242.method_27643()).executes(context -> {
            if (!((class_2168)context.getSource()).method_43737()) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_30163((String)"This command can only be executed by players!"), false);
                return 1;
            }
            class_3222 player = ((class_2168)context.getSource()).method_44023();
            UUID uuid = class_5242.method_27645((CommandContext)context, (String)"uuid");
            UUID playerUuid = player.method_5667();
            ConcurrentLinkedDeque<TeleportTracker.TeleportRequest> playerRequests = TeleportTracker.teleportRequests.get(playerUuid);
            PlaceholderContext playerContext = PlaceholderContext.of((class_3222)player);
            TeleportTracker.TeleportRequest request = playerRequests.stream().filter(req -> req.requestId.equals(uuid)).findFirst().orElse(null);
            if (request == null) {
                ((class_2168)context.getSource()).method_9226(() -> Components.parse(RccServer.CONFIG.textFormats.commands.teleportRequest.unavailable, playerContext), false);
                return 1;
            }
            TeleportAcceptCommand.execute((CommandContext<class_2168>)context, request);
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"tpyes").redirect((CommandNode)node));
    }

    private static void execute(CommandContext<class_2168> context, TeleportTracker.TeleportRequest request) {
        class_2168 source = (class_2168)context.getSource();
        request.expire();
        class_3222 player = source.method_44023();
        class_3324 playerManager = ((class_2168)context.getSource()).method_9211().method_3760();
        class_3222 sourcePlayer = playerManager.method_14602(request.player);
        class_3222 targetPlayer = playerManager.method_14602(request.target);
        PlaceholderContext playerContext = PlaceholderContext.of((class_3222)player);
        if (sourcePlayer == null || targetPlayer == null) {
            ((class_2168)context.getSource()).method_9226(() -> Components.parse(RccServer.CONFIG.textFormats.commands.teleportRequest.playerUnavailable, playerContext), false);
            return;
        }
        if (player.method_5667().equals(request.target)) {
            PlaceholderContext sourceContext = PlaceholderContext.of((class_3222)sourcePlayer);
            ((class_2168)context.getSource()).method_9226(() -> Components.parse(RccServer.CONFIG.textFormats.commands.teleportRequest.requestAcceptedResult, playerContext), false);
            sourcePlayer.method_7353(Components.parse(RccServer.CONFIG.textFormats.commands.teleportRequest.teleporting, sourceContext), false);
        } else {
            PlaceholderContext targetContext = PlaceholderContext.of((class_3222)targetPlayer);
            ((class_2168)context.getSource()).method_9226(() -> Components.parse(RccServer.CONFIG.textFormats.commands.teleportRequest.teleporting, playerContext), false);
            targetPlayer.method_7353(Components.parse(RccServer.CONFIG.textFormats.commands.teleportRequest.requestAccepted, targetContext, Map.of("player", sourcePlayer.method_5476())), false);
        }
        ServerPosition targetPosition = new ServerPosition(targetPlayer);
        targetPosition.teleport(sourcePlayer);
    }
}

