/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.server.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Config {
    public HttpApi httpApi = new HttpApi();
    public Afk afk = new Afk();
    public TeleportRequests teleportRequests = new TeleportRequests();
    public Homes homes = new Homes();
    public CustomTabList customTabList = new CustomTabList();
    public NearCommand nearCommand = new NearCommand();
    public AutoRestart autoRestart = new AutoRestart();
    public Chat chat = new Chat();
    public TextFormats textFormats = new TextFormats();

    Config() {
    }

    public static class HttpApi {
        public boolean enableHttpApi = true;
        public int httpPort = 25581;
    }

    public static class Afk {
        public int afkTimeTrigger = 300;
    }

    public static class TeleportRequests {
        public int teleportRequestTimeout = 120;
    }

    public static class Homes {
        public int maxHomes = -1;
    }

    public static class CustomTabList {
        public boolean enableTabList = true;
        public int tabListTickDelay = 5;
        public double tabPhasePeriod = 300.0;
        public ArrayList<String> tabHeader = new ArrayList<String>(List.of("<gradient:#DEDE6C:#CC4C4C:{phase}><st>                                  </st></gradient>"));
        public ArrayList<String> tabFooter = new ArrayList<String>(List.of("<gradient:#DEDE6C:#CC4C4C:{phase}><st>                                  </st></gradient>"));
        public String playerTabName = "%rcc-server:afk%%player:displayname_visual%";
    }

    public static class NearCommand {
        public int nearCommandMaxRange = 48;
        public int nearCommandDefaultRange = 32;
    }

    public static class AutoRestart {
        public boolean enableAutoRestart = true;
        public String restartBarLabel = "Server restarting in <remaining_time>";
        public String restartKickMessage = "The server is restarting!";
        public String restartChatMessage = "<red>The server is restarting in </red><gold><remaining_time></gold>";
        public ArrayList<String> restartAt = new ArrayList<String>(List.of("06:00", "18:00"));
        public String restartSound = "minecraft:block.note_block.bell";
        public float restartSoundPitch = 0.9f;
        public ArrayList<Integer> restartNotifications = new ArrayList<Integer>(List.of(600, 300, 120, 60, 30, 15, 10, 5, 4, 3, 2, 1));
    }

    public static class Chat {
        public boolean enableChatMarkdown = true;
        public HashMap<String, String> replacements = new HashMap<String, String>(Map.of(":shrug:", "\u00af\\\\_(\u30c4)_/\u00af"));
    }

    public static class TextFormats {
        public ArrayList<NameFormat> nameFormats = new ArrayList<NameFormat>(List.of(new NameFormat("admin", "<red>%player:name%</red>"), new NameFormat("default", "<green>%player:name%</green>")));
        public String chatFormat = "%player:displayname%<gray>:</gray> ${message}";
        public String emoteFormat = "<gray>\ud83d\udc64 %player:displayname% <i>${message}</i></gray>";
        public String joinFormat = "<green>+</green> %player:displayname% <yellow>joined!</yellow>";
        public String joinRenamedFormat = "<green>+</green> %player:displayname% <yellow>joined! <i>(Previously known as ${previousName})</i></yellow>";
        public String leaveFormat = "<red>-</red> %player:displayname% <yellow>left!</yellow>";
        public String deathFormat = "<gray>\u2620 ${message}</gray>";
        public String link = "<c:#8888ff><u>${label}</u></c>";
        public String linkHover = "${url}";
        public Commands commands = new Commands();

        public record NameFormat(String group, String format) {
        }

        public static class Commands {
            public Common common = new Common();
            public Back back = new Back();
            public Near near = new Near();
            public Home home = new Home();
            public Spawn spawn = new Spawn();
            public TeleportRequest teleportRequest = new TeleportRequest();
            public Tell tell = new Tell();
            public Warp warp = new Warp();
            public Afk afk = new Afk();

            public static class Common {
                public String button = "<click:run_command:'{{command}}'><hover:show_text:'${hoverText}'><aqua>[</aqua>${label}<aqua>]</aqua></hover></click>";
                public String accept = "<green>Accept</green>";
                public String refuse = "<red>Refuse</red>";
            }

            public static class Back {
                public String teleporting = "<gold>Teleporting to previous position...</gold>";
                public String noPosition = "<red>There is no position to return back to.</red>";
            }

            public static class Near {
                public String noOne = "<gold>There are no players near you.</gold>";
                public String nearestPlayers = "<gold>Nearest players: ${playerList}</gold>";
                public String format = "${player} <gold>(</gold><yellow>${distance}</yellow><gold>)</gold>";
                public String comma = "<gold>, </gold>";
            }

            public static class Home {
                public String teleporting = "<gold>Teleporting to <yellow>${home}</yellow></gold>";
                public String homeExists = "<gold>You already have set this home.</gold>\n ${forceSetButton}";
                public String homeNotFound = "<red>The home <yellow>${home}</yellow> does not exist!</red>";
                public String maxHomesReached = "<red>You have reached the maximum amount of homes!</red>";
                public String homeSetSuccess = "<gold>New home <yellow>${home}</yellow> set!</gold>";
                public String forceSetLabel = "<yellow>Force set home</yellow>";
                public String forceSetHover = "Click to force setting new home";
                public String homeDeleted = "<gold>Home <yellow>${home}</yellow> deleted!</gold>";
            }

            public static class Spawn {
                public String teleporting = "<gold>Teleporting to spawn...</gold>";
            }

            public static class TeleportRequest {
                public String teleporting = "<gold>Teleporting...</gold>";
                public String playerNotFound = "<red>Player <yellow>${targetPlayer}</yellow> not found!</red>";
                public String requestSent = "<gold>Teleport request sent.</gold>";
                public String pendingTeleport = "${requesterPlayer} <gold>requested to teleport to you.</gold>\n ${acceptButton} ${refuseButton}";
                public String pendingTeleportHere = "${requesterPlayer} <gold>requested you to teleport to them.</gold>\n ${acceptButton} ${refuseButton}";
                public String hoverAccept = "Click to accept request";
                public String hoverRefuse = "Click to refuse request";
                public String noPending = "<gold>There are no pending teleport requests for you.</gold>";
                public String unavailable = "<red>This requested expired or is no longer available.</red>";
                public String playerUnavailable = "<red>The other player is no longer available.</red>";
                public String requestAcceptedResult = "<green>Teleport request accepted.</green>";
                public String requestRefusedResult = "<gold>Teleport request refused.</gold>";
                public String requestAccepted = "<green>${player} accepted your teleport request!</green>";
                public String requestRefused = "<gold>${player} refused your teleport request!</gold>";
            }

            public static class Tell {
                public String playerNotFound = "<red>Player <yellow>${targetPlayer}</yellow> not found!</red>";
                public String you = "<gray><i>You</i></gray>";
                public String message = "<gold>[</gold>${sourcePlayer} <gray>\u2192</gray> ${targetPlayer}<gold>]</gold> ${message}";
                public String messageSpy = "\ud83d\udc41 <gray>[${sourcePlayer} \u2192 ${targetPlayer}] ${message}</gray>";
                public String noLastSenderReply = "<red>You have no one to reply to.</red>";
            }

            public static class Warp {
                public String teleporting = "<gold>Warping to <yellow>${warp}</yellow>...</gold>";
                public String warpNotFound = "<red>The warp <yellow>${warp}</yellow> does not exist!</red>";
            }

            public static class Afk {
                public String goneAfk = "<gray>%player:displayname% is now AFK</gray>";
                public String returnAfk = "<gray>%player:displayname% is no longer AFK</gray>";
                public String tag = "<gray>[AFK]</gray> ";
            }
        }
    }
}

