/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.server.config;

import cc.reconnected.server.RccServer;
import cc.reconnected.server.config.Config;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;

public class ConfigManager {
    private static final Gson gson = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().setDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX").create();
    private static final Path configFilePath = FabricLoader.getInstance().getConfigDir().resolve("rcc-server.json");
    private static Config config = null;

    public static Config load() {
        if (!configFilePath.toFile().exists()) {
            config = new Config();
            ConfigManager.save();
            return config;
        }
        try (BufferedReader bf = new BufferedReader(new FileReader(configFilePath.toFile(), StandardCharsets.UTF_8));){
            config = (Config)gson.fromJson((Reader)bf, Config.class);
            ConfigManager.save();
        }
        catch (Exception e) {
            RccServer.LOGGER.error("Error loading the RccServer config file.", (Throwable)e);
        }
        return config;
    }

    public static void save() {
        String json = gson.toJson((Object)config);
        try (FileWriter fw = new FileWriter(configFilePath.toFile(), StandardCharsets.UTF_8);){
            fw.write(json);
        }
        catch (Exception e) {
            RccServer.LOGGER.error("Error saving the RccServer config file.", (Throwable)e);
        }
    }
}

