/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.server.core;

import cc.reconnected.server.api.events.BossBarEvents;
import cc.reconnected.server.util.Components;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedDeque;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.minecraft.class_1259;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3002;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class BossBarManager {
    private static BossBarManager instance;
    private static MinecraftServer server;
    private static ConcurrentLinkedDeque<TimeBar> timeBars;
    private static final MiniMessage miniMessage;

    public static BossBarManager getInstance() {
        return instance;
    }

    public static void register() {
        instance = new BossBarManager();
        ServerLifecycleEvents.SERVER_STARTING.register(s -> {
            server = s;
        });
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            if (server.method_3780() % 20 == 0) {
                for (TimeBar timeBar : timeBars) {
                    boolean remove = timeBar.elapse();
                    ((BossBarEvents.Progress)BossBarEvents.PROGRESS.invoker()).onProgress(timeBar, server);
                    List players = server.method_3760().method_14571();
                    BossBarManager.showBar(players, timeBar);
                    if (!remove) continue;
                    timeBars.remove(timeBar);
                    ((BossBarEvents.End)BossBarEvents.END.invoker()).onEnd(timeBar, server);
                    BossBarManager.hideBar(players, timeBar);
                }
            }
        });
    }

    private static void showBar(Collection<class_3222> players, TimeBar timeBar) {
        timeBar.getBossBar().method_12962(players);
    }

    private static void hideBar(Collection<class_3222> players, TimeBar timeBar) {
        players.forEach(player -> timeBar.getBossBar().method_14089(player));
    }

    public TimeBar startTimeBar(String label, int seconds, class_1259.class_1260 color, class_1259.class_1261 style, boolean countdown) {
        TimeBar timeBar = new TimeBar(label, seconds, countdown, color, style);
        timeBars.add(timeBar);
        List players = server.method_3760().method_14571();
        BossBarManager.showBar(players, timeBar);
        ((BossBarEvents.Start)BossBarEvents.START.invoker()).onStart(timeBar, server);
        ((BossBarEvents.Progress)BossBarEvents.PROGRESS.invoker()).onProgress(timeBar, server);
        return timeBar;
    }

    public boolean cancelTimeBar(TimeBar timeBar) {
        boolean success = timeBars.remove(timeBar);
        if (success) {
            List players = server.method_3760().method_14571();
            BossBarManager.hideBar(players, timeBar);
            ((BossBarEvents.Cancel)BossBarEvents.CANCEL.invoker()).onCancel(timeBar, server);
        }
        return success;
    }

    public boolean cancelTimeBar(UUID uuid) {
        TimeBar progressBar = timeBars.stream().filter(p -> p.uuid.equals(uuid)).findFirst().orElse(null);
        if (progressBar == null) {
            return false;
        }
        return this.cancelTimeBar(progressBar);
    }

    static {
        timeBars = new ConcurrentLinkedDeque();
        miniMessage = MiniMessage.miniMessage();
    }

    public static class TimeBar {
        private final UUID uuid = UUID.randomUUID();
        private final class_3002 bossBar;
        private final String label;
        private final int time;
        private int elapsedSeconds = 0;
        private final boolean countdown;

        public TimeBar(String label, int time, boolean countdown, class_1259.class_1260 color, class_1259.class_1261 style) {
            this.bossBar = new class_3002(class_2960.method_43902((String)"rcc-server", (String)this.uuid.toString()), class_2561.method_30163((String)label));
            this.bossBar.method_5416(color);
            this.bossBar.method_5409(style);
            this.label = label;
            this.time = time;
            this.countdown = countdown;
            this.updateName();
            this.updateProgress();
        }

        public static String formatTime(int totalSeconds) {
            int hours = totalSeconds / 3600;
            int minutes = totalSeconds / 60 % 60;
            int seconds = totalSeconds % 60;
            if (totalSeconds >= 3600) {
                return String.format("%dh%dm%ds", hours, minutes, seconds);
            }
            return String.format("%dm%ds", minutes, seconds);
        }

        public void updateName() {
            Component text = this.parseLabel(this.label);
            this.bossBar.method_5413((class_2561)Components.toText(text));
        }

        public Component parseLabel(String labelString) {
            String totalTime = TimeBar.formatTime(this.time);
            String elapsedTime = TimeBar.formatTime(this.elapsedSeconds);
            int remaining = this.getRemainingSeconds();
            String remainingTime = TimeBar.formatTime(remaining);
            return miniMessage.deserialize(labelString, TagResolver.resolver((TagResolver[])new TagResolver[]{Placeholder.parsed((String)"total_time", (String)totalTime), Placeholder.parsed((String)"elapsed_time", (String)elapsedTime), Placeholder.parsed((String)"remaining_time", (String)remainingTime)}));
        }

        public UUID getUuid() {
            return this.uuid;
        }

        public class_3002 getBossBar() {
            return this.bossBar;
        }

        public String getLabel() {
            return this.label;
        }

        public int getTime() {
            return this.time;
        }

        public int getElapsedSeconds() {
            return this.elapsedSeconds;
        }

        public int getRemainingSeconds() {
            return this.time - this.elapsedSeconds;
        }

        public boolean isCountdown() {
            return this.countdown;
        }

        public boolean elapse() {
            ++this.elapsedSeconds;
            this.updateProgress();
            this.updateName();
            return this.elapsedSeconds >= this.time;
        }

        private void updateProgress() {
            float progress = (float)this.elapsedSeconds / (float)this.time;
            if (this.countdown) {
                progress = 1.0f - progress;
            }
            this.bossBar.method_5408(Math.min(Math.max(progress, 0.0f), 1.0f));
        }
    }
}

