/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.server.core;

import cc.reconnected.server.RccServer;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;

public class TeleportTracker {
    public static final ConcurrentHashMap<UUID, ConcurrentLinkedDeque<TeleportRequest>> teleportRequests = new ConcurrentHashMap();

    public static void register() {
        ServerTickEvents.END_SERVER_TICK.register(server -> teleportRequests.forEach((recipient, requestList) -> requestList.forEach(request -> {
            if (request.remainingTicks-- == 0) {
                requestList.remove(request);
            }
        })));
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> teleportRequests.put(handler.method_32311().method_5667(), new ConcurrentLinkedDeque()));
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> teleportRequests.remove(handler.method_32311().method_5667()));
    }

    public static class TeleportRequest {
        public UUID requestId = UUID.randomUUID();
        public UUID player;
        public UUID target;
        public int remainingTicks;

        public TeleportRequest(UUID player, UUID target) {
            this.player = player;
            this.target = target;
            this.remainingTicks = RccServer.CONFIG.teleportRequests.teleportRequestTimeout * 20;
        }

        public void expire() {
            this.remainingTicks = 0;
        }
    }
}

