/*
 * Decompiled with CFR 0.152.
 */
package com.github.quiltservertools.ledger;

import com.github.quiltservertools.ledger.LedgerKt;
import com.github.quiltservertools.ledger.actionutils.ActionSearchParams;
import com.github.quiltservertools.ledger.actionutils.Preview;
import com.github.quiltservertools.ledger.api.LedgerApi;
import com.github.quiltservertools.ledger.api.LedgerApiImpl;
import com.github.quiltservertools.ledger.commands.LedgerCommandKt;
import com.github.quiltservertools.ledger.config.DatabaseSpec;
import com.github.quiltservertools.ledger.config.LedgerConfigKt;
import com.github.quiltservertools.ledger.database.DatabaseManager;
import com.github.quiltservertools.ledger.listeners.BlockEventListenerKt;
import com.github.quiltservertools.ledger.listeners.EntityCallbackListenerKt;
import com.github.quiltservertools.ledger.listeners.PlayerEventListenerKt;
import com.github.quiltservertools.ledger.listeners.WorldEventListenerKt;
import com.github.quiltservertools.ledger.registry.ActionRegistry;
import com.github.quiltservertools.libs.com.uchuhimo.konf.Config;
import com.mojang.brigadier.CommandDispatcher;
import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.TimeoutKt;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.Version;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2960;
import net.minecraft.class_5218;
import net.minecraft.class_7157;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0004J\u0017\u0010\t\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u000b\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u000b\u0010\nJ\u000f\u0010\f\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\f\u0010\u0004J\u0015\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\r8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\r8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0013R \u0010\u0016\u001a\u00020\u00158\u0006X\u0087\u0004\u00a2\u0006\u0012\n\u0004\b\u0016\u0010\u0017\u0012\u0004\b\u001a\u0010\u0004\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\u001c\u001a\u00020\u001b8\u0006\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR\"\u0010!\u001a\u00020 8\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b!\u0010\"\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\"\u0010\b\u001a\u00020\u00078\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b\b\u0010'\u001a\u0004\b(\u0010)\"\u0004\b*\u0010\nR#\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020,0+8\u0006\u00a2\u0006\f\n\u0004\b-\u0010.\u001a\u0004\b/\u00100R#\u00103\u001a\u000e\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u0002020+8\u0006\u00a2\u0006\f\n\u0004\b3\u0010.\u001a\u0004\b4\u00100R\u001a\u00106\u001a\u0002058\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b6\u00107\u001a\u0004\b8\u00109\u00a8\u0006:"}, d2={"Lcom/github/quiltservertools/ledger/Ledger;", "Lnet/fabricmc/api/DedicatedServerModInitializer;", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "()V", "", "onInitializeServer", "Lnet/minecraft/server/MinecraftServer;", "server", "serverStarting", "(Lnet/minecraft/server/MinecraftServer;)V", "serverStopped", "initListeners", "", "path", "Lnet/minecraft/class_2960;", "identifier", "(Ljava/lang/String;)Lnet/minecraft/class_2960;", "MOD_ID", "Ljava/lang/String;", "DEFAULT_DATABASE", "Lcom/github/quiltservertools/ledger/api/LedgerApi;", "api", "Lcom/github/quiltservertools/ledger/api/LedgerApi;", "getApi", "()Lcom/github/quiltservertools/ledger/api/LedgerApi;", "getApi$annotations", "Lorg/apache/logging/log4j/Logger;", "logger", "Lorg/apache/logging/log4j/Logger;", "getLogger", "()Lorg/apache/logging/log4j/Logger;", "Lcom/github/quiltservertools/libs/com/uchuhimo/konf/Config;", "config", "Lcom/github/quiltservertools/libs/com/uchuhimo/konf/Config;", "getConfig", "()Lcom/uchuhimo/konf/Config;", "setConfig", "(Lcom/uchuhimo/konf/Config;)V", "Lnet/minecraft/server/MinecraftServer;", "getServer", "()Lnet/minecraft/server/MinecraftServer;", "setServer", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/github/quiltservertools/ledger/actionutils/ActionSearchParams;", "searchCache", "Ljava/util/concurrent/ConcurrentHashMap;", "getSearchCache", "()Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/UUID;", "Lcom/github/quiltservertools/ledger/actionutils/Preview;", "previewCache", "getPreviewCache", "Lkotlin/coroutines/CoroutineContext;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "ledger"})
public final class Ledger
implements DedicatedServerModInitializer,
CoroutineScope {
    @NotNull
    public static final Ledger INSTANCE = new Ledger();
    @NotNull
    public static final String MOD_ID = "ledger";
    @NotNull
    public static final String DEFAULT_DATABASE = "sqlite";
    @NotNull
    private static final LedgerApi api = LedgerApiImpl.INSTANCE;
    @NotNull
    private static final Logger logger;
    public static Config config;
    public static MinecraftServer server;
    @NotNull
    private static final ConcurrentHashMap<String, ActionSearchParams> searchCache;
    @NotNull
    private static final ConcurrentHashMap<UUID, Preview> previewCache;
    @NotNull
    private static final CoroutineContext coroutineContext;

    private Ledger() {
    }

    @NotNull
    public static final LedgerApi getApi() {
        return api;
    }

    @JvmStatic
    public static /* synthetic */ void getApi$annotations() {
    }

    @NotNull
    public final Logger getLogger() {
        return logger;
    }

    @NotNull
    public final Config getConfig() {
        Config config = Ledger.config;
        if (config != null) {
            return config;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"config");
        return null;
    }

    public final void setConfig(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"<set-?>");
        Ledger.config = config;
    }

    @NotNull
    public final MinecraftServer getServer() {
        MinecraftServer minecraftServer = server;
        if (minecraftServer != null) {
            return minecraftServer;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"server");
        return null;
    }

    public final void setServer(@NotNull MinecraftServer minecraftServer) {
        Intrinsics.checkNotNullParameter((Object)minecraftServer, (String)"<set-?>");
        server = minecraftServer;
    }

    @NotNull
    public final ConcurrentHashMap<String, ActionSearchParams> getSearchCache() {
        return searchCache;
    }

    @NotNull
    public final ConcurrentHashMap<UUID, Preview> getPreviewCache() {
        return previewCache;
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return coroutineContext;
    }

    public void onInitializeServer() {
        Version version = ((ModContainer)FabricLoader.getInstance().getModContainer(MOD_ID).get()).getMetadata().getVersion();
        LedgerKt.logInfo("Initializing Ledger " + version.getFriendlyString());
        if (!Files.exists(FabricLoader.getInstance().getConfigDir().resolve("ledger.toml"), new LinkOption[0])) {
            LedgerKt.logInfo("No config file, Creating");
            Files.copy((Path)((ModContainer)FabricLoader.getInstance().getModContainer(MOD_ID).get()).findPath("ledger.toml").get(), FabricLoader.getInstance().getConfigDir().resolve("ledger.toml"), new CopyOption[0]);
        }
        LedgerConfigKt.getConfig().validateRequired();
        this.setConfig(LedgerConfigKt.getConfig());
        ServerLifecycleEvents.SERVER_STARTING.register(this::serverStarting);
        ServerLifecycleEvents.SERVER_STOPPED.register(this::serverStopped);
        CommandRegistrationCallback.EVENT.register(Ledger::onInitializeServer$lambda$0);
    }

    private final void serverStarting(MinecraftServer server) {
        this.setServer(server);
        File file2 = server.method_27050(class_5218.field_24188).resolve("ledger.sqlite").toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"toFile(...)");
        DatabaseManager.INSTANCE.setValues(file2, server);
        DatabaseManager.INSTANCE.ensureTables();
        DatabaseManager.INSTANCE.autoPurge();
        ActionRegistry.INSTANCE.registerDefaultTypes();
        this.initListeners();
        Set set = SetsKt.emptySet();
        Set set2 = class_7923.field_41175.method_10235();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"getIds(...)");
        Set set3 = SetsKt.plus((Set)set, (Iterable)set2);
        Set set4 = class_7923.field_41178.method_10235();
        Intrinsics.checkNotNullExpressionValue((Object)set4, (String)"getIds(...)");
        Set set5 = SetsKt.plus((Set)set3, (Iterable)set4);
        Set set6 = class_7923.field_41177.method_10235();
        Intrinsics.checkNotNullExpressionValue((Object)set6, (String)"getIds(...)");
        Set idSet = SetsKt.plus((Set)set5, (Iterable)set6);
        BuildersKt.launch$default((CoroutineScope)INSTANCE, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Set<? extends class_2960>)idSet, null){
            int label;
            final /* synthetic */ Set<class_2960> $idSet;
            {
                this.$idSet = $idSet;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        LedgerKt.logInfo("Inserting " + this.$idSet.size() + " registry keys into the database...");
                        this.label = 1;
                        v0 = DatabaseManager.INSTANCE.insertIdentifiers((Collection<? extends class_2960>)this.$idSet, (Continuation<? super Unit>)((Continuation)this));
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl14
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl14:
                        // 2 sources

                        LedgerKt.logInfo("Registry insert complete");
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void serverStopped(MinecraftServer server) {
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
            int label;

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = TimeoutKt.withTimeout-KLykuaI((long)DurationKt.toDuration((long)((Number)Ledger.INSTANCE.getConfig().get(DatabaseSpec.INSTANCE.getQueueTimeoutMin())).longValue(), (DurationUnit)DurationUnit.MINUTES), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
                            int label;

                            /*
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object var1_1) {
                                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)var1_1);
lbl5:
                                        // 3 sources

                                        while (DatabaseManager.INSTANCE.getDbMutex().isLocked()) {
                                            LedgerKt.logInfo("Database queue is still draining. If you exit now actions WILL be lost");
                                            this.label = 1;
                                            v0 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((long)((Number)Ledger.INSTANCE.getConfig().get(DatabaseSpec.INSTANCE.getQueueCheckDelaySec())).longValue(), (DurationUnit)DurationUnit.SECONDS), (Continuation)((Continuation)this));
                                            if (v0 != var2_2) continue;
                                            return var2_2;
                                        }
                                        break;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
                                        ** GOTO lbl5
                                    }
                                }
                                return Unit.INSTANCE;
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    private final void initListeners() {
        WorldEventListenerKt.registerWorldEventListeners();
        PlayerEventListenerKt.registerPlayerListeners();
        BlockEventListenerKt.registerBlockListeners();
        EntityCallbackListenerKt.registerEntityListeners();
    }

    @NotNull
    public final class_2960 identifier(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new class_2960(MOD_ID, path);
    }

    private static final void onInitializeServer$lambda$0(CommandDispatcher dispatcher, class_7157 class_71572, class_2170.class_5364 class_53642) {
        Intrinsics.checkNotNull((Object)dispatcher);
        LedgerCommandKt.registerCommands((CommandDispatcher<class_2168>)dispatcher);
    }

    static {
        Logger logger = LogManager.getLogger((String)"Ledger");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        Ledger.logger = logger;
        searchCache = new ConcurrentHashMap();
        previewCache = new ConcurrentHashMap();
        coroutineContext = (CoroutineContext)Dispatchers.getIO();
    }
}

