/*
 * Decompiled with CFR 0.152.
 */
package com.github.quiltservertools.ledger.database;

import com.github.quiltservertools.ledger.Ledger;
import com.github.quiltservertools.ledger.LedgerKt;
import com.github.quiltservertools.ledger.actions.ActionType;
import com.github.quiltservertools.ledger.actionutils.ActionSearchParams;
import com.github.quiltservertools.ledger.actionutils.Preview;
import com.github.quiltservertools.ledger.actionutils.SearchResults;
import com.github.quiltservertools.ledger.api.ExtensionManager;
import com.github.quiltservertools.ledger.config.DatabaseSpec;
import com.github.quiltservertools.ledger.config.LedgerConfigKt;
import com.github.quiltservertools.ledger.config.SearchSpec;
import com.github.quiltservertools.ledger.database.Tables;
import com.github.quiltservertools.ledger.registry.ActionRegistry;
import com.github.quiltservertools.ledger.utility.NbtUtils;
import com.github.quiltservertools.ledger.utility.Negatable;
import com.github.quiltservertools.ledger.utility.PlayerResult;
import com.mojang.authlib.GameProfile;
import java.io.File;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.dao.id.IdTable;
import org.jetbrains.exposed.sql.AbstractQuery;
import org.jetbrains.exposed.sql.Alias;
import org.jetbrains.exposed.sql.AliasKt;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.Database;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ExpressionWithColumnType;
import org.jetbrains.exposed.sql.ISqlExpressionBuilder;
import org.jetbrains.exposed.sql.Join;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.OpKt;
import org.jetbrains.exposed.sql.QueriesKt;
import org.jetbrains.exposed.sql.Query;
import org.jetbrains.exposed.sql.QueryKt;
import org.jetbrains.exposed.sql.SQLExpressionBuilderKt;
import org.jetbrains.exposed.sql.SchemaUtils;
import org.jetbrains.exposed.sql.SortOrder;
import org.jetbrains.exposed.sql.SqlExpressionBuilder;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.TableKt;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.BatchInsertStatement;
import org.jetbrains.exposed.sql.statements.DeleteStatement;
import org.jetbrains.exposed.sql.statements.InsertStatement;
import org.jetbrains.exposed.sql.statements.UpdateBuilder;
import org.jetbrains.exposed.sql.transactions.ThreadLocalTransactionManagerKt;
import org.jetbrains.exposed.sql.transactions.TransactionManager;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0080\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\r\u0010\u000b\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\u0003J\r\u0010\f\u001a\u00020\b\u00a2\u0006\u0004\b\f\u0010\u0003J \u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000fH\u0086@\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0018\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\rH\u0086@\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u000e\u001a\u00020\rH\u0086@\u00a2\u0006\u0004\b\u0019\u0010\u0016J\u001e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u000e\u001a\u00020\rH\u0086@\u00a2\u0006\u0004\b\u001a\u0010\u0016J&\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001bH\u0086@\u00a2\u0006\u0004\b\u001d\u0010\u001eJ#\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0\u0017H\u0002\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010$\u001a\u00020#2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b$\u0010%JS\u0010.\u001a\u00020\b\"\u0004\b\u0000\u0010&2\u0006\u0010'\u001a\u00020#2\u0014\u0010*\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000)\u0018\u00010(2\f\u0010,\u001a\b\u0012\u0004\u0012\u00028\u00000+2\u0010\b\u0002\u0010-\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010+H\u0002\u00a2\u0006\u0004\b.\u0010/J\u0015\u00101\u001a\u00020\b2\u0006\u00100\u001a\u00020\u0018\u00a2\u0006\u0004\b1\u00102J\u0018\u00105\u001a\u00020\b2\u0006\u00104\u001a\u000203H\u0086@\u00a2\u0006\u0004\b5\u00106J\u0018\u00109\u001a\u00020\b2\u0006\u00108\u001a\u000207H\u0086@\u00a2\u0006\u0004\b9\u0010:J \u0010>\u001a\u00020\b2\u0006\u0010<\u001a\u00020;2\u0006\u0010=\u001a\u000207H\u0086@\u00a2\u0006\u0004\b>\u0010?J\u001e\u0010A\u001a\u00020\b2\f\u0010@\u001a\b\u0012\u0004\u0012\u0002030(H\u0086@\u00a2\u0006\u0004\bA\u0010BJE\u0010I\u001a\u00028\u0000\"\n\b\u0000\u0010C*\u0004\u0018\u00010\u00012'\u0010H\u001a#\b\u0001\u0012\u0004\u0012\u00020E\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000F\u0012\u0006\u0012\u0004\u0018\u00010\u00010D\u00a2\u0006\u0002\bGH\u0082@\u00a2\u0006\u0004\bI\u0010JJ\u0018\u0010K\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\rH\u0086@\u00a2\u0006\u0004\bK\u0010\u0016J$\u0010P\u001a\b\u0012\u0004\u0012\u00020O0\u00172\f\u0010N\u001a\b\u0012\u0004\u0012\u00020M0LH\u0086@\u00a2\u0006\u0004\bP\u0010QJ\u001b\u0010R\u001a\u00020\b*\u00020E2\u0006\u00108\u001a\u000207H\u0002\u00a2\u0006\u0004\bR\u0010SJ\u001b\u0010T\u001a\u00020\b*\u00020E2\u0006\u00104\u001a\u000203H\u0002\u00a2\u0006\u0004\bT\u0010UJ!\u0010V\u001a\u00020\b*\u00020E2\f\u0010@\u001a\b\u0012\u0004\u0012\u0002030(H\u0002\u00a2\u0006\u0004\bV\u0010WJ\u001b\u0010X\u001a\u00020\b*\u00020E2\u0006\u00100\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\bX\u0010YJ#\u0010Z\u001a\u00020\b*\u00020E2\u0006\u0010<\u001a\u00020;2\u0006\u0010=\u001a\u000207H\u0002\u00a2\u0006\u0004\bZ\u0010[J#\u0010\\\u001a\u00020\u0011*\u00020E2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\\\u0010]J\u001b\u0010\u0015\u001a\u00020\u0014*\u00020E2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0015\u0010^J)\u0010`\u001a\b\u0012\u0004\u0012\u00020\u00180_*\u00020E2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b`\u0010aJ!\u0010b\u001a\b\u0012\u0004\u0012\u00020\u00180_*\u00020E2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\bb\u0010cJ!\u0010d\u001a\b\u0012\u0004\u0012\u00020\u00180_*\u00020E2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\bd\u0010cJ\u001d\u0010g\u001a\u0004\u0018\u00010f*\u00020E2\u0006\u0010e\u001a\u00020;H\u0002\u00a2\u0006\u0004\bg\u0010hJ\u001d\u0010g\u001a\u0004\u0018\u00010f*\u00020E2\u0006\u0010i\u001a\u000207H\u0002\u00a2\u0006\u0004\bg\u0010jJ\u001b\u0010m\u001a\u00020l*\u00020E2\u0006\u0010k\u001a\u000207H\u0002\u00a2\u0006\u0004\bm\u0010nJ\u001b\u0010p\u001a\u00020o*\u00020E2\u0006\u00108\u001a\u000207H\u0002\u00a2\u0006\u0004\bp\u0010qJ\u001b\u0010s\u001a\u00020r*\u00020E2\u0006\u00104\u001a\u000203H\u0002\u00a2\u0006\u0004\bs\u0010tJ\u001b\u0010v\u001a\u00020u*\u00020E2\u0006\u00104\u001a\u000203H\u0002\u00a2\u0006\u0004\bv\u0010wJ\u001b\u0010K\u001a\u00020\b*\u00020E2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\bK\u0010xJ'\u0010y\u001a\b\u0012\u0004\u0012\u00020O0\u0017*\u00020E2\f\u0010N\u001a\b\u0012\u0004\u0012\u00020M0LH\u0002\u00a2\u0006\u0004\by\u0010zR\u0016\u0010{\u001a\u00020\u00048\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b{\u0010|R\u0016\u0010~\u001a\u00020}8\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b~\u0010\u007fR\u001d\u0010\u0081\u0001\u001a\u00030\u0080\u00018\u0006\u00a2\u0006\u0010\n\u0006\b\u0081\u0001\u0010\u0082\u0001\u001a\u0006\b\u0083\u0001\u0010\u0084\u0001R\u001e\u0010\u0086\u0001\u001a\t\u0012\u0004\u0012\u00020\u00180\u0085\u00018\u0002X\u0082\u0004\u00a2\u0006\b\n\u0006\b\u0086\u0001\u0010\u0087\u0001R!\u0010 \u001a\t\u0012\u0004\u0012\u00020\u00180\u0088\u00018\u0006\u00a2\u0006\u000f\n\u0005\b \u0010\u0089\u0001\u001a\u0006\b\u008a\u0001\u0010\u008b\u0001\u00a8\u0006\u008c\u0001"}, d2={"Lcom/github/quiltservertools/ledger/database/DatabaseManager;", "", "<init>", "()V", "Ljava/io/File;", "file", "Lnet/minecraft/server/MinecraftServer;", "server", "", "setValues", "(Ljava/io/File;Lnet/minecraft/server/MinecraftServer;)V", "ensureTables", "autoPurge", "Lcom/github/quiltservertools/ledger/actionutils/ActionSearchParams;", "params", "", "page", "Lcom/github/quiltservertools/ledger/actionutils/SearchResults;", "searchActions", "(Lcom/github/quiltservertools/ledger/actionutils/ActionSearchParams;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "", "countActions", "(Lcom/github/quiltservertools/ledger/actionutils/ActionSearchParams;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "", "Lcom/github/quiltservertools/ledger/actions/ActionType;", "rollbackActions", "restoreActions", "Lcom/github/quiltservertools/ledger/actionutils/Preview$Type;", "type", "previewActions", "(Lcom/github/quiltservertools/ledger/actionutils/ActionSearchParams;Lcom/github/quiltservertools/ledger/actionutils/Preview$Type;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Lcom/github/quiltservertools/ledger/database/Tables$Action;", "actions", "daoToActionType", "(Ljava/util/List;)Ljava/util/List;", "Lorg/jetbrains/exposed/sql/Query;", "buildQuery", "(Lcom/github/quiltservertools/ledger/actionutils/ActionSearchParams;)Lorg/jetbrains/exposed/sql/Query;", "E", "query", "", "Lcom/github/quiltservertools/ledger/utility/Negatable;", "paramSet", "Lorg/jetbrains/exposed/sql/Column;", "column", "orColumn", "addParameters", "(Lorg/jetbrains/exposed/sql/Query;Ljava/util/Collection;Lorg/jetbrains/exposed/sql/Column;Lorg/jetbrains/exposed/sql/Column;)V", "action", "logAction", "(Lcom/github/quiltservertools/ledger/actions/ActionType;)V", "Lnet/minecraft/class_2960;", "identifier", "registerWorld", "(Lnet/minecraft/class_2960;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "", "id", "registerActionType", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Ljava/util/UUID;", "uuid", "name", "logPlayer", "(Ljava/util/UUID;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "identifiers", "insertIdentifiers", "(Ljava/util/Collection;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "T", "Lkotlin/Function2;", "Lorg/jetbrains/exposed/sql/Transaction;", "Lkotlin/coroutines/Continuation;", "Lkotlin/ExtensionFunctionType;", "body", "execute", "(Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "purgeActions", "", "Lcom/mojang/authlib/GameProfile;", "players", "Lcom/github/quiltservertools/ledger/utility/PlayerResult;", "searchPlayers", "(Ljava/util/Set;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "insertActionType", "(Lorg/jetbrains/exposed/sql/Transaction;Ljava/lang/String;)V", "insertWorld", "(Lorg/jetbrains/exposed/sql/Transaction;Lnet/minecraft/class_2960;)V", "insertRegKeys", "(Lorg/jetbrains/exposed/sql/Transaction;Ljava/util/Collection;)V", "insertAction", "(Lorg/jetbrains/exposed/sql/Transaction;Lcom/github/quiltservertools/ledger/actions/ActionType;)V", "insertPlayer", "(Lorg/jetbrains/exposed/sql/Transaction;Ljava/util/UUID;Ljava/lang/String;)V", "selectActionsSearch", "(Lorg/jetbrains/exposed/sql/Transaction;Lcom/github/quiltservertools/ledger/actionutils/ActionSearchParams;I)Lcom/github/quiltservertools/ledger/actionutils/SearchResults;", "(Lorg/jetbrains/exposed/sql/Transaction;Lcom/github/quiltservertools/ledger/actionutils/ActionSearchParams;)J", "", "selectActionsPreview", "(Lorg/jetbrains/exposed/sql/Transaction;Lcom/github/quiltservertools/ledger/actionutils/ActionSearchParams;Lcom/github/quiltservertools/ledger/actionutils/Preview$Type;)Ljava/util/List;", "selectRollbackActions", "(Lorg/jetbrains/exposed/sql/Transaction;Lcom/github/quiltservertools/ledger/actionutils/ActionSearchParams;)Ljava/util/List;", "selectRestoreActions", "playerId", "Lcom/github/quiltservertools/ledger/database/Tables$Player;", "selectPlayer", "(Lorg/jetbrains/exposed/sql/Transaction;Ljava/util/UUID;)Lcom/github/quiltservertools/ledger/database/Tables$Player;", "playerName", "(Lorg/jetbrains/exposed/sql/Transaction;Ljava/lang/String;)Lcom/github/quiltservertools/ledger/database/Tables$Player;", "source", "Lcom/github/quiltservertools/ledger/database/Tables$Source;", "insertAndSelectSource", "(Lorg/jetbrains/exposed/sql/Transaction;Ljava/lang/String;)Lcom/github/quiltservertools/ledger/database/Tables$Source;", "Lcom/github/quiltservertools/ledger/database/Tables$ActionIdentifier;", "selectActionId", "(Lorg/jetbrains/exposed/sql/Transaction;Ljava/lang/String;)Lcom/github/quiltservertools/ledger/database/Tables$ActionIdentifier;", "Lcom/github/quiltservertools/ledger/database/Tables$ObjectIdentifier;", "selectRegistryKey", "(Lorg/jetbrains/exposed/sql/Transaction;Lnet/minecraft/class_2960;)Lcom/github/quiltservertools/ledger/database/Tables$ObjectIdentifier;", "Lcom/github/quiltservertools/ledger/database/Tables$World;", "selectWorld", "(Lorg/jetbrains/exposed/sql/Transaction;Lnet/minecraft/class_2960;)Lcom/github/quiltservertools/ledger/database/Tables$World;", "(Lorg/jetbrains/exposed/sql/Transaction;Lcom/github/quiltservertools/ledger/actionutils/ActionSearchParams;)V", "selectPlayers", "(Lorg/jetbrains/exposed/sql/Transaction;Ljava/util/Set;)Ljava/util/List;", "databaseFile", "Ljava/io/File;", "Lorg/jetbrains/exposed/sql/Database;", "database", "Lorg/jetbrains/exposed/sql/Database;", "Lkotlinx/coroutines/sync/Mutex;", "dbMutex", "Lkotlinx/coroutines/sync/Mutex;", "getDbMutex", "()Lkotlinx/coroutines/sync/Mutex;", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "_actions", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lkotlinx/coroutines/flow/SharedFlow;", "Lkotlinx/coroutines/flow/SharedFlow;", "getActions", "()Lkotlinx/coroutines/flow/SharedFlow;", "ledger"})
@SourceDebugExtension(value={"SMAP\nDatabaseManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseManager.kt\ncom/github/quiltservertools/ledger/database/DatabaseManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Mutex.kt\nkotlinx/coroutines/sync/MutexKt\n+ 5 Queries.kt\norg/jetbrains/exposed/sql/QueriesKt\n+ 6 Op.kt\norg/jetbrains/exposed/sql/OpKt\n+ 7 Op.kt\norg/jetbrains/exposed/sql/Op$Companion\n*L\n1#1,537:1\n1#2:538\n1563#3:539\n1634#3,3:540\n1563#3:543\n1634#3,3:544\n774#3:547\n865#3,2:548\n1563#3:550\n1634#3,3:551\n827#3:554\n855#3,2:555\n1563#3:557\n1634#3,3:558\n1869#3,2:581\n1563#3:583\n1634#3,3:584\n1563#3:587\n1634#3,3:588\n116#4,11:561\n455#5,4:572\n301#5,5:576\n160#6:591\n160#6:593\n157#6:597\n157#6:599\n17#7:592\n17#7:594\n17#7:595\n17#7:596\n17#7:598\n17#7:600\n17#7:601\n17#7:602\n*S KotlinDebug\n*F\n+ 1 DatabaseManager.kt\ncom/github/quiltservertools/ledger/database/DatabaseManager\n*L\n227#1:539\n227#1:540,3\n239#1:543\n239#1:544,3\n311#1:547\n311#1:548,2\n311#1:550\n311#1:551,3\n312#1:554\n312#1:555,2\n312#1:557\n312#1:558,3\n524#1:581,2\n532#1:583\n532#1:584,3\n534#1:587\n534#1:588,3\n342#1:561,11\n372#1:572,4\n504#1:576,5\n278#1:591\n280#1:593\n300#1:597\n302#1:599\n278#1:592\n280#1:594\n271#1:595\n273#1:596\n300#1:598\n302#1:600\n293#1:601\n295#1:602\n*E\n"})
public final class DatabaseManager {
    @NotNull
    public static final DatabaseManager INSTANCE = new DatabaseManager();
    private static File databaseFile;
    private static Database database;
    @NotNull
    private static final Mutex dbMutex;
    @NotNull
    private static final MutableSharedFlow<ActionType> _actions;
    @NotNull
    private static final SharedFlow<ActionType> actions;

    private DatabaseManager() {
    }

    @NotNull
    public final Mutex getDbMutex() {
        return dbMutex;
    }

    @NotNull
    public final SharedFlow<ActionType> getActions() {
        return actions;
    }

    public final void setValues(@NotNull File file2, @NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        if (ExtensionManager.INSTANCE.getDatabaseExtensionOptional().isPresent()) {
            database = ExtensionManager.INSTANCE.getDatabaseExtensionOptional().get().getDatabase(server);
        } else {
            databaseFile = file2;
            File file3 = databaseFile;
            if (file3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"databaseFile");
                file3 = null;
            }
            String string = file3.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            database = Database.Companion.connect$default(Database.Companion, "jdbc:sqlite:" + StringsKt.replace$default((String)string, (char)'\\', (char)'/', (boolean)false, (int)4, null), null, null, null, null, null, null, null, 254, null);
        }
    }

    public final void ensureTables() {
        ThreadLocalTransactionManagerKt.transaction$default(null, DatabaseManager::ensureTables$lambda$0, 1, null);
    }

    public final void autoPurge() {
        if (((Number)LedgerConfigKt.getConfig().get(DatabaseSpec.INSTANCE.getAutoPurgeDays())).intValue() > 0) {
            BuildersKt.launch$default((CoroutineScope)Ledger.INSTANCE, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
                int label;

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = DatabaseManager.access$execute(DatabaseManager.INSTANCE, (Function2)new Function2<Transaction, Continuation<? super Unit>, Object>(null){
                                int label;

                                public final Object invokeSuspend(Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            Ledger.INSTANCE.getLogger().info("Purging actions older than " + LedgerConfigKt.getConfig().get(DatabaseSpec.INSTANCE.getAutoPurgeDays()) + " days");
                                            Table $this$deleteWhere_u24default$iv = Tables.Actions.INSTANCE;
                                            Integer limit$iv = null;
                                            boolean $i$f$deleteWhere = false;
                                            ISqlExpressionBuilder cfr_ignored_0 = (ISqlExpressionBuilder)SqlExpressionBuilder.INSTANCE;
                                            Tables.Actions cfr_ignored_1 = (Tables.Actions)$this$deleteWhere_u24default$iv;
                                            Table table = $this$deleteWhere_u24default$iv;
                                            Transaction transaction = TransactionManager.Companion.current();
                                            DeleteStatement.Companion companion = DeleteStatement.Companion;
                                            boolean bl = false;
                                            ExpressionWithColumnType expressionWithColumnType = Tables.Actions.INSTANCE.getTimestamp();
                                            Instant instant = Instant.now().minus(((Number)LedgerConfigKt.getConfig().get(DatabaseSpec.INSTANCE.getAutoPurgeDays())).intValue(), ChronoUnit.DAYS);
                                            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"minus(...)");
                                            Op op = SqlExpressionBuilder.INSTANCE.lessEq(expressionWithColumnType, (Comparable)instant);
                                            int deleted = companion.where(transaction, table, op, false, limit$iv);
                                            Ledger.INSTANCE.getLogger().info("Successfully purged " + deleted + " actions");
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(Transaction p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, (Continuation)this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    @Nullable
    public final Object searchActions(@NotNull ActionSearchParams params, int page2, @NotNull Continuation<? super SearchResults> $completion) {
        return this.execute((Function2)new Function2<Transaction, Continuation<? super SearchResults>, Object>(params, page2, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ ActionSearchParams $params;
            final /* synthetic */ int $page;
            {
                this.$params = $params;
                this.$page = $page;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Transaction $this$execute = (Transaction)this.L$0;
                        return DatabaseManager.access$selectActionsSearch(DatabaseManager.INSTANCE, $this$execute, this.$params, this.$page);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            public final Object invoke(Transaction p1, Continuation<? super SearchResults> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    @Nullable
    public final Object countActions(@NotNull ActionSearchParams params, @NotNull Continuation<? super Long> $completion) {
        return this.execute((Function2)new Function2<Transaction, Continuation<? super Long>, Object>(params, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ ActionSearchParams $params;
            {
                this.$params = $params;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Transaction $this$execute = (Transaction)this.L$0;
                        return Boxing.boxLong((long)DatabaseManager.access$countActions(DatabaseManager.INSTANCE, $this$execute, this.$params));
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            public final Object invoke(Transaction p1, Continuation<? super Long> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    @Nullable
    public final Object rollbackActions(@NotNull ActionSearchParams params, @NotNull Continuation<? super List<? extends ActionType>> $completion) {
        return this.execute((Function2)new Function2<Transaction, Continuation<? super List<ActionType>>, Object>(params, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ ActionSearchParams $params;
            {
                this.$params = $params;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Transaction $this$execute = (Transaction)this.L$0;
                        return DatabaseManager.access$selectRollbackActions(DatabaseManager.INSTANCE, $this$execute, this.$params);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            public final Object invoke(Transaction p1, Continuation<? super List<ActionType>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    @Nullable
    public final Object restoreActions(@NotNull ActionSearchParams params, @NotNull Continuation<? super List<? extends ActionType>> $completion) {
        return this.execute((Function2)new Function2<Transaction, Continuation<? super List<ActionType>>, Object>(params, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ ActionSearchParams $params;
            {
                this.$params = $params;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Transaction $this$execute = (Transaction)this.L$0;
                        return DatabaseManager.access$selectRestoreActions(DatabaseManager.INSTANCE, $this$execute, this.$params);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            public final Object invoke(Transaction p1, Continuation<? super List<ActionType>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    @Nullable
    public final Object previewActions(@NotNull ActionSearchParams params, @NotNull Preview.Type type, @NotNull Continuation<? super List<? extends ActionType>> $completion) {
        return this.execute((Function2)new Function2<Transaction, Continuation<? super List<ActionType>>, Object>(params, type, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ ActionSearchParams $params;
            final /* synthetic */ Preview.Type $type;
            {
                this.$params = $params;
                this.$type = $type;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Transaction $this$execute = (Transaction)this.L$0;
                        return DatabaseManager.access$selectActionsPreview(DatabaseManager.INSTANCE, $this$execute, this.$params, this.$type);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            public final Object invoke(Transaction p1, Continuation<? super List<ActionType>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    private final List<ActionType> daoToActionType(List<Tables.Action> actions) {
        List actionTypes = new ArrayList();
        for (Tables.Action action : actions) {
            GameProfile gameProfile;
            class_2680 class_26802;
            class_2680 class_26803;
            Object it;
            ActionType actionType;
            ActionType type;
            Supplier<ActionType> typeSupplier = ActionRegistry.INSTANCE.getType(action.getActionIdentifier().getIdentifier());
            if (typeSupplier == null) {
                LedgerKt.logWarn("Unknown action type " + action.getActionIdentifier().getIdentifier());
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)typeSupplier.get(), (String)"get(...)");
            type.setTimestamp(action.getTimestamp());
            type.setPos(new class_2338(action.getX(), action.getY(), action.getZ()));
            type.setWorld(action.getWorld().getIdentifier());
            type.setObjectIdentifier(action.getObjectId().getIdentifier());
            type.setOldObjectIdentifier(action.getOldObjectId().getIdentifier());
            ActionType actionType2 = type;
            if (action.getBlockState() != null) {
                actionType = actionType2;
                boolean bl = false;
                class_2487 class_24872 = class_2522.method_10718((String)it);
                Intrinsics.checkNotNullExpressionValue((Object)class_24872, (String)"parse(...)");
                class_26803 = NbtUtils.INSTANCE.blockStateFromProperties(class_24872, action.getObjectId().getIdentifier());
                actionType2 = actionType;
            } else {
                class_26803 = null;
            }
            actionType2.setBlockState(class_26803);
            ActionType actionType3 = type;
            if (action.getOldBlockState() != null) {
                actionType = actionType3;
                boolean bl = false;
                class_2487 class_24873 = class_2522.method_10718((String)it);
                Intrinsics.checkNotNullExpressionValue((Object)class_24873, (String)"parse(...)");
                class_26802 = NbtUtils.INSTANCE.blockStateFromProperties(class_24873, action.getOldObjectId().getIdentifier());
                actionType3 = actionType;
            } else {
                class_26802 = null;
            }
            actionType3.setOldBlockState(class_26802);
            type.setSourceName(action.getSourceName().getName());
            ActionType actionType4 = type;
            if (action.getSourcePlayer() != null) {
                actionType = actionType4;
                boolean bl = false;
                gameProfile = new GameProfile(((Tables.Player)it).getPlayerId(), ((Tables.Player)it).getPlayerName());
                actionType4 = actionType;
            } else {
                gameProfile = null;
            }
            actionType4.setSourceProfile(gameProfile);
            type.setExtraData(action.getExtraData());
            type.setRolledBack(action.getRolledBack());
            actionTypes.add(type);
        }
        return actionTypes;
    }

    private final Query buildQuery(ActionSearchParams params) {
        Collection<Negatable<String>> collection;
        List list2;
        Negatable it;
        Collection<Negatable<String>> collection2;
        Iterable $this$mapTo$iv$iv;
        boolean $i$f$mapTo;
        Collection destination$iv$iv;
        Iterable $this$map$iv;
        boolean $i$f$map;
        DatabaseManager databaseManager;
        Query query;
        Alias<Table> oldObjectTable = AliasKt.alias((Table)Tables.ObjectIdentifiers.INSTANCE, "oldObjects");
        Query query2 = QueriesKt.selectAll(TableKt.innerJoin$default(TableKt.innerJoin$default(Tables.Actions.INSTANCE.innerJoin(Tables.ActionIdentifiers.INSTANCE).innerJoin(Tables.Worlds.INSTANCE).leftJoin(Tables.Players.INSTANCE), oldObjectTable, DatabaseManager::buildQuery$lambda$4, arg_0 -> DatabaseManager.buildQuery$lambda$5(oldObjectTable, arg_0), null, 8, null), Tables.ObjectIdentifiers.INSTANCE, DatabaseManager::buildQuery$lambda$6, DatabaseManager::buildQuery$lambda$7, null, 8, null).innerJoin(Tables.Sources.INSTANCE));
        if (params.getBounds() != null) {
            QueryKt.andWhere(query2, (Function1<? super SqlExpressionBuilder, ? extends Op<Boolean>>)((Function1)arg_0 -> DatabaseManager.buildQuery$lambda$8(params, arg_0)));
            QueryKt.andWhere(query2, (Function1<? super SqlExpressionBuilder, ? extends Op<Boolean>>)((Function1)arg_0 -> DatabaseManager.buildQuery$lambda$9(params, arg_0)));
            QueryKt.andWhere(query2, (Function1<? super SqlExpressionBuilder, ? extends Op<Boolean>>)((Function1)arg_0 -> DatabaseManager.buildQuery$lambda$10(params, arg_0)));
        }
        if (params.getBefore() != null && params.getAfter() != null) {
            QueryKt.andWhere(QueryKt.andWhere(query2, (Function1<? super SqlExpressionBuilder, ? extends Op<Boolean>>)((Function1)arg_0 -> DatabaseManager.buildQuery$lambda$11(params, arg_0))), (Function1<? super SqlExpressionBuilder, ? extends Op<Boolean>>)((Function1)arg_0 -> DatabaseManager.buildQuery$lambda$12(params, arg_0)));
        } else if (params.getBefore() != null) {
            QueryKt.andWhere(query2, (Function1<? super SqlExpressionBuilder, ? extends Op<Boolean>>)((Function1)arg_0 -> DatabaseManager.buildQuery$lambda$13(params, arg_0)));
        } else if (params.getAfter() != null) {
            QueryKt.andWhere(query2, (Function1<? super SqlExpressionBuilder, ? extends Op<Boolean>>)((Function1)arg_0 -> DatabaseManager.buildQuery$lambda$14(params, arg_0)));
        }
        DatabaseManager.addParameters$default(this, query2, params.getSourceNames(), Tables.Sources.INSTANCE.getName(), null, 8, null);
        DatabaseManager.addParameters$default(this, query2, params.getActions(), Tables.ActionIdentifiers.INSTANCE.getActionIdentifier(), null, 8, null);
        DatabaseManager databaseManager2 = this;
        Query query3 = query2;
        Set<Negatable<class_2960>> set = params.getWorlds();
        if (set != null) {
            Iterable iterable = set;
            query = query3;
            databaseManager = databaseManager2;
            $i$f$map = false;
            void var6_8 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Negatable negatable = (Negatable)item$iv$iv;
                collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(it.getAllowed() ? Negatable.Companion.allow(((class_2960)it.getProperty()).toString()) : Negatable.Companion.deny(((class_2960)it.getProperty()).toString()));
            }
            collection2 = (List)destination$iv$iv;
            databaseManager2 = databaseManager;
            query3 = query;
            list2 = collection2;
        } else {
            list2 = null;
        }
        DatabaseManager.addParameters$default(databaseManager2, query3, list2, Tables.Worlds.INSTANCE.getIdentifier(), null, 8, null);
        DatabaseManager databaseManager3 = this;
        Query query4 = query2;
        Set<Negatable<class_2960>> set2 = params.getObjects();
        if (set2 != null) {
            $this$map$iv = set2;
            query = query4;
            databaseManager = databaseManager3;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Negatable)item$iv$iv;
                collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(it.getAllowed() ? Negatable.Companion.allow(((class_2960)it.getProperty()).toString()) : Negatable.Companion.deny(((class_2960)it.getProperty()).toString()));
            }
            collection2 = (List)destination$iv$iv;
            databaseManager3 = databaseManager;
            query4 = query;
            collection = collection2;
        } else {
            collection = null;
        }
        databaseManager3.addParameters(query4, (Collection)collection, Tables.ObjectIdentifiers.INSTANCE.getIdentifier(), oldObjectTable.get(Tables.ObjectIdentifiers.INSTANCE.getIdentifier()));
        DatabaseManager.addParameters$default(this, query2, params.getSourcePlayerNames(), Tables.Players.INSTANCE.getPlayerName(), null, 8, null);
        return query2;
    }

    /*
     * WARNING - void declaration
     */
    private final <E> void addParameters(Query query, Collection<Negatable<E>> paramSet, Column<E> column, Column<E> orColumn) {
        Iterable $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Negatable it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Iterable<Negatable<E>> iterable = paramSet;
        if (iterable == null || iterable.isEmpty()) {
            return;
        }
        iterable = paramSet;
        Column<E> column2 = column;
        Query query2 = query;
        Column<E> column3 = orColumn;
        boolean $i$f$filter = false;
        void var7_10 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Negatable)element$iv$iv;
            boolean bl = false;
            if (!it.getAllowed()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection collection = (List)destination$iv$iv;
        $this$filter$iv = collection;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Negatable)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getProperty());
        }
        collection = (List)destination$iv$iv;
        DatabaseManager.addParameters$addAllowedParameters(column3, query2, column2, collection);
        $this$map$iv = paramSet;
        column2 = column;
        query2 = query;
        column3 = orColumn;
        boolean $i$f$filterNot = false;
        $this$mapTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (Negatable)element$iv$iv;
            boolean bl = false;
            if (it.getAllowed()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        collection = (List)destination$iv$iv;
        $this$filterNot$iv = collection;
        $i$f$map = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Negatable)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getProperty());
        }
        collection = (List)destination$iv$iv;
        DatabaseManager.addParameters$addDeniedParameters(column3, query2, column2, collection);
    }

    static /* synthetic */ void addParameters$default(DatabaseManager databaseManager, Query query, Collection collection, Column column, Column column2, int n, Object object) {
        if ((n & 8) != 0) {
            column2 = null;
        }
        databaseManager.addParameters(query, collection, column, column2);
    }

    public final void logAction(@NotNull ActionType action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        if (action.isBlacklisted()) {
            return;
        }
        _actions.tryEmit((Object)action);
    }

    @Nullable
    public final Object registerWorld(@NotNull class_2960 identifier, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.execute((Function2)new Function2<Transaction, Continuation<? super Unit>, Object>(identifier, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ class_2960 $identifier;
            {
                this.$identifier = $identifier;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Transaction $this$execute = (Transaction)this.L$0;
                        DatabaseManager.access$insertWorld(DatabaseManager.INSTANCE, $this$execute, this.$identifier);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            public final Object invoke(Transaction p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object registerActionType(@NotNull String id, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.execute((Function2)new Function2<Transaction, Continuation<? super Unit>, Object>(id, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ String $id;
            {
                this.$id = $id;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Transaction $this$execute = (Transaction)this.L$0;
                        DatabaseManager.access$insertActionType(DatabaseManager.INSTANCE, $this$execute, this.$id);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            public final Object invoke(Transaction p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object logPlayer(@NotNull UUID uuid, @NotNull String name, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.execute((Function2)new Function2<Transaction, Continuation<? super Unit>, Object>(uuid, name, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ UUID $uuid;
            final /* synthetic */ String $name;
            {
                this.$uuid = $uuid;
                this.$name = $name;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Transaction $this$execute = (Transaction)this.L$0;
                        DatabaseManager.access$insertPlayer(DatabaseManager.INSTANCE, $this$execute, this.$uuid, this.$name);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            public final Object invoke(Transaction p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object insertIdentifiers(@NotNull Collection<? extends class_2960> identifiers, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.execute((Function2)new Function2<Transaction, Continuation<? super Unit>, Object>(identifiers, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Collection<class_2960> $identifiers;
            {
                this.$identifiers = $identifiers;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Transaction $this$execute = (Transaction)this.L$0;
                        DatabaseManager.access$insertRegKeys(DatabaseManager.INSTANCE, $this$execute, this.$identifiers);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            public final Object invoke(Transaction p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Exception decompiling
     */
    private final <T> Object execute(Function2<? super Transaction, ? super Continuation<? super T>, ? extends Object> var1_1, Continuation<? super T> $completion) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 11[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nullable
    public final Object purgeActions(@NotNull ActionSearchParams params, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.execute((Function2)new Function2<Transaction, Continuation<? super Unit>, Object>(params, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ ActionSearchParams $params;
            {
                this.$params = $params;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Transaction $this$execute = (Transaction)this.L$0;
                        DatabaseManager.access$purgeActions(DatabaseManager.INSTANCE, $this$execute, this.$params);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            public final Object invoke(Transaction p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object searchPlayers(@NotNull Set<? extends GameProfile> players, @NotNull Continuation<? super List<PlayerResult>> $completion) {
        return this.execute((Function2)new Function2<Transaction, Continuation<? super List<? extends PlayerResult>>, Object>(players, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Set<GameProfile> $players;
            {
                this.$players = $players;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Transaction $this$execute = (Transaction)this.L$0;
                        return DatabaseManager.access$selectPlayers(DatabaseManager.INSTANCE, $this$execute, this.$players);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            public final Object invoke(Transaction p1, Continuation<? super List<PlayerResult>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    private final void insertActionType(Transaction $this$insertActionType, String id) {
        if (Tables.ActionIdentifier.Companion.find((Function1<SqlExpressionBuilder, Op<Boolean>>)((Function1)arg_0 -> DatabaseManager.insertActionType$lambda$36(id, arg_0))).empty()) {
            Tables.ActionIdentifier actionIdentifier = (Tables.ActionIdentifier)Tables.ActionIdentifier.Companion.new(arg_0 -> DatabaseManager.insertActionType$lambda$37(id, arg_0));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void insertWorld(Transaction $this$insertWorld, class_2960 identifier) {
        void it;
        InsertStatement insertStatement;
        Table $this$insertIgnore$iv = Tables.Worlds.INSTANCE;
        boolean $i$f$insertIgnore = false;
        InsertStatement $this$insertIgnore_u24lambda_u2410$iv = insertStatement = new InsertStatement($this$insertIgnore$iv, true);
        boolean bl = false;
        UpdateBuilder updateBuilder = $this$insertIgnore_u24lambda_u2410$iv;
        Tables.Worlds $this$insertWorld_u24lambda_u2438 = (Tables.Worlds)$this$insertIgnore$iv;
        boolean bl2 = false;
        it.set($this$insertWorld_u24lambda_u2438.getIdentifier(), identifier.toString());
        $this$insertIgnore_u24lambda_u2410$iv.execute(TransactionManager.Companion.current());
    }

    private final void insertRegKeys(Transaction $this$insertRegKeys, Collection<? extends class_2960> identifiers) {
        QueriesKt.batchInsert$default((Table)Tables.ObjectIdentifiers.INSTANCE, identifiers, true, false, DatabaseManager::insertRegKeys$lambda$39, 4, null);
    }

    private final void insertAction(Transaction $this$insertAction, ActionType action) {
        Tables.Action.Companion.new(arg_0 -> DatabaseManager.insertAction$lambda$43($this$insertAction, action, arg_0));
    }

    private final void insertPlayer(Transaction $this$insertPlayer, UUID uuid, String name) {
        Tables.Player player = (Tables.Player)CollectionsKt.firstOrNull((Iterable)Tables.Player.Companion.find((Function1<SqlExpressionBuilder, Op<Boolean>>)((Function1)arg_0 -> DatabaseManager.insertPlayer$lambda$44(uuid, arg_0))));
        if (player != null) {
            Instant instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
            player.setLastJoin(instant);
            player.setPlayerName(name);
        } else {
            Tables.Player.Companion.new(arg_0 -> DatabaseManager.insertPlayer$lambda$45(uuid, name, arg_0));
        }
    }

    private final SearchResults selectActionsSearch(Transaction $this$selectActionsSearch, ActionSearchParams params, int page2) {
        List actionTypes = new ArrayList();
        long totalActions = 0L;
        Query query = this.buildQuery(params);
        totalActions = query.copy().count();
        if (totalActions == 0L) {
            return new SearchResults(actionTypes, params, page2, 0);
        }
        query = (Query)query.orderBy((Expression)Tables.Actions.INSTANCE.getId(), SortOrder.DESC);
        query = (Query)AbstractQuery.withDistinct$default((AbstractQuery)((Query)query.limit(((Number)LedgerConfigKt.getConfig().get(SearchSpec.INSTANCE.getPageSize())).intValue())).offset(((Number)LedgerConfigKt.getConfig().get(SearchSpec.INSTANCE.getPageSize())).intValue() * (page2 - 1)), false, 1, null);
        List actions = CollectionsKt.toList((Iterable)Tables.Action.Companion.wrapRows(query));
        actionTypes.addAll((Collection)this.daoToActionType(actions));
        int totalPages = (int)Math.ceil((double)totalActions / (double)((Number)LedgerConfigKt.getConfig().get(SearchSpec.INSTANCE.getPageSize())).intValue());
        return new SearchResults(actionTypes, params, page2, totalPages);
    }

    private final long countActions(Transaction $this$countActions, ActionSearchParams params) {
        return this.buildQuery(params).copy().count();
    }

    private final List<ActionType> selectActionsPreview(Transaction $this$selectActionsPreview, ActionSearchParams params, Preview.Type type) {
        List actionTypes = new ArrayList();
        boolean isRestore = type == Preview.Type.RESTORE;
        Query query = (Query)QueryKt.andWhere(this.buildQuery(params), (Function1<? super SqlExpressionBuilder, ? extends Op<Boolean>>)((Function1)arg_0 -> DatabaseManager.selectActionsPreview$lambda$46(isRestore, arg_0))).orderBy((Expression)Tables.Actions.INSTANCE.getId(), isRestore ? SortOrder.ASC : SortOrder.DESC);
        List actions = CollectionsKt.toList((Iterable)Tables.Action.Companion.wrapRows(query));
        actionTypes.addAll((Collection)this.daoToActionType(actions));
        return actionTypes;
    }

    private final List<ActionType> selectRollbackActions(Transaction $this$selectRollbackActions, ActionSearchParams params) {
        List actionTypes = new ArrayList();
        Query query = (Query)QueryKt.andWhere(this.buildQuery(params), (Function1<? super SqlExpressionBuilder, ? extends Op<Boolean>>)((Function1)DatabaseManager::selectRollbackActions$lambda$47)).orderBy((Expression)Tables.Actions.INSTANCE.getId(), SortOrder.DESC);
        List actions = CollectionsKt.toList((Iterable)Tables.Action.Companion.wrapRows(query));
        for (Tables.Action action : actions) {
            action.setRolledBack(true);
        }
        actionTypes.addAll((Collection)this.daoToActionType(actions));
        return actionTypes;
    }

    private final List<ActionType> selectRestoreActions(Transaction $this$selectRestoreActions, ActionSearchParams params) {
        List actionTypes = new ArrayList();
        Query query = (Query)QueryKt.andWhere(this.buildQuery(params), (Function1<? super SqlExpressionBuilder, ? extends Op<Boolean>>)((Function1)DatabaseManager::selectRestoreActions$lambda$48)).orderBy((Expression)Tables.Actions.INSTANCE.getId(), SortOrder.ASC);
        List actions = CollectionsKt.toList((Iterable)Tables.Action.Companion.wrapRows(query));
        for (Tables.Action action : actions) {
            action.setRolledBack(false);
        }
        actionTypes.addAll((Collection)this.daoToActionType(actions));
        return actionTypes;
    }

    private final Tables.Player selectPlayer(Transaction $this$selectPlayer, UUID playerId) {
        return (Tables.Player)CollectionsKt.firstOrNull((Iterable)Tables.Player.Companion.find((Function1<SqlExpressionBuilder, Op<Boolean>>)((Function1)arg_0 -> DatabaseManager.selectPlayer$lambda$49(playerId, arg_0))));
    }

    private final Tables.Player selectPlayer(Transaction $this$selectPlayer, String playerName) {
        return (Tables.Player)CollectionsKt.firstOrNull((Iterable)Tables.Player.Companion.find((Function1<SqlExpressionBuilder, Op<Boolean>>)((Function1)arg_0 -> DatabaseManager.selectPlayer$lambda$50(playerName, arg_0))));
    }

    /*
     * WARNING - void declaration
     */
    private final Tables.Source insertAndSelectSource(Transaction $this$insertAndSelectSource, String source) {
        Tables.Source sourceDAO = (Tables.Source)CollectionsKt.firstOrNull((Iterable)Tables.Source.Companion.find((Function1<SqlExpressionBuilder, Op<Boolean>>)((Function1)arg_0 -> DatabaseManager.insertAndSelectSource$lambda$51(source, arg_0))));
        if (sourceDAO == null) {
            void $this$insertAndSelectSource_u24lambda_u2452;
            void it;
            IdTable $this$insertAndGetId$iv = Tables.Sources.INSTANCE;
            boolean $i$f$insertAndGetId = false;
            InsertStatement $this$insertAndGetId_u24lambda_u244$iv = new InsertStatement($this$insertAndGetId$iv, false);
            boolean bl = false;
            InsertStatement insertStatement = $this$insertAndGetId_u24lambda_u244$iv;
            Tables.Sources sources = (Tables.Sources)$this$insertAndGetId$iv;
            Tables.Source.Companion companion = Tables.Source.Companion;
            boolean bl2 = false;
            it.set($this$insertAndSelectSource_u24lambda_u2452.getName(), source);
            $this$insertAndGetId_u24lambda_u244$iv.execute(TransactionManager.Companion.current());
            sourceDAO = (Tables.Source)companion.get($this$insertAndGetId_u24lambda_u244$iv.get($this$insertAndGetId$iv.getId()));
        }
        return sourceDAO;
    }

    private final Tables.ActionIdentifier selectActionId(Transaction $this$selectActionId, String id) {
        return (Tables.ActionIdentifier)CollectionsKt.first((Iterable)Tables.ActionIdentifier.Companion.find((Function1<SqlExpressionBuilder, Op<Boolean>>)((Function1)arg_0 -> DatabaseManager.selectActionId$lambda$53(id, arg_0))));
    }

    private final Tables.ObjectIdentifier selectRegistryKey(Transaction $this$selectRegistryKey, class_2960 identifier) {
        return (Tables.ObjectIdentifier)CollectionsKt.first((Iterable)Tables.ObjectIdentifier.Companion.find((Function1<SqlExpressionBuilder, Op<Boolean>>)((Function1)arg_0 -> DatabaseManager.selectRegistryKey$lambda$54(identifier, arg_0))).limit(1));
    }

    private final Tables.World selectWorld(Transaction $this$selectWorld, class_2960 identifier) {
        return (Tables.World)CollectionsKt.first((Iterable)Tables.World.Companion.find((Function1<SqlExpressionBuilder, Op<Boolean>>)((Function1)arg_0 -> DatabaseManager.selectWorld$lambda$55(identifier, arg_0))).limit(1));
    }

    private final void purgeActions(Transaction $this$purgeActions, ActionSearchParams params) {
        Query query = this.buildQuery(params);
        List actions = CollectionsKt.toList((Iterable)Tables.Action.Companion.wrapRows(query));
        Iterable $this$forEach$iv = actions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Tables.Action action = (Tables.Action)element$iv;
            boolean bl = false;
            action.delete();
        }
    }

    private final List<PlayerResult> selectPlayers(Transaction $this$selectPlayers, Set<? extends GameProfile> players) {
        Tables.Player it;
        Collection<Negatable<UUID>> collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Query query = QueriesKt.selectAll(Tables.Players.INSTANCE);
        Iterable iterable = players;
        Query query2 = query;
        Object object = this;
        boolean $i$f$map = false;
        void var6_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            GameProfile gameProfile = (GameProfile)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Negatable.Companion.allow(it.getId()));
        }
        collection = (List)destination$iv$iv;
        DatabaseManager.addParameters$default((DatabaseManager)object, query2, collection, Tables.Players.INSTANCE.getPlayerId(), null, 8, null);
        $this$map$iv = CollectionsKt.toList((Iterable)Tables.Player.Companion.wrapRows(query));
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Tables.Player)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(PlayerResult.Companion.fromRow(it));
        }
        return (List)destination$iv$iv;
    }

    private static final Unit ensureTables$lambda$0(Transaction $this$transaction) {
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        Table[] tableArray = new Table[]{Tables.Players.INSTANCE, Tables.Actions.INSTANCE, Tables.ActionIdentifiers.INSTANCE, Tables.ObjectIdentifiers.INSTANCE, Tables.Sources.INSTANCE, Tables.Worlds.INSTANCE};
        SchemaUtils.createMissingTablesAndColumns$default(SchemaUtils.INSTANCE, tableArray, false, false, 6, null);
        LedgerKt.logInfo("Tables created");
        return Unit.INSTANCE;
    }

    private static final Expression buildQuery$lambda$4(Join $this$innerJoin) {
        Intrinsics.checkNotNullParameter((Object)$this$innerJoin, (String)"$this$innerJoin");
        return Tables.Actions.INSTANCE.getOldObjectId();
    }

    private static final Expression buildQuery$lambda$5(Alias $oldObjectTable, Alias $this$innerJoin) {
        Intrinsics.checkNotNullParameter((Object)$this$innerJoin, (String)"$this$innerJoin");
        return $oldObjectTable.get(Tables.ObjectIdentifiers.INSTANCE.getId());
    }

    private static final Expression buildQuery$lambda$6(Join $this$innerJoin) {
        Intrinsics.checkNotNullParameter((Object)$this$innerJoin, (String)"$this$innerJoin");
        return Tables.Actions.INSTANCE.getObjectId();
    }

    private static final Expression buildQuery$lambda$7(Tables.ObjectIdentifiers $this$innerJoin) {
        Intrinsics.checkNotNullParameter((Object)$this$innerJoin, (String)"$this$innerJoin");
        return Tables.ObjectIdentifiers.INSTANCE.getId();
    }

    private static final Op buildQuery$lambda$8(ActionSearchParams $params, SqlExpressionBuilder $this$andWhere) {
        Intrinsics.checkNotNullParameter((Object)$this$andWhere, (String)"$this$andWhere");
        return $this$andWhere.between((ExpressionWithColumnType)Tables.Actions.INSTANCE.getX(), Integer.valueOf($params.getBounds().method_35415()), Integer.valueOf($params.getBounds().method_35418()));
    }

    private static final Op buildQuery$lambda$9(ActionSearchParams $params, SqlExpressionBuilder $this$andWhere) {
        Intrinsics.checkNotNullParameter((Object)$this$andWhere, (String)"$this$andWhere");
        return $this$andWhere.between((ExpressionWithColumnType)Tables.Actions.INSTANCE.getY(), Integer.valueOf($params.getBounds().method_35416()), Integer.valueOf($params.getBounds().method_35419()));
    }

    private static final Op buildQuery$lambda$10(ActionSearchParams $params, SqlExpressionBuilder $this$andWhere) {
        Intrinsics.checkNotNullParameter((Object)$this$andWhere, (String)"$this$andWhere");
        return $this$andWhere.between((ExpressionWithColumnType)Tables.Actions.INSTANCE.getZ(), Integer.valueOf($params.getBounds().method_35417()), Integer.valueOf($params.getBounds().method_35420()));
    }

    private static final Op buildQuery$lambda$11(ActionSearchParams $params, SqlExpressionBuilder $this$andWhere) {
        Intrinsics.checkNotNullParameter((Object)$this$andWhere, (String)"$this$andWhere");
        return $this$andWhere.greaterEq((ExpressionWithColumnType)Tables.Actions.INSTANCE.getTimestamp(), (Comparable)$params.getAfter());
    }

    private static final Op buildQuery$lambda$12(ActionSearchParams $params, SqlExpressionBuilder $this$andWhere) {
        Intrinsics.checkNotNullParameter((Object)$this$andWhere, (String)"$this$andWhere");
        return $this$andWhere.lessEq((ExpressionWithColumnType)Tables.Actions.INSTANCE.getTimestamp(), (Comparable)$params.getBefore());
    }

    private static final Op buildQuery$lambda$13(ActionSearchParams $params, SqlExpressionBuilder $this$andWhere) {
        Intrinsics.checkNotNullParameter((Object)$this$andWhere, (String)"$this$andWhere");
        return $this$andWhere.lessEq((ExpressionWithColumnType)Tables.Actions.INSTANCE.getTimestamp(), (Comparable)$params.getBefore());
    }

    private static final Op buildQuery$lambda$14(ActionSearchParams $params, SqlExpressionBuilder $this$andWhere) {
        Intrinsics.checkNotNullParameter((Object)$this$andWhere, (String)"$this$andWhere");
        return $this$andWhere.greaterEq((ExpressionWithColumnType)Tables.Actions.INSTANCE.getTimestamp(), (Comparable)$params.getAfter());
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit addParameters$addAllowedParameters$lambda$21(Ref.ObjectRef $operator, Column $orColumn, Column $column, Object param) {
        Op<Boolean> op;
        Ref.ObjectRef objectRef = $operator;
        if ($orColumn != null) {
            void $this$addParameters_u24addAllowedParameters_u24lambda_u2421_u24lambda_u2419;
            Expression $this$or$iv = (Expression)$operator.element;
            boolean $i$f$or = false;
            Op.Companion this_$iv$iv = Op.Companion;
            boolean $i$f$build = false;
            SqlExpressionBuilder sqlExpressionBuilder = SqlExpressionBuilder.INSTANCE;
            Expression expression = $this$or$iv;
            Ref.ObjectRef objectRef2 = objectRef;
            boolean bl = false;
            Op<Boolean> op2 = OpKt.or((Expression<Boolean>)$this$addParameters_u24addAllowedParameters_u24lambda_u2421_u24lambda_u2419.eq((ExpressionWithColumnType)$column, param), (Expression<Boolean>)$this$addParameters_u24addAllowedParameters_u24lambda_u2421_u24lambda_u2419.eq((ExpressionWithColumnType)$orColumn, param));
            v1 = objectRef2;
            op = OpKt.or((Expression<Boolean>)expression, (Expression<Boolean>)op2);
        } else {
            void $this$addParameters_u24addAllowedParameters_u24lambda_u2421_u24lambda_u2420;
            Expression $this$or$iv = (Expression)$operator.element;
            boolean $i$f$or = false;
            Op.Companion this_$iv$iv = Op.Companion;
            boolean $i$f$build = false;
            SqlExpressionBuilder $this$addParameters_u24addAllowedParameters_u24lambda_u2421_u24lambda_u2419 = SqlExpressionBuilder.INSTANCE;
            Expression expression = $this$or$iv;
            Ref.ObjectRef objectRef3 = objectRef;
            boolean bl = false;
            Op<Boolean> op3 = $this$addParameters_u24addAllowedParameters_u24lambda_u2421_u24lambda_u2420.eq((ExpressionWithColumnType)$column, param);
            v1 = objectRef3;
            op = OpKt.or((Expression<Boolean>)expression, (Expression<Boolean>)op3);
        }
        v1.element = op;
        return Unit.INSTANCE;
    }

    private static final void addParameters$addAllowedParameters$lambda$22(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Op addParameters$addAllowedParameters$lambda$23(Ref.ObjectRef $operator, SqlExpressionBuilder $this$andWhere) {
        Intrinsics.checkNotNullParameter((Object)$this$andWhere, (String)"$this$andWhere");
        return (Op)$operator.element;
    }

    /*
     * WARNING - void declaration
     */
    private static final <E> void addParameters$addAllowedParameters(Column<E> $orColumn, Query $query, Column<E> $column, Collection<? extends E> allowed) {
        Op<Boolean> op;
        Ref.ObjectRef operator;
        if (allowed.isEmpty()) {
            return;
        }
        Ref.ObjectRef objectRef = operator = new Ref.ObjectRef();
        if ($orColumn != null) {
            void $this$addParameters_u24addAllowedParameters_u24lambda_u2417;
            Op.Companion this_$iv = Op.Companion;
            boolean $i$f$build = false;
            SqlExpressionBuilder sqlExpressionBuilder = SqlExpressionBuilder.INSTANCE;
            Ref.ObjectRef objectRef2 = objectRef;
            boolean bl = false;
            op = OpKt.or((Expression<Boolean>)$this$addParameters_u24addAllowedParameters_u24lambda_u2417.eq($column, CollectionsKt.first((Iterable)allowed)), (Expression<Boolean>)$this$addParameters_u24addAllowedParameters_u24lambda_u2417.eq($orColumn, CollectionsKt.first((Iterable)allowed)));
            v2 = objectRef2;
        } else {
            void $this$addParameters_u24addAllowedParameters_u24lambda_u2418;
            Op.Companion this_$iv = Op.Companion;
            boolean $i$f$build = false;
            SqlExpressionBuilder $this$addParameters_u24addAllowedParameters_u24lambda_u2417 = SqlExpressionBuilder.INSTANCE;
            Ref.ObjectRef objectRef3 = objectRef;
            boolean bl = false;
            op = $this$addParameters_u24addAllowedParameters_u24lambda_u2418.eq($column, CollectionsKt.first((Iterable)allowed));
            v2 = objectRef3;
        }
        v2.element = op;
        allowed.stream().skip(1L).forEach(arg_0 -> DatabaseManager.addParameters$addAllowedParameters$lambda$22(arg_0 -> DatabaseManager.addParameters$addAllowedParameters$lambda$21(operator, $orColumn, $column, arg_0), arg_0));
        QueryKt.andWhere($query, (Function1<? super SqlExpressionBuilder, ? extends Op<Boolean>>)((Function1)arg_0 -> DatabaseManager.addParameters$addAllowedParameters$lambda$23(operator, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit addParameters$addDeniedParameters$lambda$28(Ref.ObjectRef $operator, Column $orColumn, Column $column, Object param) {
        Op<Boolean> op;
        Ref.ObjectRef objectRef = $operator;
        if ($orColumn != null) {
            void $this$addParameters_u24addDeniedParameters_u24lambda_u2428_u24lambda_u2426;
            Expression $this$and$iv = (Expression)$operator.element;
            boolean $i$f$and = false;
            Op.Companion this_$iv$iv = Op.Companion;
            boolean $i$f$build = false;
            SqlExpressionBuilder sqlExpressionBuilder = SqlExpressionBuilder.INSTANCE;
            Expression expression = $this$and$iv;
            Ref.ObjectRef objectRef2 = objectRef;
            boolean bl = false;
            Op<Boolean> op2 = OpKt.and((Expression<Boolean>)$this$addParameters_u24addDeniedParameters_u24lambda_u2428_u24lambda_u2426.neq((ExpressionWithColumnType)$column, param), (Expression<Boolean>)$this$addParameters_u24addDeniedParameters_u24lambda_u2428_u24lambda_u2426.neq((ExpressionWithColumnType)$orColumn, param));
            v1 = objectRef2;
            op = OpKt.and((Expression<Boolean>)expression, (Expression<Boolean>)op2);
        } else {
            void $this$addParameters_u24addDeniedParameters_u24lambda_u2428_u24lambda_u2427;
            Expression $this$and$iv = (Expression)$operator.element;
            boolean $i$f$and = false;
            Op.Companion this_$iv$iv = Op.Companion;
            boolean $i$f$build = false;
            SqlExpressionBuilder $this$addParameters_u24addDeniedParameters_u24lambda_u2428_u24lambda_u2426 = SqlExpressionBuilder.INSTANCE;
            Expression expression = $this$and$iv;
            Ref.ObjectRef objectRef3 = objectRef;
            boolean bl = false;
            Op<Boolean> op3 = OpKt.or((Expression<Boolean>)$this$addParameters_u24addDeniedParameters_u24lambda_u2428_u24lambda_u2427.neq((ExpressionWithColumnType)$column, param), (Expression<Boolean>)$this$addParameters_u24addDeniedParameters_u24lambda_u2428_u24lambda_u2427.isNull($column));
            v1 = objectRef3;
            op = OpKt.and((Expression<Boolean>)expression, (Expression<Boolean>)op3);
        }
        v1.element = op;
        return Unit.INSTANCE;
    }

    private static final void addParameters$addDeniedParameters$lambda$29(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Op addParameters$addDeniedParameters$lambda$30(Ref.ObjectRef $operator, SqlExpressionBuilder $this$andWhere) {
        Intrinsics.checkNotNullParameter((Object)$this$andWhere, (String)"$this$andWhere");
        return (Op)$operator.element;
    }

    /*
     * WARNING - void declaration
     */
    private static final <E> void addParameters$addDeniedParameters(Column<E> $orColumn, Query $query, Column<E> $column, Collection<? extends E> denied) {
        Op<Boolean> op;
        Ref.ObjectRef operator;
        if (denied.isEmpty()) {
            return;
        }
        Ref.ObjectRef objectRef = operator = new Ref.ObjectRef();
        if ($orColumn != null) {
            void $this$addParameters_u24addDeniedParameters_u24lambda_u2424;
            Op.Companion this_$iv = Op.Companion;
            boolean $i$f$build = false;
            SqlExpressionBuilder sqlExpressionBuilder = SqlExpressionBuilder.INSTANCE;
            Ref.ObjectRef objectRef2 = objectRef;
            boolean bl = false;
            op = OpKt.and((Expression<Boolean>)$this$addParameters_u24addDeniedParameters_u24lambda_u2424.neq($column, CollectionsKt.first((Iterable)denied)), (Expression<Boolean>)$this$addParameters_u24addDeniedParameters_u24lambda_u2424.neq($orColumn, CollectionsKt.first((Iterable)denied)));
            v2 = objectRef2;
        } else {
            void $this$addParameters_u24addDeniedParameters_u24lambda_u2425;
            Op.Companion this_$iv = Op.Companion;
            boolean $i$f$build = false;
            SqlExpressionBuilder $this$addParameters_u24addDeniedParameters_u24lambda_u2424 = SqlExpressionBuilder.INSTANCE;
            Ref.ObjectRef objectRef3 = objectRef;
            boolean bl = false;
            op = OpKt.or((Expression<Boolean>)$this$addParameters_u24addDeniedParameters_u24lambda_u2425.neq($column, CollectionsKt.first((Iterable)denied)), (Expression<Boolean>)$this$addParameters_u24addDeniedParameters_u24lambda_u2425.isNull($column));
            v2 = objectRef3;
        }
        v2.element = op;
        denied.stream().skip(1L).forEach(arg_0 -> DatabaseManager.addParameters$addDeniedParameters$lambda$29(arg_0 -> DatabaseManager.addParameters$addDeniedParameters$lambda$28(operator, $orColumn, $column, arg_0), arg_0));
        QueryKt.andWhere($query, (Function1<? super SqlExpressionBuilder, ? extends Op<Boolean>>)((Function1)arg_0 -> DatabaseManager.addParameters$addDeniedParameters$lambda$30(operator, arg_0)));
    }

    private static final Op insertActionType$lambda$36(String $id, SqlExpressionBuilder $this$find) {
        Intrinsics.checkNotNullParameter((Object)$this$find, (String)"$this$find");
        return $this$find.eq(Tables.ActionIdentifiers.INSTANCE.getActionIdentifier(), $id);
    }

    private static final Unit insertActionType$lambda$37(String $id, Tables.ActionIdentifier $this$new) {
        Intrinsics.checkNotNullParameter((Object)$this$new, (String)"$this$new");
        $this$new.setIdentifier($id);
        return Unit.INSTANCE;
    }

    private static final Unit insertRegKeys$lambda$39(BatchInsertStatement $this$batchInsert, class_2960 identifier) {
        Intrinsics.checkNotNullParameter((Object)$this$batchInsert, (String)"$this$batchInsert");
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        $this$batchInsert.set(Tables.ObjectIdentifiers.INSTANCE.getIdentifier(), identifier.toString());
        return Unit.INSTANCE;
    }

    private static final Unit insertAction$lambda$43(Transaction $this_insertAction, ActionType $action, Tables.Action $this$new) {
        Tables.Player player;
        String string;
        String string2;
        class_2680 it;
        Tables.Action action;
        Intrinsics.checkNotNullParameter((Object)$this$new, (String)"$this$new");
        $this$new.setActionIdentifier(INSTANCE.selectActionId($this_insertAction, $action.getIdentifier()));
        $this$new.setTimestamp($action.getTimestamp());
        $this$new.setX($action.getPos().method_10263());
        $this$new.setY($action.getPos().method_10264());
        $this$new.setZ($action.getPos().method_10260());
        $this$new.setObjectId(INSTANCE.selectRegistryKey($this_insertAction, $action.getObjectIdentifier()));
        $this$new.setOldObjectId(INSTANCE.selectRegistryKey($this_insertAction, $action.getOldObjectIdentifier()));
        class_2960 class_29602 = $action.getWorld();
        if (class_29602 == null) {
            class_29602 = Ledger.INSTANCE.getServer().method_30002().method_27983().method_29177();
        }
        class_2960 class_29603 = class_29602;
        Intrinsics.checkNotNull((Object)class_29603);
        $this$new.setWorld(INSTANCE.selectWorld($this_insertAction, class_29603));
        Tables.Action action2 = $this$new;
        class_2680 class_26802 = $action.getBlockState();
        if (class_26802 != null) {
            class_2680 class_26803 = class_26802;
            action = action2;
            boolean bl = false;
            class_2487 class_24872 = NbtUtils.INSTANCE.blockStateToProperties(it);
            string2 = class_24872 != null ? class_24872.method_10714() : null;
            action2 = action;
        } else {
            string2 = null;
        }
        action2.setBlockState(string2);
        Tables.Action action3 = $this$new;
        class_2680 class_26804 = $action.getOldBlockState();
        if (class_26804 != null) {
            it = class_26804;
            action = action3;
            boolean bl = false;
            class_2487 class_24873 = NbtUtils.INSTANCE.blockStateToProperties(it);
            string = class_24873 != null ? class_24873.method_10714() : null;
            action3 = action;
        } else {
            string = null;
        }
        action3.setOldBlockState(string);
        $this$new.setSourceName(INSTANCE.insertAndSelectSource($this_insertAction, $action.getSourceName()));
        Tables.Action action4 = $this$new;
        GameProfile gameProfile = $action.getSourceProfile();
        if (gameProfile != null) {
            it = gameProfile;
            action = action4;
            boolean bl = false;
            UUID uUID = it.getId();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getId(...)");
            player = INSTANCE.selectPlayer($this_insertAction, uUID);
            action4 = action;
        } else {
            player = null;
        }
        action4.setSourcePlayer(player);
        $this$new.setExtraData($action.getExtraData());
        return Unit.INSTANCE;
    }

    private static final Op insertPlayer$lambda$44(UUID $uuid, SqlExpressionBuilder $this$find) {
        Intrinsics.checkNotNullParameter((Object)$this$find, (String)"$this$find");
        return $this$find.eq(Tables.Players.INSTANCE.getPlayerId(), $uuid);
    }

    private static final Unit insertPlayer$lambda$45(UUID $uuid, String $name, Tables.Player $this$new) {
        Intrinsics.checkNotNullParameter((Object)$this$new, (String)"$this$new");
        $this$new.setPlayerId($uuid);
        $this$new.setPlayerName($name);
        return Unit.INSTANCE;
    }

    private static final Op selectActionsPreview$lambda$46(boolean $isRestore, SqlExpressionBuilder $this$andWhere) {
        Intrinsics.checkNotNullParameter((Object)$this$andWhere, (String)"$this$andWhere");
        return $this$andWhere.eq(Tables.Actions.INSTANCE.getRolledBack(), Boolean.valueOf($isRestore));
    }

    private static final Op selectRollbackActions$lambda$47(SqlExpressionBuilder $this$andWhere) {
        Intrinsics.checkNotNullParameter((Object)$this$andWhere, (String)"$this$andWhere");
        return $this$andWhere.eq(Tables.Actions.INSTANCE.getRolledBack(), Boolean.valueOf(false));
    }

    private static final Op selectRestoreActions$lambda$48(SqlExpressionBuilder $this$andWhere) {
        Intrinsics.checkNotNullParameter((Object)$this$andWhere, (String)"$this$andWhere");
        return $this$andWhere.eq(Tables.Actions.INSTANCE.getRolledBack(), Boolean.valueOf(true));
    }

    private static final Op selectPlayer$lambda$49(UUID $playerId, SqlExpressionBuilder $this$find) {
        Intrinsics.checkNotNullParameter((Object)$this$find, (String)"$this$find");
        return $this$find.eq(Tables.Players.INSTANCE.getPlayerId(), $playerId);
    }

    private static final Op selectPlayer$lambda$50(String $playerName, SqlExpressionBuilder $this$find) {
        Intrinsics.checkNotNullParameter((Object)$this$find, (String)"$this$find");
        return $this$find.eq((ExpressionWithColumnType)SQLExpressionBuilderKt.lowerCase(Tables.Players.INSTANCE.getPlayerName()), $playerName);
    }

    private static final Op insertAndSelectSource$lambda$51(String $source, SqlExpressionBuilder $this$find) {
        Intrinsics.checkNotNullParameter((Object)$this$find, (String)"$this$find");
        return $this$find.eq(Tables.Sources.INSTANCE.getName(), $source);
    }

    private static final Op selectActionId$lambda$53(String $id, SqlExpressionBuilder $this$find) {
        Intrinsics.checkNotNullParameter((Object)$this$find, (String)"$this$find");
        return $this$find.eq(Tables.ActionIdentifiers.INSTANCE.getActionIdentifier(), $id);
    }

    private static final Op selectRegistryKey$lambda$54(class_2960 $identifier, SqlExpressionBuilder $this$find) {
        Intrinsics.checkNotNullParameter((Object)$this$find, (String)"$this$find");
        return $this$find.eq(Tables.ObjectIdentifiers.INSTANCE.getIdentifier(), $identifier.toString());
    }

    private static final Op selectWorld$lambda$55(class_2960 $identifier, SqlExpressionBuilder $this$find) {
        Intrinsics.checkNotNullParameter((Object)$this$find, (String)"$this$find");
        return $this$find.eq(Tables.Worlds.INSTANCE.getIdentifier(), $identifier.toString());
    }

    public static final /* synthetic */ Object access$execute(DatabaseManager $this, Function2 body, Continuation $completion) {
        return $this.execute(body, $completion);
    }

    public static final /* synthetic */ SearchResults access$selectActionsSearch(DatabaseManager $this, Transaction $receiver, ActionSearchParams params, int page2) {
        return $this.selectActionsSearch($receiver, params, page2);
    }

    public static final /* synthetic */ long access$countActions(DatabaseManager $this, Transaction $receiver, ActionSearchParams params) {
        return $this.countActions($receiver, params);
    }

    public static final /* synthetic */ List access$selectRollbackActions(DatabaseManager $this, Transaction $receiver, ActionSearchParams params) {
        return $this.selectRollbackActions($receiver, params);
    }

    public static final /* synthetic */ List access$selectRestoreActions(DatabaseManager $this, Transaction $receiver, ActionSearchParams params) {
        return $this.selectRestoreActions($receiver, params);
    }

    public static final /* synthetic */ List access$selectActionsPreview(DatabaseManager $this, Transaction $receiver, ActionSearchParams params, Preview.Type type) {
        return $this.selectActionsPreview($receiver, params, type);
    }

    public static final /* synthetic */ void access$insertWorld(DatabaseManager $this, Transaction $receiver, class_2960 identifier) {
        $this.insertWorld($receiver, identifier);
    }

    public static final /* synthetic */ void access$insertActionType(DatabaseManager $this, Transaction $receiver, String id) {
        $this.insertActionType($receiver, id);
    }

    public static final /* synthetic */ void access$insertPlayer(DatabaseManager $this, Transaction $receiver, UUID uuid, String name) {
        $this.insertPlayer($receiver, uuid, name);
    }

    public static final /* synthetic */ void access$insertRegKeys(DatabaseManager $this, Transaction $receiver, Collection identifiers) {
        $this.insertRegKeys($receiver, identifiers);
    }

    public static final /* synthetic */ void access$purgeActions(DatabaseManager $this, Transaction $receiver, ActionSearchParams params) {
        $this.purgeActions($receiver, params);
    }

    public static final /* synthetic */ List access$selectPlayers(DatabaseManager $this, Transaction $receiver, Set players) {
        return $this.selectPlayers($receiver, players);
    }

    static {
        dbMutex = MutexKt.Mutex$default((boolean)false, (int)1, null);
        _actions = SharedFlowKt.MutableSharedFlow$default((int)0, (int)Integer.MAX_VALUE, null, (int)5, null);
        actions = FlowKt.asSharedFlow(_actions);
        BuildersKt.launch$default((CoroutineScope)Ledger.INSTANCE, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
            int label;

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = INSTANCE.getActions().collect((FlowCollector)1.INSTANCE, (Continuation)this);
                        if (object3 != object2) throw new KotlinNothingValueException();
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }
}

