/*
 * Decompiled with CFR 0.152.
 */
package com.github.quiltservertools.libs.com.fasterxml.jackson.module.kotlin;

import com.github.quiltservertools.libs.com.fasterxml.jackson.core.JsonParser;
import com.github.quiltservertools.libs.com.fasterxml.jackson.databind.DeserializationContext;
import com.github.quiltservertools.libs.com.fasterxml.jackson.databind.JsonNode;
import com.github.quiltservertools.libs.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.github.quiltservertools.libs.com.fasterxml.jackson.module.kotlin.RegexDeserializer;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001f\u0010\t\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/github/quiltservertools/libs/com/fasterxml/jackson/module/kotlin/RegexDeserializer;", "Lcom/github/quiltservertools/libs/com/fasterxml/jackson/databind/deser/std/StdDeserializer;", "Lkotlin/text/Regex;", "<init>", "()V", "Lcom/github/quiltservertools/libs/com/fasterxml/jackson/core/JsonParser;", "p", "Lcom/github/quiltservertools/libs/com/fasterxml/jackson/databind/DeserializationContext;", "ctxt", "deserialize", "(Lcom/github/quiltservertools/libs/com/fasterxml/jackson/core/JsonParser;Lcom/github/quiltservertools/libs/com/fasterxml/jackson/databind/DeserializationContext;)Lkotlin/text/Regex;", "jackson-module-kotlin"})
public final class RegexDeserializer
extends StdDeserializer<Regex> {
    @NotNull
    public static final RegexDeserializer INSTANCE;

    @Override
    @NotNull
    public Regex deserialize(@NotNull JsonParser p, @NotNull DeserializationContext ctxt) {
        JsonNode node;
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)ctxt, (String)"ctxt");
        JsonNode jsonNode = node = ctxt.readTree(p);
        Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"node");
        if (jsonNode.isTextual()) {
            String string = node.asText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.asText()");
            return new Regex(string);
        }
        if (node.isObject()) {
            Set set;
            String pattern = node.get("pattern").asText();
            if (node.has("options")) {
                JsonNode optionsNode;
                JsonNode jsonNode2 = optionsNode = node.get("options");
                Intrinsics.checkNotNullExpressionValue((Object)jsonNode2, (String)"optionsNode");
                if (!jsonNode2.isArray()) {
                    throw (Throwable)new IllegalStateException("Expected an array of strings for RegexOptions, but type was " + (Object)((Object)node.getNodeType()));
                }
                Iterator<JsonNode> iterator2 = optionsNode.elements();
                Intrinsics.checkNotNullExpressionValue(iterator2, (String)"optionsNode.elements()");
                set = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.asSequence(iterator2), (Function1)deserialize.options.1.INSTANCE));
            } else {
                set = SetsKt.emptySet();
            }
            Set options2 = set;
            String string = pattern;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pattern");
            return new Regex(string, options2);
        }
        throw (Throwable)new IllegalStateException("Expected a string or an object to deserialize a Regex, but type was " + (Object)((Object)node.getNodeType()));
    }

    private RegexDeserializer() {
        super(Regex.class);
    }

    static {
        RegexDeserializer regexDeserializer;
        INSTANCE = regexDeserializer = new RegexDeserializer();
    }
}

