/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.exceptions;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.AbstractQuery;
import org.jetbrains.exposed.sql.QueryBuilder;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.Statement;
import org.jetbrains.exposed.sql.statements.StatementContext;
import org.jetbrains.exposed.sql.statements.StatementKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\t\u0018\u00002\u00020\u0001B'\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0013\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0004\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000e\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0013\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0013\u0010\u000fR\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0014\u001a\u0004\b\u0015\u0010\rR\u0014\u0010\b\u001a\u00020\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0016R\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u00018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/exposed/exceptions/ExposedSQLException;", "Ljava/sql/SQLException;", "", "cause", "", "Lorg/jetbrains/exposed/sql/statements/StatementContext;", "contexts", "Lorg/jetbrains/exposed/sql/Transaction;", "transaction", "<init>", "(Ljava/lang/Throwable;Ljava/util/List;Lorg/jetbrains/exposed/sql/Transaction;)V", "", "causedByQueries", "()Ljava/util/List;", "getSQLState", "()Ljava/lang/String;", "", "getErrorCode", "()I", "toString", "Ljava/util/List;", "getContexts", "Lorg/jetbrains/exposed/sql/Transaction;", "originalSQLException", "Ljava/sql/SQLException;", "exposed-core"})
@SourceDebugExtension(value={"SMAP\nExceptions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Exceptions.kt\norg/jetbrains/exposed/exceptions/ExposedSQLException\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,80:1\n1557#2:81\n1628#2,3:82\n*S KotlinDebug\n*F\n+ 1 Exceptions.kt\norg/jetbrains/exposed/exceptions/ExposedSQLException\n*L\n22#1:81\n22#1:82,3\n*E\n"})
public final class ExposedSQLException
extends SQLException {
    @NotNull
    private final List<StatementContext> contexts;
    @NotNull
    private final Transaction transaction;
    @Nullable
    private final SQLException originalSQLException;

    public ExposedSQLException(@Nullable Throwable cause, @NotNull List<StatementContext> contexts, @NotNull Transaction transaction) {
        Intrinsics.checkNotNullParameter(contexts, (String)"contexts");
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        super(cause);
        this.contexts = contexts;
        this.transaction = transaction;
        this.originalSQLException = cause instanceof SQLException ? (SQLException)cause : null;
    }

    @NotNull
    public final List<StatementContext> getContexts() {
        return this.contexts;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> causedByQueries() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.contexts;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string;
            void it;
            StatementContext statementContext = (StatementContext)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            try {
                string = this.transaction.getDebug() ? StatementKt.expandArgs((StatementContext)it, this.transaction) : it.sql(this.transaction);
            }
            catch (Throwable throwable) {
                String string2;
                String string3;
                try {
                    Statement<?> statement = it.getStatement();
                    AbstractQuery abstractQuery = statement instanceof AbstractQuery ? (AbstractQuery)statement : null;
                    string3 = abstractQuery != null ? abstractQuery.prepareSQL(new QueryBuilder(!this.transaction.getDebug())) : null;
                }
                catch (Throwable throwable2) {
                    string3 = null;
                }
                if ((string2 = string3) == null) {
                    string2 = "Failed on expanding args for " + (Object)((Object)it.getStatement().getType()) + ": " + it.getStatement();
                }
                string = string2;
            }
            collection.add(string);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public String getSQLState() {
        SQLException sQLException = this.originalSQLException;
        String string = sQLException != null ? sQLException.getSQLState() : null;
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Override
    public int getErrorCode() {
        SQLException sQLException = this.originalSQLException;
        return sQLException != null ? sQLException.getErrorCode() : 0;
    }

    @Override
    @NotNull
    public String toString() {
        return super.toString() + "\nSQL: " + this.causedByQueries();
    }
}

