/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.exceptions.ExceptionsKt;
import org.jetbrains.exposed.sql.ColumnDiff;
import org.jetbrains.exposed.sql.ColumnKt;
import org.jetbrains.exposed.sql.ColumnType;
import org.jetbrains.exposed.sql.ColumnTypeKt;
import org.jetbrains.exposed.sql.DdlAware;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ExpressionWithColumnType;
import org.jetbrains.exposed.sql.ForeignKeyConstraint;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.QueryBuilder;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.H2Dialect;
import org.jetbrains.exposed.sql.vendors.MysqlDialect;
import org.jetbrains.exposed.sql.vendors.OracleDialect;
import org.jetbrains.exposed.sql.vendors.SQLServerDialect;
import org.jetbrains.exposed.sql.vendors.SQLiteDialect;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010!\n\u0002\b\t\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u00028\u00000\u00022\u00020\u00032\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00000\u0004B*\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u000e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\b\u00028\u00000\t\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001f\u0010\u000e\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0000\"\b\b\u0001\u0010\r*\u00028\u0000\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0011\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\r\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\r\u0010\u001b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\r\u0010\u001d\u001a\u00020\u0007\u00a2\u0006\u0004\b\u001d\u0010\u001cJ\u0015\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00070\u001eH\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u001b\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00070\u001e2\u0006\u0010\"\u001a\u00020!\u00a2\u0006\u0004\b#\u0010$J\u0015\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00070\u001eH\u0016\u00a2\u0006\u0004\b%\u0010 J\u0015\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00070\u001eH\u0016\u00a2\u0006\u0004\b&\u0010 J\u000f\u0010(\u001a\u00020\u0013H\u0000\u00a2\u0006\u0004\b'\u0010\u0015J\u0017\u0010*\u001a\u00020\u00072\b\b\u0002\u0010)\u001a\u00020\u0013\u00a2\u0006\u0004\b*\u0010+JQ\u00103\u001a\b\u0012\u0004\u0012\u00028\u00010\u0000\"\u0004\b\u0001\u0010,2\u000e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\b\u00028\u00010-2!\b\u0002\u00100\u001a\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u0000\u0012\u0004\u0012\u00020\u0018\u0018\u00010.\u00a2\u0006\u0002\b/H\u0000\u00f8\u0001\u0000\u00a2\u0006\u0004\b1\u00102J&\u00104\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\b\u00028\u00000\t\u00f8\u0001\u0000\u00a2\u0006\u0004\b4\u00105J\u001c\u00108\u001a\u0002072\n\u00106\u001a\u0006\u0012\u0002\b\u00030\u0000H\u0096\u0002\u00a2\u0006\u0004\b8\u00109J\u001a\u0010;\u001a\u00020\u00132\b\u00106\u001a\u0004\u0018\u00010:H\u0096\u0002\u00a2\u0006\u0004\b;\u0010<J\u000f\u0010=\u001a\u000207H\u0016\u00a2\u0006\u0004\b=\u0010>J\u000f\u0010?\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b?\u0010\u001cR\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010@\u001a\u0004\bA\u0010BR\u0017\u0010\b\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\b\u0010C\u001a\u0004\bD\u0010\u001cR%\u0010\n\u001a\n\u0012\u0006\u0012\u0004\b\u00028\u00000\t8\u0016X\u0096\u0004\u00f8\u0001\u0000\u00a2\u0006\f\n\u0004\b\n\u0010E\u001a\u0004\bF\u0010GR$\u0010I\u001a\u0004\u0018\u00010H8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bI\u0010J\u001a\u0004\bK\u0010L\"\u0004\bM\u0010NR\u0017\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00008F\u00a2\u0006\u0006\u001a\u0004\bO\u0010\u000fR*\u0010Q\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010P8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bQ\u0010R\u001a\u0004\bS\u0010T\"\u0004\bU\u0010VR*\u0010W\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00108\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\bW\u0010X\u001a\u0004\bY\u0010\u0012\"\u0004\bZ\u0010[R\"\u0010\u0014\u001a\u00020\u00138\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b\u0014\u0010\\\u001a\u0004\b]\u0010\u0015\"\u0004\b^\u0010_R(\u0010a\u001a\b\u0012\u0004\u0012\u00020:0`8\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\ba\u0010b\u001a\u0004\bc\u0010 \"\u0004\bd\u0010eR\u0014\u0010f\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bf\u0010\u0015R\u0014\u0010h\u001a\u00020\u00138@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\bg\u0010\u0015\u0082\u0002\u0004\n\u0002\b9\u00a8\u0006i"}, d2={"Lorg/jetbrains/exposed/sql/Column;", "T", "Lorg/jetbrains/exposed/sql/ExpressionWithColumnType;", "Lorg/jetbrains/exposed/sql/DdlAware;", "", "Lorg/jetbrains/exposed/sql/Table;", "table", "", "name", "Lorg/jetbrains/exposed/sql/IColumnType;", "columnType", "<init>", "(Lorg/jetbrains/exposed/sql/Table;Ljava/lang/String;Lorg/jetbrains/exposed/sql/IColumnType;)V", "S", "referee", "()Lorg/jetbrains/exposed/sql/Column;", "Lorg/jetbrains/exposed/sql/Expression;", "defaultValueInDb", "()Lorg/jetbrains/exposed/sql/Expression;", "", "isDatabaseGenerated", "()Z", "Lorg/jetbrains/exposed/sql/QueryBuilder;", "queryBuilder", "", "toQueryBuilder", "(Lorg/jetbrains/exposed/sql/QueryBuilder;)V", "nameInDatabaseCase", "()Ljava/lang/String;", "nameUnquoted", "", "createStatement", "()Ljava/util/List;", "Lorg/jetbrains/exposed/sql/ColumnDiff;", "columnDiff", "modifyStatements", "(Lorg/jetbrains/exposed/sql/ColumnDiff;)Ljava/util/List;", "modifyStatement", "dropStatement", "isOneColumnPK$exposed_core", "isOneColumnPK", "modify", "descriptionDdl", "(Z)Ljava/lang/String;", "R", "Lorg/jetbrains/exposed/sql/ColumnType;", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "body", "copyWithAnotherColumnType$exposed_core", "(Lorg/jetbrains/exposed/sql/ColumnType;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/exposed/sql/Column;", "copyWithAnotherColumnType", "withColumnType", "(Lorg/jetbrains/exposed/sql/IColumnType;)Lorg/jetbrains/exposed/sql/Column;", "other", "", "compareTo", "(Lorg/jetbrains/exposed/sql/Column;)I", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "toString", "Lorg/jetbrains/exposed/sql/Table;", "getTable", "()Lorg/jetbrains/exposed/sql/Table;", "Ljava/lang/String;", "getName", "Lorg/jetbrains/exposed/sql/IColumnType;", "getColumnType", "()Lorg/jetbrains/exposed/sql/IColumnType;", "Lorg/jetbrains/exposed/sql/ForeignKeyConstraint;", "foreignKey", "Lorg/jetbrains/exposed/sql/ForeignKeyConstraint;", "getForeignKey", "()Lorg/jetbrains/exposed/sql/ForeignKeyConstraint;", "setForeignKey", "(Lorg/jetbrains/exposed/sql/ForeignKeyConstraint;)V", "getReferee", "Lkotlin/Function0;", "defaultValueFun", "Lkotlin/jvm/functions/Function0;", "getDefaultValueFun", "()Lkotlin/jvm/functions/Function0;", "setDefaultValueFun", "(Lkotlin/jvm/functions/Function0;)V", "dbDefaultValue", "Lorg/jetbrains/exposed/sql/Expression;", "getDbDefaultValue$exposed_core", "setDbDefaultValue$exposed_core", "(Lorg/jetbrains/exposed/sql/Expression;)V", "Z", "isDatabaseGenerated$exposed_core", "setDatabaseGenerated$exposed_core", "(Z)V", "", "extraDefinitions", "Ljava/util/List;", "getExtraDefinitions$exposed_core", "setExtraDefinitions$exposed_core", "(Ljava/util/List;)V", "isLastColumnInPK", "isPrimaryConstraintWillBeDefined$exposed_core", "isPrimaryConstraintWillBeDefined", "exposed-core"})
@SourceDebugExtension(value={"SMAP\nColumn.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Column.kt\norg/jetbrains/exposed/sql/Column\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,208:1\n1#2:209\n*E\n"})
public final class Column<T>
extends ExpressionWithColumnType<T>
implements DdlAware,
Comparable<Column<?>> {
    @NotNull
    private final Table table;
    @NotNull
    private final String name;
    @NotNull
    private final IColumnType<T> columnType;
    @Nullable
    private ForeignKeyConstraint foreignKey;
    @Nullable
    private Function0<? extends T> defaultValueFun;
    @Nullable
    private Expression<T> dbDefaultValue;
    private boolean isDatabaseGenerated;
    @NotNull
    private List<Object> extraDefinitions;

    public Column(@NotNull Table table, @NotNull String name, @NotNull IColumnType<T> columnType) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(columnType, (String)"columnType");
        this.table = table;
        this.name = name;
        this.columnType = columnType;
        this.extraDefinitions = new ArrayList();
    }

    @NotNull
    public final Table getTable() {
        return this.table;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public IColumnType<T> getColumnType() {
        return this.columnType;
    }

    @Nullable
    public final ForeignKeyConstraint getForeignKey() {
        return this.foreignKey;
    }

    public final void setForeignKey(@Nullable ForeignKeyConstraint foreignKeyConstraint) {
        this.foreignKey = foreignKeyConstraint;
    }

    @Nullable
    public final Column<?> getReferee() {
        ForeignKeyConstraint foreignKeyConstraint = this.foreignKey;
        return foreignKeyConstraint != null ? foreignKeyConstraint.targetOf(this) : null;
    }

    @Nullable
    public final <S extends T> Column<S> referee() {
        Column<?> column = this.getReferee();
        return column instanceof Column ? column : null;
    }

    @Nullable
    public final Function0<T> getDefaultValueFun() {
        return this.defaultValueFun;
    }

    public final void setDefaultValueFun(@Nullable Function0<? extends T> function0) {
        this.defaultValueFun = function0;
    }

    @Nullable
    public final Expression<T> getDbDefaultValue$exposed_core() {
        return this.dbDefaultValue;
    }

    public final void setDbDefaultValue$exposed_core(@Nullable Expression<T> expression) {
        this.dbDefaultValue = expression;
    }

    @Nullable
    public final Expression<T> defaultValueInDb() {
        return this.dbDefaultValue;
    }

    public final boolean isDatabaseGenerated$exposed_core() {
        return this.isDatabaseGenerated;
    }

    public final void setDatabaseGenerated$exposed_core(boolean bl) {
        this.isDatabaseGenerated = bl;
    }

    public final boolean isDatabaseGenerated() {
        return this.isDatabaseGenerated;
    }

    @NotNull
    public final List<Object> getExtraDefinitions$exposed_core() {
        return this.extraDefinitions;
    }

    public final void setExtraDefinitions$exposed_core(@NotNull List<Object> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        this.extraDefinitions = list2;
    }

    @Override
    public void toQueryBuilder(@NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"queryBuilder");
        TransactionManager.Companion.current().fullIdentity$exposed_core(this, queryBuilder);
    }

    @NotNull
    public final String nameInDatabaseCase() {
        return DatabaseDialectKt.inProperCase(this.name);
    }

    @NotNull
    public final String nameUnquoted() {
        String string;
        if (DatabaseDialectKt.getCurrentDialect() instanceof MysqlDialect) {
            string = this.name;
        } else {
            char[] cArray = new char[]{'\"'};
            string = StringsKt.trim((String)this.name, (char[])cArray);
        }
        return string;
    }

    private final boolean isLastColumnInPK() {
        Object[] objectArray = this.table.getPrimaryKey();
        return Intrinsics.areEqual((Object)this, objectArray != null && (objectArray = objectArray.getColumns()) != null ? (Column)ArraysKt.last((Object[])objectArray) : null);
    }

    public final boolean isPrimaryConstraintWillBeDefined$exposed_core() {
        return DatabaseDialectKt.getCurrentDialect() instanceof SQLiteDialect && ColumnTypeKt.isAutoInc(this.getColumnType()) ? false : (this.table.isCustomPKNameDefined$exposed_core() ? this.isLastColumnInPK() : (this.isOneColumnPK$exposed_core() ? false : this.isLastColumnInPK()));
    }

    @Override
    @NotNull
    public List<String> createStatement() {
        String alterTablePrefix = "ALTER TABLE " + TransactionManager.Companion.current().identity(this.table) + " ADD";
        boolean isH2withCustomPKConstraint = DatabaseDialectKt.getCurrentDialect() instanceof H2Dialect && this.isLastColumnInPK();
        boolean isOracle = DatabaseDialectKt.getCurrentDialect() instanceof OracleDialect;
        String columnDefinition = this.isPrimaryConstraintWillBeDefined$exposed_core() && this.isLastColumnInPK() && !isH2withCustomPKConstraint && !isOracle ? this.descriptionDdl(false) + ", ADD " + this.table.primaryKeyConstraint$exposed_core() : (isH2withCustomPKConstraint ? this.descriptionDdl(true) : this.descriptionDdl(false));
        String addConstr = isH2withCustomPKConstraint || isOracle && this.isPrimaryConstraintWillBeDefined$exposed_core() ? alterTablePrefix + ' ' + this.table.primaryKeyConstraint$exposed_core() : null;
        Object[] objectArray = new String[]{alterTablePrefix + ' ' + columnDefinition, addConstr};
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    @NotNull
    public final List<String> modifyStatements(@NotNull ColumnDiff columnDiff) {
        Intrinsics.checkNotNullParameter((Object)columnDiff, (String)"columnDiff");
        return DatabaseDialectKt.getCurrentDialect().modifyColumn(this, columnDiff);
    }

    @Override
    @NotNull
    public List<String> modifyStatement() {
        return DatabaseDialectKt.getCurrentDialect().modifyColumn(this, ColumnDiff.Companion.getAllChanged());
    }

    @Override
    @NotNull
    public List<String> dropStatement() {
        Transaction tr = TransactionManager.Companion.current();
        return CollectionsKt.listOf((Object)("ALTER TABLE " + tr.identity(this.table) + " DROP COLUMN " + tr.identity(this)));
    }

    public final boolean isOneColumnPK$exposed_core() {
        Object[] objectArray = this.table.getPrimaryKey();
        return Intrinsics.areEqual((Object)this, objectArray != null && (objectArray = objectArray.getColumns()) != null ? (Column)ArraysKt.singleOrNull((Object[])objectArray) : null);
    }

    @NotNull
    public final String descriptionDdl(boolean modify) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2;
        StringBuilder $this$descriptionDdl_u24lambda_u241 = stringBuilder2 = new StringBuilder();
        boolean bl = false;
        Transaction tr = TransactionManager.Companion.current();
        Column column = this;
        $this$descriptionDdl_u24lambda_u241.append(tr.identity(column));
        $this$descriptionDdl_u24lambda_u241.append(" ");
        Object[] objectArray = this.table.getPrimaryKey();
        boolean isPKColumn = objectArray != null && (objectArray = objectArray.getColumns()) != null ? ArraysKt.contains((Object[])objectArray, (Object)column) : false;
        boolean isSQLiteAutoIncColumn = DatabaseDialectKt.getCurrentDialect() instanceof SQLiteDialect && ColumnTypeKt.isAutoInc(this.getColumnType());
        if (!isPKColumn && isSQLiteAutoIncColumn) {
            ExceptionsKt.throwUnsupportedException(tr, "Auto-increment could be applied only to primary key column");
            throw new KotlinNothingValueException();
        }
        if (isSQLiteAutoIncColumn && !this.isOneColumnPK$exposed_core()) {
            ExceptionsKt.throwUnsupportedException(tr, "Auto-increment could be applied only to a single column primary key");
            throw new KotlinNothingValueException();
        }
        if (isSQLiteAutoIncColumn && this.table.isCustomPKNameDefined$exposed_core()) {
            String rawType = StringsKt.substringBefore$default((String)this.getColumnType().sqlType(), (String)"PRIMARY KEY", null, (int)2, null);
            String string = this.table.primaryKeyConstraint$exposed_core();
            Intrinsics.checkNotNull((Object)string);
            String constraintPart = StringsKt.substringBefore$default((String)string, (String)"(", null, (int)2, null);
            stringBuilder = $this$descriptionDdl_u24lambda_u241.append(rawType + ' ' + constraintPart + " AUTOINCREMENT");
        } else {
            stringBuilder = $this$descriptionDdl_u24lambda_u241.append(this.getColumnType().sqlType());
        }
        Expression<T> defaultValue = this.dbDefaultValue;
        if (defaultValue != null) {
            StringBuilder stringBuilder3;
            String expressionSQL = DatabaseDialectKt.getCurrentDialect().getDataTypeProvider().processForDefaultValue(defaultValue);
            if (!DatabaseDialectKt.getCurrentDialect().isAllowedAsColumnDefault(defaultValue)) {
                String clientDefault = this.defaultValueFun != null && this.dbDefaultValue == null ? " Expression will be evaluated on the client." : (!this.getColumnType().getNullable() ? " Column will be created with NULL marker." : "");
                SQLLogKt.getExposedLogger().error(DatabaseDialectKt.getCurrentDialect().getName() + ' ' + tr.getDb().getVersion() + " doesn't support expression '" + expressionSQL + "' as default value." + clientDefault);
                stringBuilder3 = Unit.INSTANCE;
            } else if (DatabaseDialectKt.getCurrentDialect() instanceof SQLServerDialect) {
                String tableName = column.table.getTableNameWithoutScheme$exposed_core();
                String columnName = column.name;
                String constraintName = "DF_" + tableName + '_' + columnName;
                stringBuilder3 = $this$descriptionDdl_u24lambda_u241.append(" CONSTRAINT " + constraintName + " DEFAULT " + expressionSQL);
            } else {
                stringBuilder3 = $this$descriptionDdl_u24lambda_u241.append(" DEFAULT " + expressionSQL);
            }
        }
        if (!((Collection)this.extraDefinitions).isEmpty()) {
            $this$descriptionDdl_u24lambda_u241.append(CollectionsKt.joinToString$default((Iterable)this.extraDefinitions, (CharSequence)" ", (CharSequence)" ", null, (int)0, null, Column::descriptionDdl$lambda$1$lambda$0, (int)28, null));
        }
        if (this.getColumnType().getNullable() || defaultValue != null && this.defaultValueFun == null && !DatabaseDialectKt.getCurrentDialect().isAllowedAsColumnDefault(defaultValue)) {
            $this$descriptionDdl_u24lambda_u241.append(" NULL");
        } else if (!isPKColumn || DatabaseDialectKt.getCurrentDialect() instanceof SQLiteDialect && !isSQLiteAutoIncColumn) {
            $this$descriptionDdl_u24lambda_u241.append(" NOT NULL");
        }
        if (!modify && this.isOneColumnPK$exposed_core() && !this.isPrimaryConstraintWillBeDefined$exposed_core() && !isSQLiteAutoIncColumn) {
            $this$descriptionDdl_u24lambda_u241.append(" PRIMARY KEY");
        }
        return stringBuilder2.toString();
    }

    public static /* synthetic */ String descriptionDdl$default(Column column, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return column.descriptionDdl(bl);
    }

    @NotNull
    public final <R> Column<R> copyWithAnotherColumnType$exposed_core(@NotNull ColumnType<R> columnType, @Nullable Function1<? super Column<R>, Unit> body) {
        Intrinsics.checkNotNullParameter(columnType, (String)"columnType");
        Column<T> newColumn = new Column<T>(this.table, this.name, columnType);
        newColumn.foreignKey = this.foreignKey;
        newColumn.dbDefaultValue = this.dbDefaultValue;
        newColumn.isDatabaseGenerated = this.isDatabaseGenerated;
        newColumn.extraDefinitions = this.extraDefinitions;
        Function1<? super Column<R>, Unit> function1 = body;
        if (function1 != null) {
            Function1<? super Column<R>, Unit> it = function1;
            boolean bl = false;
            it.invoke(newColumn);
        }
        if (this.defaultValueFun != null && !(newColumn.defaultValueFun != null)) {
            boolean bl = false;
            String string = "defaultValueFun was lost on cloning the column";
            throw new IllegalArgumentException(string.toString());
        }
        return newColumn;
    }

    public static /* synthetic */ Column copyWithAnotherColumnType$exposed_core$default(Column column, ColumnType columnType, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = null;
        }
        return column.copyWithAnotherColumnType$exposed_core(columnType, function1);
    }

    @NotNull
    public final Column<T> withColumnType(@NotNull IColumnType<T> columnType) {
        Column<T> column;
        Intrinsics.checkNotNullParameter(columnType, (String)"columnType");
        Column<T> it = column = new Column<T>(this.table, this.name, columnType);
        boolean bl = false;
        it.foreignKey = this.foreignKey;
        it.defaultValueFun = this.defaultValueFun;
        it.dbDefaultValue = this.dbDefaultValue;
        it.isDatabaseGenerated = this.isDatabaseGenerated;
        it.extraDefinitions = this.extraDefinitions;
        return column;
    }

    @Override
    public int compareTo(@NotNull Column<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return ColumnKt.access$getComparator$p().compare(this, other);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Column)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.table, (Object)((Column)other).table)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.name, (Object)((Column)other).name);
    }

    @Override
    public int hashCode() {
        return this.table.hashCode() * 31 + this.name.hashCode();
    }

    @Override
    @NotNull
    public String toString() {
        return this.table.getClass().getName() + '.' + this.name;
    }

    @Override
    @NotNull
    public List<String> getDdl() {
        return DdlAware.DefaultImpls.getDdl(this);
    }

    private static final CharSequence descriptionDdl$lambda$1$lambda$0(Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return String.valueOf(it);
    }
}

