/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.ColumnType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001dB\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ!\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001a\u0010\u0016\u001a\u00020\u00152\b\u0010\u0014\u001a\u0004\u0018\u00010\u000eH\u0096\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0018\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u001a\u001a\u0004\b\u001b\u0010\u0019R\u0017\u0010\u0005\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001a\u001a\u0004\b\u001c\u0010\u0019\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/exposed/sql/DecimalColumnType;", "Lorg/jetbrains/exposed/sql/ColumnType;", "Ljava/math/BigDecimal;", "", "precision", "scale", "<init>", "(II)V", "", "sqlType", "()Ljava/lang/String;", "Ljava/sql/ResultSet;", "rs", "index", "", "readObject", "(Ljava/sql/ResultSet;I)Ljava/lang/Object;", "value", "valueFromDB", "(Ljava/lang/Object;)Ljava/math/BigDecimal;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "I", "getPrecision", "getScale", "Companion", "exposed-core"})
public final class DecimalColumnType
extends ColumnType<BigDecimal> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int precision;
    private final int scale;
    @NotNull
    private static final DecimalColumnType INSTANCE = new DecimalColumnType(MathContext.DECIMAL64.getPrecision(), 20);

    public DecimalColumnType(int precision, int scale) {
        super(false, 1, null);
        this.precision = precision;
        this.scale = scale;
    }

    public final int getPrecision() {
        return this.precision;
    }

    public final int getScale() {
        return this.scale;
    }

    @Override
    @NotNull
    public String sqlType() {
        return "DECIMAL(" + this.precision + ", " + this.scale + ')';
    }

    @Override
    @Nullable
    public Object readObject(@NotNull ResultSet rs, int index) {
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        return rs.getObject(index);
    }

    @Override
    @NotNull
    public BigDecimal valueFromDB(@NotNull Object value2) {
        BigDecimal bigDecimal;
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Object object = value2;
        if (object instanceof BigDecimal) {
            bigDecimal = (BigDecimal)value2;
        } else if (object instanceof Double) {
            if (Double.isNaN(((Number)value2).doubleValue())) {
                throw new SQLException("Unexpected value of type Double: NaN of " + Reflection.getOrCreateKotlinClass(value2.getClass()).getQualifiedName());
            }
            bigDecimal = new BigDecimal(String.valueOf(((Number)value2).doubleValue()));
        } else if (object instanceof Float) {
            if (Float.isNaN(((Number)value2).floatValue())) {
                throw new IllegalStateException(("Unexpected value of type Float: NaN of " + Reflection.getOrCreateKotlinClass(value2.getClass()).getQualifiedName()).toString());
            }
            bigDecimal = new BigDecimal(String.valueOf(((Number)value2).floatValue()));
        } else if (object instanceof Long) {
            BigDecimal bigDecimal2 = BigDecimal.valueOf(((Number)value2).longValue());
            bigDecimal = bigDecimal2;
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"valueOf(...)");
        } else if (object instanceof Integer) {
            BigDecimal bigDecimal3 = BigDecimal.valueOf(((Number)value2).intValue());
            bigDecimal = bigDecimal3;
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal3, (String)"valueOf(...)");
        } else if (object instanceof Short) {
            BigDecimal bigDecimal4 = BigDecimal.valueOf(((Number)value2).shortValue());
            bigDecimal = bigDecimal4;
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal4, (String)"valueOf(...)");
        } else {
            throw new IllegalStateException(("Unexpected value of type Decimal: " + value2 + " of " + Reflection.getOrCreateKotlinClass(value2.getClass()).getQualifiedName()).toString());
        }
        BigDecimal bigDecimal5 = bigDecimal.setScale(this.scale, RoundingMode.HALF_EVEN);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal5, (String)"setScale(...)");
        return bigDecimal5;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type org.jetbrains.exposed.sql.DecimalColumnType");
        DecimalColumnType cfr_ignored_0 = (DecimalColumnType)other;
        if (this.precision != ((DecimalColumnType)other).precision) {
            return false;
        }
        return this.scale == ((DecimalColumnType)other).scale;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.precision;
        result = 31 * result + this.scale;
        return result;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0005\u001a\u00020\u00048\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/exposed/sql/DecimalColumnType$Companion;", "", "<init>", "()V", "Lorg/jetbrains/exposed/sql/DecimalColumnType;", "INSTANCE", "Lorg/jetbrains/exposed/sql/DecimalColumnType;", "getINSTANCE$exposed_core", "()Lorg/jetbrains/exposed/sql/DecimalColumnType;", "exposed-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DecimalColumnType getINSTANCE$exposed_core() {
            return INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

