/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.ColumnType;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010$\n\u0002\b\b\u0018\u0000 ,*\u000e\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u00028\u00000\u00012\b\u0012\u0004\u0012\u00028\u00000\u0003:\u0001,B\u001d\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0019\u0010\u0016\u001a\u00020\u00152\b\u0010\u000e\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001a\u0010\u001a\u001a\u00020\u00192\b\u0010\u0018\u001a\u0004\u0018\u00010\rH\u0096\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u000f\u0010\u001c\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0017\u0010\u001e\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fR\u001d\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010 \u001a\u0004\b!\u0010\"R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010#\u001a\u0004\b$\u0010\u001dR/\u0010+\u001a\u0016\u0012\u0004\u0012\u00020\n\u0012\f\u0012\n &*\u0004\u0018\u00018\u00008\u00000%8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010(\u001a\u0004\b)\u0010*\u00a8\u0006-"}, d2={"Lorg/jetbrains/exposed/sql/EnumerationNameColumnType;", "", "T", "Lorg/jetbrains/exposed/sql/ColumnType;", "Lkotlin/reflect/KClass;", "klass", "", "colLength", "<init>", "(Lkotlin/reflect/KClass;I)V", "", "sqlType", "()Ljava/lang/String;", "", "value", "valueFromDB", "(Ljava/lang/Object;)Ljava/lang/Enum;", "notNullValueToDB", "(Ljava/lang/Enum;)Ljava/lang/Object;", "nonNullValueToString", "(Ljava/lang/Enum;)Ljava/lang/String;", "", "validateValueBeforeUpdate", "(Ljava/lang/Enum;)V", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "escape", "(Ljava/lang/String;)Ljava/lang/String;", "Lkotlin/reflect/KClass;", "getKlass", "()Lkotlin/reflect/KClass;", "I", "getColLength", "", "kotlin.jvm.PlatformType", "enumConstants$delegate", "Lkotlin/Lazy;", "getEnumConstants", "()Ljava/util/Map;", "enumConstants", "Companion", "exposed-core"})
@SourceDebugExtension(value={"SMAP\nColumnType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColumnType.kt\norg/jetbrains/exposed/sql/EnumerationNameColumnType\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,1411:1\n975#2:1412\n1046#2,3:1413\n8634#3,2:1416\n8894#3,4:1418\n*S KotlinDebug\n*F\n+ 1 ColumnType.kt\norg/jetbrains/exposed/sql/EnumerationNameColumnType\n*L\n1193#1:1412\n1193#1:1413,3\n1146#1:1416,2\n1146#1:1418,4\n*E\n"})
public final class EnumerationNameColumnType<T extends Enum<T>>
extends ColumnType<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KClass<T> klass;
    private final int colLength;
    @NotNull
    private final Lazy enumConstants$delegate;
    @NotNull
    private static final Map<Character, String> charactersToEscape;

    public EnumerationNameColumnType(@NotNull KClass<T> klass, int colLength) {
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        super(false, 1, null);
        this.klass = klass;
        this.colLength = colLength;
        this.enumConstants$delegate = LazyKt.lazy(() -> EnumerationNameColumnType.enumConstants_delegate$lambda$1(this));
    }

    @NotNull
    public final KClass<T> getKlass() {
        return this.klass;
    }

    public final int getColLength() {
        return this.colLength;
    }

    private final Map<String, T> getEnumConstants() {
        Lazy lazy2 = this.enumConstants$delegate;
        return (Map)lazy2.getValue();
    }

    @Override
    @NotNull
    public String sqlType() {
        return DatabaseDialectKt.getCurrentDialect().getDataTypeProvider().varcharType(this.colLength);
    }

    @Override
    @NotNull
    public T valueFromDB(@NotNull Object value2) {
        Enum enum_;
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Object object = value2;
        if (object instanceof String) {
            enum_ = (Enum)this.getEnumConstants().get(value2);
            if (enum_ == null) {
                throw new IllegalStateException(((String)value2 + " can't be associated with any from enum " + this.klass.getQualifiedName()).toString());
            }
        } else if (object instanceof Enum) {
            enum_ = (Enum)value2;
        } else {
            throw new IllegalStateException((value2 + " of " + Reflection.getOrCreateKotlinClass(value2.getClass()).getQualifiedName() + " is not valid for enum " + this.klass.getQualifiedName()).toString());
        }
        return (T)enum_;
    }

    @Override
    @NotNull
    public Object notNullValueToDB(@NotNull T value2) {
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        return ((Enum)value2).name();
    }

    @Override
    @NotNull
    public String nonNullValueToString(@NotNull T value2) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        StringBuilder $this$nonNullValueToString_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$nonNullValueToString_u24lambda_u242.append('\'');
        $this$nonNullValueToString_u24lambda_u242.append(this.escape(((Enum)value2).name()));
        $this$nonNullValueToString_u24lambda_u242.append('\'');
        return stringBuilder.toString();
    }

    @Override
    public void validateValueBeforeUpdate(@Nullable T value2) {
        int valueLength;
        if (value2 != null && !((valueLength = ((Enum)value2).name().codePointCount(0, ((Enum)value2).name().length())) <= this.colLength)) {
            boolean bl = false;
            String string = "Value can't be stored to database column because exceeds length (" + valueLength + " > " + this.colLength + ')';
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type org.jetbrains.exposed.sql.EnumerationNameColumnType<*>");
        EnumerationNameColumnType cfr_ignored_0 = (EnumerationNameColumnType)other;
        return Intrinsics.areEqual(this.klass, ((EnumerationNameColumnType)other).klass);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.klass.hashCode();
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final String escape(String value2) {
        void $this$mapTo$iv$iv;
        CharSequence $this$map$iv = value2;
        boolean $i$f$map = false;
        CharSequence charSequence = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length());
        boolean $i$f$mapTo = false;
        for (int i = 0; i < $this$mapTo$iv$iv.length(); ++i) {
            void it;
            char item$iv$iv;
            char c = item$iv$iv = $this$mapTo$iv$iv.charAt(i);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object object = charactersToEscape.get(Character.valueOf((char)it));
            if (object == null) {
                object = Character.valueOf((char)it);
            }
            collection.add(object);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final Map enumConstants_delegate$lambda$1(EnumerationNameColumnType this$0) {
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        T[] TArray = JvmClassMappingKt.getJavaClass(this$0.klass).getEnumConstants();
        Intrinsics.checkNotNull(TArray);
        T[] $this$associateBy$iv = TArray;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associateBy$iv.length), (int)16);
        T[] TArray2 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (void element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            Enum enum_ = (Enum)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            map2.put(it.name(), element$iv$iv);
        }
        return destination$iv$iv;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Character.valueOf('\''), (Object)"''"), TuplesKt.to((Object)Character.valueOf('\r'), (Object)"\\r"), TuplesKt.to((Object)Character.valueOf('\n'), (Object)"\\n")};
        charactersToEscape = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\f\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R \u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/exposed/sql/EnumerationNameColumnType$Companion;", "", "<init>", "()V", "", "", "", "charactersToEscape", "Ljava/util/Map;", "exposed-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

