/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\f\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\b\u0086\b\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\t\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0000H\u0086\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010\t\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0002H\u0086\u0006\u00a2\u0006\u0004\b\t\u0010\u000bJ\u0010\u0010\f\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ&\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u00c6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001a\u0010\u0014\u001a\u00020\u00132\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0010\u0010\u0017\u001a\u00020\u0016H\u00d6\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0019\u0010\rR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001a\u001a\u0004\b\u001b\u0010\rR\u0019\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001c\u001a\u0004\b\u001d\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/exposed/sql/LikePattern;", "", "", "pattern", "", "escapeChar", "<init>", "(Ljava/lang/String;Ljava/lang/Character;)V", "rhs", "plus", "(Lorg/jetbrains/exposed/sql/LikePattern;)Lorg/jetbrains/exposed/sql/LikePattern;", "(Ljava/lang/String;)Lorg/jetbrains/exposed/sql/LikePattern;", "component1", "()Ljava/lang/String;", "component2", "()Ljava/lang/Character;", "copy", "(Ljava/lang/String;Ljava/lang/Character;)Lorg/jetbrains/exposed/sql/LikePattern;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "Ljava/lang/String;", "getPattern", "Ljava/lang/Character;", "getEscapeChar", "Companion", "exposed-core"})
@SourceDebugExtension(value={"SMAP\nSQLExpressionBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SQLExpressionBuilder.kt\norg/jetbrains/exposed/sql/LikePattern\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1089:1\n1#2:1090\n*E\n"})
public final class LikePattern {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String pattern;
    @Nullable
    private final Character escapeChar;

    public LikePattern(@NotNull String pattern, @Nullable Character escapeChar) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        this.pattern = pattern;
        this.escapeChar = escapeChar;
    }

    public /* synthetic */ LikePattern(String string, Character c, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            c = null;
        }
        this(string, c);
    }

    @NotNull
    public final String getPattern() {
        return this.pattern;
    }

    @Nullable
    public final Character getEscapeChar() {
        return this.escapeChar;
    }

    @NotNull
    public final LikePattern plus(@NotNull LikePattern rhs) {
        Intrinsics.checkNotNullParameter((Object)rhs, (String)"rhs");
        if (!Intrinsics.areEqual((Object)this.escapeChar, (Object)rhs.escapeChar)) {
            boolean bl = false;
            String string = "Mixing escape chars '" + this.escapeChar + "' vs. '" + rhs.escapeChar + " is not allowed";
            throw new IllegalArgumentException(string.toString());
        }
        return new LikePattern(this.pattern + rhs.pattern, rhs.escapeChar);
    }

    @NotNull
    public final LikePattern plus(@NotNull String rhs) {
        Intrinsics.checkNotNullParameter((Object)rhs, (String)"rhs");
        return new LikePattern(this.pattern + rhs, this.escapeChar);
    }

    @NotNull
    public final String component1() {
        return this.pattern;
    }

    @Nullable
    public final Character component2() {
        return this.escapeChar;
    }

    @NotNull
    public final LikePattern copy(@NotNull String pattern, @Nullable Character escapeChar) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        return new LikePattern(pattern, escapeChar);
    }

    public static /* synthetic */ LikePattern copy$default(LikePattern likePattern, String string, Character c, int n, Object object) {
        if ((n & 1) != 0) {
            string = likePattern.pattern;
        }
        if ((n & 2) != 0) {
            c = likePattern.escapeChar;
        }
        return likePattern.copy(string, c);
    }

    @NotNull
    public String toString() {
        return "LikePattern(pattern=" + this.pattern + ", escapeChar=" + this.escapeChar + ')';
    }

    public int hashCode() {
        int result = this.pattern.hashCode();
        result = result * 31 + (this.escapeChar == null ? 0 : ((Object)this.escapeChar).hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LikePattern)) {
            return false;
        }
        LikePattern likePattern = (LikePattern)other;
        if (!Intrinsics.areEqual((Object)this.pattern, (Object)likePattern.pattern)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.escapeChar, (Object)likePattern.escapeChar);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/exposed/sql/LikePattern$Companion;", "", "<init>", "()V", "", "text", "", "escapeChar", "Lorg/jetbrains/exposed/sql/LikePattern;", "ofLiteral", "(Ljava/lang/String;C)Lorg/jetbrains/exposed/sql/LikePattern;", "exposed-core"})
    @SourceDebugExtension(value={"SMAP\nSQLExpressionBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SQLExpressionBuilder.kt\norg/jetbrains/exposed/sql/LikePattern$Companion\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,1089:1\n1179#2,2:1090\n*S KotlinDebug\n*F\n+ 1 SQLExpressionBuilder.kt\norg/jetbrains/exposed/sql/LikePattern$Companion\n*L\n280#1:1090,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LikePattern ofLiteral(@NotNull String text, char escapeChar) {
            StringBuilder stringBuilder;
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Map<Character, Character> likePatternSpecialChars = DatabaseDialectKt.getCurrentDialect().getLikePatternSpecialChars();
            ArrayList<Character> nextExpectedPatternQueue = new ArrayList<Character>();
            Object nextCharToEscape = null;
            StringBuilder $this$ofLiteral_u24lambda_u242 = stringBuilder = new StringBuilder();
            boolean bl = false;
            CharSequence $this$forEach$iv = text;
            boolean $i$f$forEach = false;
            for (int i = 0; i < $this$forEach$iv.length(); ++i) {
                boolean shouldEscape;
                boolean bl2;
                char element$iv;
                char it = element$iv = $this$forEach$iv.charAt(i);
                boolean bl3 = false;
                char c = it;
                if (c == escapeChar) {
                    bl2 = true;
                } else {
                    Character c2 = Character.valueOf(c);
                    if (likePatternSpecialChars.containsKey(c2)) {
                        Character c3 = likePatternSpecialChars.get(Character.valueOf(it));
                        if (c3 != null) {
                            char nextChar = c3.charValue();
                            boolean bl4 = false;
                            nextExpectedPatternQueue.add(Character.valueOf(nextChar));
                            nextCharToEscape = Character.valueOf(nextChar);
                        }
                        bl2 = true;
                    } else {
                        Character c4 = (Character)nextCharToEscape;
                        if (c4 != null && c == c4.charValue()) {
                            CollectionsKt.removeLast((List)nextExpectedPatternQueue);
                            nextCharToEscape = CollectionsKt.lastOrNull((List)nextExpectedPatternQueue);
                            bl2 = true;
                        } else {
                            bl2 = shouldEscape = false;
                        }
                    }
                }
                if (shouldEscape) {
                    $this$ofLiteral_u24lambda_u242.append(escapeChar);
                }
                $this$ofLiteral_u24lambda_u242.append(it);
            }
            String escapedPattern = stringBuilder.toString();
            return new LikePattern(escapedPattern, Character.valueOf(escapeChar));
        }

        public static /* synthetic */ LikePattern ofLiteral$default(Companion companion, String string, char c, int n, Object object) {
            if ((n & 2) != 0) {
                c = (char)92;
            }
            return companion.ofLiteral(string, c);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

