/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.AndBitOp;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ExpressionKt;
import org.jetbrains.exposed.sql.ExpressionWithColumnType;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.OpKt;
import org.jetbrains.exposed.sql.QueryBuilder;
import org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.H2Dialect;
import org.jetbrains.exposed.sql.vendors.OracleDialect;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\u0018\u0000*\u0004\b\u0000\u0010\u0001*\b\b\u0001\u0010\u0002*\u00028\u00002\b\u0012\u0004\u0012\u00028\u00000\u0003B6\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u0012\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\b\u00028\u00000\u0007\u00f8\u0001\u0000\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0010\u001a\u0004\b\u0013\u0010\u0012R%\u0010\b\u001a\n\u0012\u0006\u0012\u0004\b\u00028\u00000\u00078\u0016X\u0096\u0004\u00f8\u0001\u0000\u00a2\u0006\f\n\u0004\b\b\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016\u0082\u0002\u0004\n\u0002\b9\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/exposed/sql/OrBitOp;", "T", "S", "Lorg/jetbrains/exposed/sql/ExpressionWithColumnType;", "Lorg/jetbrains/exposed/sql/Expression;", "expr1", "expr2", "Lorg/jetbrains/exposed/sql/IColumnType;", "columnType", "<init>", "(Lorg/jetbrains/exposed/sql/Expression;Lorg/jetbrains/exposed/sql/Expression;Lorg/jetbrains/exposed/sql/IColumnType;)V", "Lorg/jetbrains/exposed/sql/QueryBuilder;", "queryBuilder", "", "toQueryBuilder", "(Lorg/jetbrains/exposed/sql/QueryBuilder;)V", "Lorg/jetbrains/exposed/sql/Expression;", "getExpr1", "()Lorg/jetbrains/exposed/sql/Expression;", "getExpr2", "Lorg/jetbrains/exposed/sql/IColumnType;", "getColumnType", "()Lorg/jetbrains/exposed/sql/IColumnType;", "exposed-core"})
public final class OrBitOp<T, S extends T>
extends ExpressionWithColumnType<T> {
    @NotNull
    private final Expression<T> expr1;
    @NotNull
    private final Expression<S> expr2;
    @NotNull
    private final IColumnType<T> columnType;

    public OrBitOp(@NotNull Expression<T> expr1, @NotNull Expression<S> expr2, @NotNull IColumnType<T> columnType) {
        Intrinsics.checkNotNullParameter(expr1, (String)"expr1");
        Intrinsics.checkNotNullParameter(expr2, (String)"expr2");
        Intrinsics.checkNotNullParameter(columnType, (String)"columnType");
        this.expr1 = expr1;
        this.expr2 = expr2;
        this.columnType = columnType;
    }

    @NotNull
    public final Expression<T> getExpr1() {
        return this.expr1;
    }

    @NotNull
    public final Expression<S> getExpr2() {
        return this.expr2;
    }

    @Override
    @NotNull
    public IColumnType<T> getColumnType() {
        return this.columnType;
    }

    @Override
    public void toQueryBuilder(@NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"queryBuilder");
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)((Function1)arg_0 -> OrBitOp.toQueryBuilder$lambda$0(this, arg_0)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final Unit toQueryBuilder$lambda$0(OrBitOp this$0, QueryBuilder $this$queryBuilder) {
        QueryBuilder queryBuilder;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$this$queryBuilder, (String)"$this$queryBuilder");
        DatabaseDialect dialect = DatabaseDialectKt.getCurrentDialectIfAvailable();
        if (dialect instanceof OracleDialect) {
            Object[] objectArray = new Object[]{"(", this$0.expr1, "+", this$0.expr2, "-", new AndBitOp(this$0.expr1, this$0.expr2, this$0.getColumnType()), ")"};
            queryBuilder = ExpressionKt.append($this$queryBuilder, objectArray);
            return Unit.INSTANCE;
        } else if (dialect instanceof H2Dialect) {
            boolean bl = ((H2Dialect)dialect).isSecondVersion();
            if (!bl) {
                Object[] objectArray = new Object[]{"BITOR(", this$0.expr1, ", ", this$0.expr2, ")"};
                queryBuilder = ExpressionKt.append($this$queryBuilder, objectArray);
                return Unit.INSTANCE;
            } else {
                if (!bl) throw new NoWhenBranchMatchedException();
                $this$queryBuilder.unaryPlus("BITOR(");
                OpKt.access$castToExpressionTypeForH2BitWiseIps(this$0, this$0.expr1, $this$queryBuilder);
                $this$queryBuilder.unaryPlus(", ");
                OpKt.access$castToExpressionTypeForH2BitWiseIps(this$0, this$0.expr2, $this$queryBuilder);
                queryBuilder = $this$queryBuilder.unaryPlus(")");
            }
            return Unit.INSTANCE;
        } else {
            Object[] objectArray = new Object[]{Character.valueOf('('), this$0.expr1, " | ", this$0.expr2, Character.valueOf(')')};
            queryBuilder = ExpressionKt.append($this$queryBuilder, objectArray);
        }
        return Unit.INSTANCE;
    }
}

