/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.exceptions.LongQueryException;
import org.jetbrains.exposed.sql.Alias;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.Database;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.QueryBuilder;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.SqlLogger;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.UserDataHolder;
import org.jetbrains.exposed.sql.statements.GlobalStatementInterceptor;
import org.jetbrains.exposed.sql.statements.Statement;
import org.jetbrains.exposed.sql.statements.StatementContext;
import org.jetbrains.exposed.sql.statements.StatementInterceptor;
import org.jetbrains.exposed.sql.statements.StatementResult;
import org.jetbrains.exposed.sql.statements.StatementType;
import org.jetbrains.exposed.sql.statements.api.ExposedConnection;
import org.jetbrains.exposed.sql.statements.api.PreparedStatementApi;
import org.jetbrains.exposed.sql.transactions.TransactionApiKt;
import org.jetbrains.exposed.sql.transactions.TransactionInterface;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00cc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b8\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010!\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 \u00ab\u00012\u00020\u00012\u00020\u0002:\u0002\u00ab\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000b\u0010\nJ\u000f\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\u001f\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015JG\u0010\u001d\u001a\u0004\u0018\u00010\f2\b\b\u0001\u0010\u0013\u001a\u00020\u00122 \b\u0002\u0010\u001a\u001a\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u00170\u00162\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001b\u00a2\u0006\u0004\b\u001d\u0010\u001eJg\u0010\u001d\u001a\u0004\u0018\u00018\u0000\"\b\b\u0000\u0010\u001f*\u00020\u00192\b\b\u0001\u0010\u0013\u001a\u00020\u00122 \b\u0002\u0010\u001a\u001a\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u00170\u00162\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\u0014\u0010\"\u001a\u0010\u0012\u0004\u0012\u00020!\u0012\u0006\u0012\u0004\u0018\u00018\u00000 \u00a2\u0006\u0004\b\u001d\u0010#J#\u0010\u001d\u001a\u0004\u0018\u00018\u0000\"\u0004\b\u0000\u0010\u001f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000$\u00a2\u0006\u0004\b\u001d\u0010%J\u001b\u0010(\u001a\u00020\f2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00120&\u00a2\u0006\u0004\b(\u0010)JN\u0010\u001d\u001a\u0004\u0018\u00018\u0001\"\u0004\b\u0000\u0010\u001f\"\u0004\b\u0001\u0010*2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000$2#\u0010-\u001a\u001f\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000$\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010+\u00a2\u0006\u0002\b,\u00a2\u0006\u0004\b\u001d\u0010.J\u0015\u00101\u001a\u00020\u00122\u0006\u00100\u001a\u00020/\u00a2\u0006\u0004\b1\u00102J\u0019\u00105\u001a\u00020\u00122\n\u00104\u001a\u0006\u0012\u0002\b\u000303\u00a2\u0006\u0004\b5\u00106J#\u00105\u001a\u00020\f2\n\u00104\u001a\u0006\u0012\u0002\b\u0003032\u0006\u00108\u001a\u000207H\u0000\u00a2\u0006\u0004\b9\u0010:J\u0019\u00101\u001a\u00020\u00122\n\u00104\u001a\u0006\u0012\u0002\b\u000303\u00a2\u0006\u0004\b1\u00106J\r\u0010;\u001a\u00020\f\u00a2\u0006\u0004\b;\u0010\u000eJ\u000f\u0010>\u001a\u00020\u0010H\u0000\u00a2\u0006\u0004\b<\u0010=J\u0010\u0010?\u001a\u00020\fH\u0096\u0001\u00a2\u0006\u0004\b?\u0010\u000eR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010@R\u0017\u0010B\u001a\u00020A8\u0006\u00a2\u0006\f\n\u0004\bB\u0010C\u001a\u0004\bD\u0010ER\"\u0010G\u001a\u00020F8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bG\u0010H\u001a\u0004\bI\u0010J\"\u0004\bK\u0010LR\"\u0010M\u001a\u00020\u00108\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bM\u0010N\u001a\u0004\bO\u0010=\"\u0004\bP\u0010QR$\u0010R\u001a\u0004\u0018\u00010\u00108\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bR\u0010S\u001a\u0004\bT\u0010U\"\u0004\bV\u0010WR\"\u0010X\u001a\u00020\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bX\u0010Y\u001a\u0004\bZ\u0010[\"\u0004\b\\\u0010]R*\u0010_\u001a\u00020F2\u0006\u0010^\u001a\u00020F8\u0006@FX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b_\u0010H\u001a\u0004\b`\u0010J\"\u0004\ba\u0010LR\"\u0010b\u001a\u00020\u00108\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bb\u0010N\u001a\u0004\bc\u0010=\"\u0004\bd\u0010QR\"\u0010e\u001a\u00020\u00108\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\be\u0010N\u001a\u0004\bf\u0010=\"\u0004\bg\u0010QR*\u0010k\u001a\u00020F2\u0006\u0010^\u001a\u00020F8F@FX\u0087\u000e\u00a2\u0006\u0012\u0012\u0004\bj\u0010\u000e\u001a\u0004\bh\u0010J\"\u0004\bi\u0010LR*\u0010o\u001a\u00020\u00102\u0006\u0010^\u001a\u00020\u00108F@FX\u0087\u000e\u00a2\u0006\u0012\u0012\u0004\bn\u0010\u000e\u001a\u0004\bl\u0010=\"\u0004\bm\u0010QR*\u0010s\u001a\u00020\u00102\u0006\u0010^\u001a\u00020\u00108F@FX\u0087\u000e\u00a2\u0006\u0012\u0012\u0004\br\u0010\u000e\u001a\u0004\bp\u0010=\"\u0004\bq\u0010QR$\u0010t\u001a\u0004\u0018\u00010F8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bt\u0010u\u001a\u0004\bv\u0010w\"\u0004\bx\u0010yR\u001b\u0010~\u001a\u00020\u00128FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bz\u0010{\u001a\u0004\b|\u0010}R+\u0010\u0080\u0001\u001a\u0004\u0018\u00010\u007f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0018\n\u0006\b\u0080\u0001\u0010\u0081\u0001\u001a\u0006\b\u0082\u0001\u0010\u0083\u0001\"\u0006\b\u0084\u0001\u0010\u0085\u0001R/\u0010\u0086\u0001\u001a\b\u0012\u0002\b\u0003\u0018\u00010$8\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0018\n\u0006\b\u0086\u0001\u0010\u0087\u0001\u001a\u0006\b\u0088\u0001\u0010\u0089\u0001\"\u0006\b\u008a\u0001\u0010\u008b\u0001R&\u0010\u008c\u0001\u001a\u00020\b8\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0015\n\u0005\b\u008c\u0001\u0010Y\u001a\u0005\b\u008d\u0001\u0010[\"\u0005\b\u008e\u0001\u0010]R&\u0010\u0090\u0001\u001a\t\u0012\u0004\u0012\u00020\u007f0\u008f\u00018\u0000X\u0080\u0004\u00a2\u0006\u0010\n\u0006\b\u0090\u0001\u0010\u0091\u0001\u001a\u0006\b\u0092\u0001\u0010\u0093\u0001R&\u0010\u0094\u0001\u001a\u00020F8\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0015\n\u0005\b\u0094\u0001\u0010H\u001a\u0005\b\u0095\u0001\u0010J\"\u0005\b\u0096\u0001\u0010LR&\u0010\u0098\u0001\u001a\t\u0012\u0004\u0012\u00020\u00060\u0097\u00018\u0000X\u0080\u0004\u00a2\u0006\u0010\n\u0006\b\u0098\u0001\u0010\u0099\u0001\u001a\u0006\b\u009a\u0001\u0010\u009b\u0001R\u001d\u0010\u009d\u0001\u001a\u00030\u009c\u00018\u0006\u00a2\u0006\u0010\n\u0006\b\u009d\u0001\u0010\u009e\u0001\u001a\u0006\b\u009f\u0001\u0010\u00a0\u0001R8\u0010\u00a5\u0001\u001a\u001b\u0012\u0004\u0012\u00020\u0012\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020F\u0012\u0004\u0012\u00020\u00100\u00170\u00a1\u00018FX\u0086\u0084\u0002\u00a2\u0006\u000f\n\u0005\b\u00a2\u0001\u0010{\u001a\u0006\b\u00a3\u0001\u0010\u00a4\u0001R\u0011\u0010\u00a7\u0001\u001a\u0007\u0012\u0002\b\u00030\u00a6\u00018\u0016X\u0096\u0005R\u000e\u0010\u00a8\u0001\u001a\u0004\u0018\u00010\u00008\u0016X\u0096\u0005R\f\u0010\u00a9\u0001\u001a\u00020\b8\u0016X\u0096\u0005R\f\u0010\u00aa\u0001\u001a\u00020F8\u0016X\u0096\u0005\u00a8\u0006\u00ac\u0001"}, d2={"Lorg/jetbrains/exposed/sql/Transaction;", "Lorg/jetbrains/exposed/sql/UserDataHolder;", "Lorg/jetbrains/exposed/sql/transactions/TransactionInterface;", "transactionImpl", "<init>", "(Lorg/jetbrains/exposed/sql/transactions/TransactionInterface;)V", "Lorg/jetbrains/exposed/sql/statements/StatementInterceptor;", "interceptor", "", "registerInterceptor", "(Lorg/jetbrains/exposed/sql/statements/StatementInterceptor;)Z", "unregisterInterceptor", "", "commit", "()V", "rollback", "", "delta", "", "stmt", "describeStatement", "(JLjava/lang/String;)Ljava/lang/String;", "", "Lkotlin/Pair;", "Lorg/jetbrains/exposed/sql/IColumnType;", "", "args", "Lorg/jetbrains/exposed/sql/statements/StatementType;", "explicitStatementType", "exec", "(Ljava/lang/String;Ljava/lang/Iterable;Lorg/jetbrains/exposed/sql/statements/StatementType;)Lkotlin/Unit;", "T", "Lkotlin/Function1;", "Ljava/sql/ResultSet;", "transform", "(Ljava/lang/String;Ljava/lang/Iterable;Lorg/jetbrains/exposed/sql/statements/StatementType;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "Lorg/jetbrains/exposed/sql/statements/Statement;", "(Lorg/jetbrains/exposed/sql/statements/Statement;)Ljava/lang/Object;", "", "stmts", "execInBatch", "(Ljava/util/List;)V", "R", "Lkotlin/Function2;", "Lkotlin/ExtensionFunctionType;", "body", "(Lorg/jetbrains/exposed/sql/statements/Statement;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "Lorg/jetbrains/exposed/sql/Table;", "table", "identity", "(Lorg/jetbrains/exposed/sql/Table;)Ljava/lang/String;", "Lorg/jetbrains/exposed/sql/Column;", "column", "fullIdentity", "(Lorg/jetbrains/exposed/sql/Column;)Ljava/lang/String;", "Lorg/jetbrains/exposed/sql/QueryBuilder;", "queryBuilder", "fullIdentity$exposed_core", "(Lorg/jetbrains/exposed/sql/Column;Lorg/jetbrains/exposed/sql/QueryBuilder;)V", "closeExecutedStatements", "getRetryInterval$exposed_core", "()J", "getRetryInterval", "close", "Lorg/jetbrains/exposed/sql/transactions/TransactionInterface;", "Lorg/jetbrains/exposed/sql/Database;", "db", "Lorg/jetbrains/exposed/sql/Database;", "getDb", "()Lorg/jetbrains/exposed/sql/Database;", "", "statementCount", "I", "getStatementCount", "()I", "setStatementCount", "(I)V", "duration", "J", "getDuration", "setDuration", "(J)V", "warnLongQueriesDuration", "Ljava/lang/Long;", "getWarnLongQueriesDuration", "()Ljava/lang/Long;", "setWarnLongQueriesDuration", "(Ljava/lang/Long;)V", "debug", "Z", "getDebug", "()Z", "setDebug", "(Z)V", "value", "maxAttempts", "getMaxAttempts", "setMaxAttempts", "minRetryDelay", "getMinRetryDelay", "setMinRetryDelay", "maxRetryDelay", "getMaxRetryDelay", "setMaxRetryDelay", "getRepetitionAttempts", "setRepetitionAttempts", "getRepetitionAttempts$annotations", "repetitionAttempts", "getMinRepetitionDelay", "setMinRepetitionDelay", "getMinRepetitionDelay$annotations", "minRepetitionDelay", "getMaxRepetitionDelay", "setMaxRepetitionDelay", "getMaxRepetitionDelay$annotations", "maxRepetitionDelay", "queryTimeout", "Ljava/lang/Integer;", "getQueryTimeout", "()Ljava/lang/Integer;", "setQueryTimeout", "(Ljava/lang/Integer;)V", "id$delegate", "Lkotlin/Lazy;", "getId", "()Ljava/lang/String;", "id", "Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;", "currentStatement", "Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;", "getCurrentStatement", "()Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;", "setCurrentStatement", "(Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;)V", "explainStatement", "Lorg/jetbrains/exposed/sql/statements/Statement;", "getExplainStatement$exposed_core", "()Lorg/jetbrains/exposed/sql/statements/Statement;", "setExplainStatement$exposed_core", "(Lorg/jetbrains/exposed/sql/statements/Statement;)V", "blockStatementExecution", "getBlockStatementExecution$exposed_core", "setBlockStatementExecution$exposed_core", "", "executedStatements", "Ljava/util/List;", "getExecutedStatements$exposed_core", "()Ljava/util/List;", "openResultSetsCount", "getOpenResultSetsCount$exposed_core", "setOpenResultSetsCount$exposed_core", "Ljava/util/ArrayList;", "interceptors", "Ljava/util/ArrayList;", "getInterceptors$exposed_core", "()Ljava/util/ArrayList;", "Ljava/lang/StringBuilder;", "statements", "Ljava/lang/StringBuilder;", "getStatements", "()Ljava/lang/StringBuilder;", "Ljava/util/HashMap;", "statementStats$delegate", "getStatementStats", "()Ljava/util/HashMap;", "statementStats", "Lorg/jetbrains/exposed/sql/statements/api/ExposedConnection;", "connection", "outerTransaction", "readOnly", "transactionIsolation", "Companion", "exposed-core"})
@SourceDebugExtension(value={"SMAP\nTransaction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Transaction.kt\norg/jetbrains/exposed/sql/Transaction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,366:1\n1#2:367\n1863#3,2:368\n1863#3,2:370\n1863#3,2:372\n1863#3,2:374\n1863#3,2:376\n1863#3,2:378\n1863#3,2:380\n1863#3,2:382\n1863#3,2:391\n1557#3:393\n1628#3,3:394\n1863#3,2:397\n381#4,7:384\n*S KotlinDebug\n*F\n+ 1 Transaction.kt\norg/jetbrains/exposed/sql/Transaction\n*L\n166#1:368,2\n170#1:370,2\n176#1:372,2\n177#1:374,2\n182#1:376,2\n183#1:378,2\n185#1:380,2\n186#1:382,2\n340#1:391,2\n296#1:393\n296#1:394,3\n360#1:397,2\n303#1:384,7\n*E\n"})
public class Transaction
extends UserDataHolder
implements TransactionInterface {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TransactionInterface transactionImpl;
    @NotNull
    private final Database db;
    private int statementCount;
    private long duration;
    @Nullable
    private Long warnLongQueriesDuration;
    private boolean debug;
    private int maxAttempts;
    private long minRetryDelay;
    private long maxRetryDelay;
    @Nullable
    private Integer queryTimeout;
    @NotNull
    private final Lazy id$delegate;
    @Nullable
    private PreparedStatementApi currentStatement;
    @Nullable
    private Statement<?> explainStatement;
    private boolean blockStatementExecution;
    @NotNull
    private final List<PreparedStatementApi> executedStatements;
    private int openResultSetsCount;
    @NotNull
    private final ArrayList<StatementInterceptor> interceptors;
    @NotNull
    private final StringBuilder statements;
    @NotNull
    private final Lazy statementStats$delegate;
    @NotNull
    private static final ArrayList<GlobalStatementInterceptor> globalInterceptors = new ArrayList();

    public Transaction(@NotNull TransactionInterface transactionImpl) {
        Intrinsics.checkNotNullParameter((Object)transactionImpl, (String)"transactionImpl");
        this.transactionImpl = transactionImpl;
        this.db = this.transactionImpl.getDb();
        this.warnLongQueriesDuration = this.db.getConfig().getWarnLongQueriesDuration();
        this.maxAttempts = TransactionApiKt.getTransactionManager(this.db).getDefaultMaxAttempts();
        this.minRetryDelay = TransactionApiKt.getTransactionManager(this.db).getDefaultMinRetryDelay();
        this.maxRetryDelay = TransactionApiKt.getTransactionManager(this.db).getDefaultMaxRetryDelay();
        this.id$delegate = LazyKt.lazy(Transaction::id_delegate$lambda$1);
        this.executedStatements = new ArrayList();
        this.interceptors = new ArrayList();
        this.statements = new StringBuilder();
        this.statementStats$delegate = LazyKt.lazy(Transaction::statementStats_delegate$lambda$2);
        SqlLogger[] sqlLoggerArray = new SqlLogger[]{this.db.getConfig().getSqlLogger()};
        SQLLogKt.addLogger(this, sqlLoggerArray);
    }

    @Override
    public void close() {
        this.transactionImpl.close();
    }

    @Override
    @NotNull
    public ExposedConnection<?> getConnection() {
        return this.transactionImpl.getConnection();
    }

    @Override
    public int getTransactionIsolation() {
        return this.transactionImpl.getTransactionIsolation();
    }

    @Override
    public boolean getReadOnly() {
        return this.transactionImpl.getReadOnly();
    }

    @Override
    @Nullable
    public Transaction getOuterTransaction() {
        return this.transactionImpl.getOuterTransaction();
    }

    @Override
    @NotNull
    public final Database getDb() {
        return this.db;
    }

    public final int getStatementCount() {
        return this.statementCount;
    }

    public final void setStatementCount(int n) {
        this.statementCount = n;
    }

    public final long getDuration() {
        return this.duration;
    }

    public final void setDuration(long l) {
        this.duration = l;
    }

    @Nullable
    public final Long getWarnLongQueriesDuration() {
        return this.warnLongQueriesDuration;
    }

    public final void setWarnLongQueriesDuration(@Nullable Long l) {
        this.warnLongQueriesDuration = l;
    }

    public final boolean getDebug() {
        return this.debug;
    }

    public final void setDebug(boolean bl) {
        this.debug = bl;
    }

    public final int getMaxAttempts() {
        return this.maxAttempts;
    }

    public final void setMaxAttempts(int value2) {
        if (!(value2 > 0)) {
            boolean bl = false;
            String string = "maxAttempts must be set to perform at least 1 attempt.";
            throw new IllegalArgumentException(string.toString());
        }
        this.maxAttempts = value2;
    }

    public final long getMinRetryDelay() {
        return this.minRetryDelay;
    }

    public final void setMinRetryDelay(long l) {
        this.minRetryDelay = l;
    }

    public final long getMaxRetryDelay() {
        return this.maxRetryDelay;
    }

    public final void setMaxRetryDelay(long l) {
        this.maxRetryDelay = l;
    }

    public final int getRepetitionAttempts() {
        return this.maxAttempts;
    }

    public final void setRepetitionAttempts(int value2) {
        this.setMaxAttempts(value2);
    }

    @Deprecated(message="This property will be removed in future releases", replaceWith=@ReplaceWith(expression="maxAttempts", imports={}), level=DeprecationLevel.ERROR)
    public static /* synthetic */ void getRepetitionAttempts$annotations() {
    }

    public final long getMinRepetitionDelay() {
        return this.minRetryDelay;
    }

    public final void setMinRepetitionDelay(long value2) {
        this.minRetryDelay = value2;
    }

    @Deprecated(message="This property will be removed in future releases", replaceWith=@ReplaceWith(expression="minRetryDelay", imports={}), level=DeprecationLevel.ERROR)
    public static /* synthetic */ void getMinRepetitionDelay$annotations() {
    }

    public final long getMaxRepetitionDelay() {
        return this.maxRetryDelay;
    }

    public final void setMaxRepetitionDelay(long value2) {
        this.maxRetryDelay = value2;
    }

    @Deprecated(message="This property will be removed in future releases", replaceWith=@ReplaceWith(expression="maxRetryDelay", imports={}), level=DeprecationLevel.ERROR)
    public static /* synthetic */ void getMaxRepetitionDelay$annotations() {
    }

    @Nullable
    public final Integer getQueryTimeout() {
        return this.queryTimeout;
    }

    public final void setQueryTimeout(@Nullable Integer n) {
        this.queryTimeout = n;
    }

    @NotNull
    public final String getId() {
        Lazy lazy2 = this.id$delegate;
        return (String)lazy2.getValue();
    }

    @Nullable
    public final PreparedStatementApi getCurrentStatement() {
        return this.currentStatement;
    }

    public final void setCurrentStatement(@Nullable PreparedStatementApi preparedStatementApi) {
        this.currentStatement = preparedStatementApi;
    }

    @Nullable
    public final Statement<?> getExplainStatement$exposed_core() {
        return this.explainStatement;
    }

    public final void setExplainStatement$exposed_core(@Nullable Statement<?> statement) {
        this.explainStatement = statement;
    }

    public final boolean getBlockStatementExecution$exposed_core() {
        return this.blockStatementExecution;
    }

    public final void setBlockStatementExecution$exposed_core(boolean bl) {
        this.blockStatementExecution = bl;
    }

    @NotNull
    public final List<PreparedStatementApi> getExecutedStatements$exposed_core() {
        return this.executedStatements;
    }

    public final int getOpenResultSetsCount$exposed_core() {
        return this.openResultSetsCount;
    }

    public final void setOpenResultSetsCount$exposed_core(int n) {
        this.openResultSetsCount = n;
    }

    @NotNull
    public final ArrayList<StatementInterceptor> getInterceptors$exposed_core() {
        return this.interceptors;
    }

    @NotNull
    public final StringBuilder getStatements() {
        return this.statements;
    }

    @NotNull
    public final HashMap<String, Pair<Integer, Long>> getStatementStats() {
        Lazy lazy2 = this.statementStats$delegate;
        return (HashMap)lazy2.getValue();
    }

    public final boolean registerInterceptor(@NotNull StatementInterceptor interceptor) {
        Intrinsics.checkNotNullParameter((Object)interceptor, (String)"interceptor");
        return this.interceptors.add(interceptor);
    }

    public final boolean unregisterInterceptor(@NotNull StatementInterceptor interceptor) {
        Intrinsics.checkNotNullParameter((Object)interceptor, (String)"interceptor");
        return this.interceptors.remove(interceptor);
    }

    @Override
    public void commit() {
        StatementInterceptor it;
        HashMap dataToStore = new HashMap();
        Iterable $this$forEach$iv = globalInterceptors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (GlobalStatementInterceptor)element$iv;
            boolean bl = false;
            dataToStore.putAll(it.keepUserDataInTransactionStoreOnCommit((Map)this.getUserdata()));
            it.beforeCommit(this);
        }
        $this$forEach$iv = this.interceptors;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (StatementInterceptor)element$iv;
            boolean bl = false;
            dataToStore.putAll(it.keepUserDataInTransactionStoreOnCommit((Map)this.getUserdata()));
            it.beforeCommit(this);
        }
        this.transactionImpl.commit();
        this.getUserdata().clear();
        $this$forEach$iv = globalInterceptors;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (GlobalStatementInterceptor)element$iv;
            boolean bl = false;
            it.afterCommit(this);
        }
        $this$forEach$iv = this.interceptors;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (StatementInterceptor)element$iv;
            boolean bl = false;
            it.afterCommit(this);
        }
        this.getUserdata().putAll(dataToStore);
    }

    @Override
    public void rollback() {
        StatementInterceptor it;
        Iterable $this$forEach$iv = globalInterceptors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (GlobalStatementInterceptor)element$iv;
            boolean bl = false;
            it.beforeRollback(this);
        }
        $this$forEach$iv = this.interceptors;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (StatementInterceptor)element$iv;
            boolean bl = false;
            it.beforeRollback(this);
        }
        this.transactionImpl.rollback();
        $this$forEach$iv = globalInterceptors;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (GlobalStatementInterceptor)element$iv;
            boolean bl = false;
            it.afterRollback(this);
        }
        $this$forEach$iv = this.interceptors;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (StatementInterceptor)element$iv;
            boolean bl = false;
            it.afterRollback(this);
        }
        this.getUserdata().clear();
    }

    private final String describeStatement(long delta, String stmt) {
        return "" + '[' + delta + "ms] " + StringsKt.take((String)stmt, (int)1024) + "\n\n";
    }

    @Nullable
    public final Unit exec(@Language(value="sql") @NotNull String stmt, @NotNull Iterable<? extends Pair<? extends IColumnType<?>, ? extends Object>> args, @Nullable StatementType explicitStatementType) {
        Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        return (Unit)this.exec(stmt, args, explicitStatementType, Transaction::exec$lambda$11);
    }

    public static /* synthetic */ Unit exec$default(Transaction transaction, String string, Iterable iterable, StatementType statementType, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: exec");
        }
        if ((n & 2) != 0) {
            iterable = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            statementType = null;
        }
        return transaction.exec(string, iterable, statementType);
    }

    @Nullable
    public final <T> T exec(@Language(value="sql") @NotNull String stmt, @NotNull Iterable<? extends Pair<? extends IColumnType<?>, ? extends Object>> args, @Nullable StatementType explicitStatementType, @NotNull Function1<? super ResultSet, ? extends T> transform) {
        Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        if (((CharSequence)stmt).length() == 0) {
            return null;
        }
        StatementType statementType = explicitStatementType;
        if (statementType == null) {
            Object v1;
            block4: {
                Iterable iterable = (Iterable)StatementType.getEntries();
                for (Object t : iterable) {
                    StatementType it = (StatementType)((Object)t);
                    boolean bl = false;
                    if (!StringsKt.startsWith((String)((Object)StringsKt.trim((CharSequence)stmt)).toString(), (String)it.name(), (boolean)true)) continue;
                    v1 = t;
                    break block4;
                }
                v1 = null;
            }
            if ((statementType = (StatementType)v1) == null) {
                statementType = StatementType.OTHER;
            }
        }
        StatementType type = statementType;
        List list2 = CollectionsKt.emptyList();
        return this.exec(new Statement<T>(type, transform, stmt, args, list2){
            final /* synthetic */ StatementType $type;
            final /* synthetic */ Function1<ResultSet, T> $transform;
            final /* synthetic */ String $stmt;
            final /* synthetic */ Iterable<Pair<IColumnType<?>, Object>> $args;
            {
                this.$type = $type;
                this.$transform = $transform;
                this.$stmt = $stmt;
                this.$args = $args;
                super($type, $super_call_param$1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public T executeInternal(PreparedStatementApi $this$executeInternal, Transaction transaction) {
                Intrinsics.checkNotNullParameter((Object)$this$executeInternal, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
                switch (exec.WhenMappings.$EnumSwitchMapping$0[this.$type.ordinal()]) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        v0 = $this$executeInternal.executeQuery();
                        break;
                    }
                    case 5: {
                        $this$firstOrNull$iv = $this$executeInternal.executeMultiple();
                        $i$f$firstOrNull = false;
                        for (T element$iv : $this$firstOrNull$iv) {
                            it = (StatementResult)element$iv;
                            $i$a$-firstOrNull-Transaction$exec$2$executeInternal$result$result$1 = false;
                            if (!(it instanceof StatementResult.Object)) continue;
                            v1 = element$iv;
                            ** GOTO lbl17
                        }
                        v1 = null;
lbl17:
                        // 2 sources

                        result = v1;
                        v2 = result instanceof StatementResult.Object != false ? (StatementResult.Object)result : null;
                        if (v2 != null) {
                            v0 = v2.getResultSet();
                            break;
                        }
                        v0 = null;
                        break;
                    }
                    default: {
                        $this$executeInternal.executeUpdate();
                        v0 = $this$executeInternal.getResultSet();
                    }
                }
                v3 = result = v0;
                if (v3 != null) {
                    var4_13 = v3;
                    var5_14 = this.$transform;
                    var6_11 = null;
                    try {
                        it = (ResultSet)var4_13;
                        $i$a$-use-Transaction$exec$2$executeInternal$1 = false;
                        var7_3 = var5_14.invoke((Object)it);
                        v4 = var7_3;
                    }
                    catch (Throwable var8_5) {
                        var6_11 = var8_5;
                        throw var8_5;
                    }
                    finally {
                        AutoCloseableKt.closeFinally((AutoCloseable)var4_13, (Throwable)var6_11);
                    }
                } else {
                    v4 = null;
                }
                return (T)v4;
            }

            public String prepareSQL(Transaction transaction, boolean prepared2) {
                Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
                return this.$stmt;
            }

            /*
             * WARNING - void declaration
             */
            public Iterable<Iterable<Pair<IColumnType<?>, Object>>> arguments() {
                void $this$mapTo$iv$iv;
                Iterable<Pair<IColumnType<?>, Object>> $this$map$iv = this.$args;
                boolean $i$f$map = false;
                Iterable<Pair<IColumnType<?>, Object>> iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    IColumnType iColumnType;
                    Pair pair = (Pair)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    IColumnType columnType = (IColumnType)pair.component1();
                    Object value2 = pair.component2();
                    IColumnType $this$arguments_u24lambda_u243_u24lambda_u242 = iColumnType = columnType;
                    boolean bl2 = false;
                    $this$arguments_u24lambda_u243_u24lambda_u242.setNullable(true);
                    collection.add(TuplesKt.to((Object)iColumnType, (Object)value2));
                }
                return CollectionsKt.listOf((Object)((List)destination$iv$iv));
            }
        });
    }

    public static /* synthetic */ Object exec$default(Transaction transaction, String string, Iterable iterable, StatementType statementType, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: exec");
        }
        if ((n & 2) != 0) {
            iterable = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            statementType = null;
        }
        return transaction.exec(string, iterable, statementType, function1);
    }

    @Nullable
    public final <T> T exec(@NotNull Statement<? extends T> stmt) {
        Intrinsics.checkNotNullParameter(stmt, (String)"stmt");
        return (T)this.exec(stmt, Transaction::exec$lambda$13);
    }

    public final void execInBatch(@NotNull List<String> stmts) {
        Intrinsics.checkNotNullParameter(stmts, (String)"stmts");
        this.getConnection().executeInBatch(stmts);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final <T, R> R exec(@NotNull Statement<? extends T> stmt, @NotNull Function2<? super Statement<? extends T>, ? super T, ? extends R> body) {
        Object object;
        Intrinsics.checkNotNullParameter(stmt, (String)"stmt");
        Intrinsics.checkNotNullParameter(body, (String)"body");
        int n = this.statementCount;
        this.statementCount = n + 1;
        long start = System.nanoTime();
        Pair<? extends T, List<StatementContext>> answer = stmt.executeIn$exposed_core(this);
        long it2 = System.nanoTime() - start;
        boolean bl = false;
        long delta = TimeUnit.NANOSECONDS.toMillis(it2);
        Lazy lazySQL = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> Transaction.exec$lambda$16(answer, this));
        this.duration += delta;
        if (this.debug) {
            Object object2;
            void $this$getOrPut$iv;
            this.statements.append(this.describeStatement(delta, (String)lazySQL.getValue()));
            Map it2 = this.getStatementStats();
            Object key$iv = lazySQL.getValue();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl2 = false;
                Pair answer$iv = TuplesKt.to((Object)0, (Object)0L);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object2 = answer$iv;
            } else {
                object2 = value$iv;
            }
            Pair pair = (Pair)object2;
            boolean bl3 = false;
            int count = ((Number)pair.component1()).intValue();
            long time = ((Number)pair.component2()).longValue();
            ((Map)this.getStatementStats()).put(lazySQL.getValue(), TuplesKt.to((Object)(count + 1), (Object)(time + delta)));
        }
        Long l = this.warnLongQueriesDuration;
        if (delta > (l != null ? l : Long.MAX_VALUE)) {
            SQLLogKt.getExposedLogger().warn("Long query: " + this.describeStatement(delta, (String)lazySQL.getValue()), (Throwable)new LongQueryException());
        }
        Object object3 = answer.getFirst();
        if (object3 != null) {
            Object it3 = object3;
            boolean bl4 = false;
            object = body.invoke(stmt, it3);
        } else {
            object = null;
        }
        return (R)object;
    }

    @NotNull
    public final String identity(@NotNull Table table) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)table, (String)"table");
                object = table instanceof Alias ? (Alias)table : null;
                if (object == null) break block2;
                Alias it = object;
                boolean bl = false;
                String string = this.identity((Table)it.getDelegate()) + ' ' + this.db.getIdentifierManager().quoteIfNecessary(it.getAlias());
                object = string;
                if (string != null) break block3;
            }
            object = this.db.getIdentifierManager().quoteIfNecessary(DatabaseDialectKt.inProperCase(table.getTableName()));
        }
        return object;
    }

    @NotNull
    public final String fullIdentity(@NotNull Column<?> column) {
        QueryBuilder queryBuilder;
        Intrinsics.checkNotNullParameter(column, (String)"column");
        QueryBuilder it = queryBuilder = new QueryBuilder(false);
        boolean bl = false;
        this.fullIdentity$exposed_core(column, it);
        return queryBuilder.toString();
    }

    public final void fullIdentity$exposed_core(@NotNull Column<?> column, @NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"queryBuilder");
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)((Function1)arg_0 -> Transaction.fullIdentity$lambda$22(column, this, arg_0)));
    }

    @NotNull
    public final String identity(@NotNull Column<?> column) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        return this.db.getIdentifierManager().quoteIdentifierWhenWrongCaseOrNecessary(column.getName());
    }

    public final void closeExecutedStatements() {
        Iterable $this$forEach$iv = this.executedStatements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PreparedStatementApi it = (PreparedStatementApi)element$iv;
            boolean bl = false;
            it.closeIfPossible();
        }
        this.openResultSetsCount = 0;
        this.executedStatements.clear();
    }

    public final long getRetryInterval$exposed_core() {
        return this.maxAttempts > 0 ? Math.max((this.maxRetryDelay - this.minRetryDelay) / (long)(this.maxAttempts + 1), 1L) : 0L;
    }

    private static final String id_delegate$lambda$1() {
        return UUID.randomUUID().toString();
    }

    private static final HashMap statementStats_delegate$lambda$2() {
        return new HashMap();
    }

    private static final Unit exec$lambda$11(ResultSet it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final Object exec$lambda$13(Statement $this$exec, Object it) {
        Intrinsics.checkNotNullParameter((Object)$this$exec, (String)"$this$exec");
        return it;
    }

    /*
     * WARNING - void declaration
     */
    private static final String exec$lambda$16(Pair $answer, Transaction this$0) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$answer, (String)"$answer");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Iterable $this$map$iv = (Iterable)$answer.getSecond();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            StatementContext statementContext = (StatementContext)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.sql(this$0));
        }
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.distinct((Iterable)((List)destination$iv$iv)), null, null, null, (int)0, null, null, (int)63, null);
    }

    private static final Unit fullIdentity$lambda$22(Column $column, Transaction this$0, QueryBuilder $this$queryBuilder) {
        Intrinsics.checkNotNullParameter((Object)$column, (String)"$column");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$this$queryBuilder, (String)"$this$queryBuilder");
        QueryBuilder queryBuilder = $column.getTable() instanceof Alias ? $this$queryBuilder.append(this$0.db.getIdentifierManager().quoteIfNecessary(((Alias)$column.getTable()).getAlias())) : $this$queryBuilder.append(this$0.db.getIdentifierManager().quoteIfNecessary(DatabaseDialectKt.inProperCase($column.getTable().getTableName())));
        $this$queryBuilder.append('.');
        $this$queryBuilder.append(this$0.identity($column));
        return Unit.INSTANCE;
    }

    static {
        ServiceLoader<GlobalStatementInterceptor> serviceLoader = ServiceLoader.load(GlobalStatementInterceptor.class, GlobalStatementInterceptor.class.getClassLoader());
        Intrinsics.checkNotNullExpressionValue(serviceLoader, (String)"load(...)");
        Iterable $this$forEach$iv = serviceLoader;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GlobalStatementInterceptor it = (GlobalStatementInterceptor)element$iv;
            boolean bl = false;
            globalInterceptors.add(it);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R \u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/exposed/sql/Transaction$Companion;", "", "<init>", "()V", "Ljava/util/ArrayList;", "Lorg/jetbrains/exposed/sql/statements/GlobalStatementInterceptor;", "globalInterceptors", "Ljava/util/ArrayList;", "getGlobalInterceptors$exposed_core", "()Ljava/util/ArrayList;", "exposed-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ArrayList<GlobalStatementInterceptor> getGlobalInterceptors$exposed_core() {
            return globalInterceptors;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

