/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.javatime;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.ColumnType;
import org.jetbrains.exposed.sql.IDateColumnType;
import org.jetbrains.exposed.sql.javatime.JavaDateColumnTypeKt;
import org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.H2Dialect;
import org.jetbrains.exposed.sql.vendors.H2Kt;
import org.jetbrains.exposed.sql.vendors.MysqlDialect;
import org.jetbrains.exposed.sql.vendors.OracleDialect;
import org.jetbrains.exposed.sql.vendors.PostgreSQLDialect;
import org.jetbrains.exposed.sql.vendors.SQLiteDialect;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u001dB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ!\u0010\u0013\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0015\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0017\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u000bR\u001a\u0010\u0019\u001a\u00020\u00188\u0016X\u0096D\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/exposed/sql/javatime/JavaInstantColumnType;", "Lorg/jetbrains/exposed/sql/ColumnType;", "Ljava/time/Instant;", "Lorg/jetbrains/exposed/sql/IDateColumnType;", "<init>", "()V", "", "sqlType", "()Ljava/lang/String;", "value", "nonNullValueToString", "(Ljava/time/Instant;)Ljava/lang/String;", "", "valueFromDB", "(Ljava/lang/Object;)Ljava/time/Instant;", "Ljava/sql/ResultSet;", "rs", "", "index", "readObject", "(Ljava/sql/ResultSet;I)Ljava/lang/Object;", "notNullValueToDB", "(Ljava/time/Instant;)Ljava/lang/Object;", "nonNullValueAsDefaultString", "", "hasTimePart", "Z", "getHasTimePart", "()Z", "Companion", "exposed-java-time"})
public final class JavaInstantColumnType
extends ColumnType<Instant>
implements IDateColumnType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean hasTimePart;
    @NotNull
    private static final JavaInstantColumnType INSTANCE = new JavaInstantColumnType();

    public JavaInstantColumnType() {
        super(false, 1, null);
        this.hasTimePart = true;
    }

    @Override
    public boolean getHasTimePart() {
        return this.hasTimePart;
    }

    @Override
    @NotNull
    public String sqlType() {
        return DatabaseDialectKt.getCurrentDialect().getDataTypeProvider().dateTimeType();
    }

    @Override
    @NotNull
    public String nonNullValueToString(@NotNull Instant value2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        DatabaseDialect dialect = DatabaseDialectKt.getCurrentDialect();
        if (dialect instanceof OracleDialect) {
            string = JavaDateColumnTypeKt.access$oracleDateTimeLiteral(value2);
        } else if (dialect instanceof SQLiteDialect) {
            string = '\'' + JavaDateColumnTypeKt.access$getSQLITE_AND_ORACLE_DATE_TIME_STRING_FORMATTER().format(value2) + '\'';
        } else if (dialect instanceof MysqlDialect) {
            DateTimeFormatter formatter = ((MysqlDialect)dialect).isFractionDateTimeSupported() ? JavaDateColumnTypeKt.access$getMYSQL_FRACTION_DATE_TIME_STRING_FORMATTER() : JavaDateColumnTypeKt.access$getMYSQL_DATE_TIME_STRING_FORMATTER();
            string = '\'' + formatter.format(value2) + '\'';
        } else {
            string = '\'' + JavaDateColumnTypeKt.access$getDEFAULT_DATE_TIME_STRING_FORMATTER().format(value2) + '\'';
        }
        return string;
    }

    @Override
    @NotNull
    public Instant valueFromDB(@NotNull Object value2) {
        Instant instant;
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Object object = value2;
        if (object instanceof Timestamp) {
            Instant instant2 = ((Timestamp)value2).toInstant();
            instant = instant2;
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"toInstant(...)");
        } else if (object instanceof String) {
            Instant instant3 = Instant.parse((CharSequence)value2);
            instant = instant3;
            Intrinsics.checkNotNullExpressionValue((Object)instant3, (String)"parse(...)");
        } else {
            instant = this.valueFromDB(value2.toString());
        }
        return instant;
    }

    @Override
    @Nullable
    public Object readObject(@NotNull ResultSet rs, int index) {
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        return rs.getTimestamp(index);
    }

    @Override
    @NotNull
    public Object notNullValueToDB(@NotNull Instant value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        return DatabaseDialectKt.getCurrentDialect() instanceof SQLiteDialect ? JavaDateColumnTypeKt.access$getSQLITE_AND_ORACLE_DATE_TIME_STRING_FORMATTER().format(value2) : Timestamp.from(value2);
    }

    @Override
    @NotNull
    public String nonNullValueAsDefaultString(@NotNull Instant value2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        DatabaseDialect dialect = DatabaseDialectKt.getCurrentDialect();
        if (dialect instanceof PostgreSQLDialect) {
            StringBuilder stringBuilder = new StringBuilder().append('\'');
            String string2 = JavaDateColumnTypeKt.access$getSQLITE_AND_ORACLE_DATE_TIME_STRING_FORMATTER().format(value2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            char[] cArray = new char[]{'0'};
            String string3 = StringsKt.trimEnd((String)string2, (char[])cArray);
            cArray = new char[]{'.'};
            string = stringBuilder.append(StringsKt.trimEnd((String)string3, (char[])cArray)).append("'::timestamp without time zone").toString();
        } else if (H2Kt.getH2Mode(dialect) == H2Dialect.H2CompatibilityMode.Oracle) {
            StringBuilder stringBuilder = new StringBuilder().append('\'');
            String string4 = JavaDateColumnTypeKt.access$getSQLITE_AND_ORACLE_DATE_TIME_STRING_FORMATTER().format(value2);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
            char[] cArray = new char[]{'0'};
            String string5 = StringsKt.trimEnd((String)string4, (char[])cArray);
            cArray = new char[]{'.'};
            string = stringBuilder.append(StringsKt.trimEnd((String)string5, (char[])cArray)).append('\'').toString();
        } else {
            string = super.nonNullValueAsDefaultString(value2);
        }
        return string;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0005\u001a\u00020\u00048\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/exposed/sql/javatime/JavaInstantColumnType$Companion;", "", "<init>", "()V", "Lorg/jetbrains/exposed/sql/javatime/JavaInstantColumnType;", "INSTANCE", "Lorg/jetbrains/exposed/sql/javatime/JavaInstantColumnType;", "getINSTANCE$exposed_java_time", "()Lorg/jetbrains/exposed/sql/javatime/JavaInstantColumnType;", "exposed-java-time"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JavaInstantColumnType getINSTANCE$exposed_java_time() {
            return INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

