/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.javatime;

import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.ColumnType;
import org.jetbrains.exposed.sql.IDateColumnType;
import org.jetbrains.exposed.sql.javatime.JavaDateColumnTypeKt;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.OracleDialect;
import org.jetbrains.exposed.sql.vendors.PostgreSQLDialect;
import org.jetbrains.exposed.sql.vendors.SQLiteDialect;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000 \u001c2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u001cB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0019\u0010\r\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u000f\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0011\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u000bJ\u001f\u0010\u0015\u001a\n \u0014*\u0004\u0018\u00010\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0018\u001a\u00020\u00178\u0016X\u0096D\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/exposed/sql/javatime/JavaLocalDateColumnType;", "Lorg/jetbrains/exposed/sql/ColumnType;", "Ljava/time/LocalDate;", "Lorg/jetbrains/exposed/sql/IDateColumnType;", "<init>", "()V", "", "sqlType", "()Ljava/lang/String;", "value", "nonNullValueToString", "(Ljava/time/LocalDate;)Ljava/lang/String;", "", "valueFromDB", "(Ljava/lang/Object;)Ljava/time/LocalDate;", "notNullValueToDB", "(Ljava/time/LocalDate;)Ljava/lang/Object;", "nonNullValueAsDefaultString", "", "instant", "kotlin.jvm.PlatformType", "longToLocalDate", "(J)Ljava/time/LocalDate;", "", "hasTimePart", "Z", "getHasTimePart", "()Z", "Companion", "exposed-java-time"})
public final class JavaLocalDateColumnType
extends ColumnType<LocalDate>
implements IDateColumnType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean hasTimePart;
    @NotNull
    private static final JavaLocalDateColumnType INSTANCE = new JavaLocalDateColumnType();

    public JavaLocalDateColumnType() {
        super(false, 1, null);
    }

    @Override
    public boolean getHasTimePart() {
        return this.hasTimePart;
    }

    @Override
    @NotNull
    public String sqlType() {
        return DatabaseDialectKt.getCurrentDialect().getDataTypeProvider().dateType();
    }

    @Override
    @NotNull
    public String nonNullValueToString(@NotNull LocalDate value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Instant instant = Instant.from(value2.atStartOfDay(ZoneId.systemDefault()));
        String formatted = JavaDateColumnTypeKt.access$getDEFAULT_DATE_STRING_FORMATTER().format(instant);
        if (DatabaseDialectKt.getCurrentDialect() instanceof OracleDialect) {
            Intrinsics.checkNotNull((Object)instant);
            return JavaDateColumnTypeKt.access$oracleDateLiteral(instant);
        }
        return '\'' + formatted + '\'';
    }

    @Override
    @Nullable
    public LocalDate valueFromDB(@NotNull Object value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Object object = value2;
        return object instanceof LocalDate ? (LocalDate)value2 : (object instanceof Date ? this.longToLocalDate(((Date)value2).getTime()) : (object instanceof Timestamp ? this.longToLocalDate(((Timestamp)value2).getTime()) : (object instanceof Integer ? this.longToLocalDate(((Number)value2).intValue()) : (object instanceof Long ? this.longToLocalDate(((Number)value2).longValue()) : (object instanceof String ? LocalDate.parse((CharSequence)value2) : LocalDate.parse(value2.toString()))))));
    }

    @Override
    @NotNull
    public Object notNullValueToDB(@NotNull LocalDate value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        return DatabaseDialectKt.getCurrentDialect() instanceof SQLiteDialect ? JavaDateColumnTypeKt.access$getDEFAULT_DATE_STRING_FORMATTER().format(value2) : new Date(JavaDateColumnTypeKt.access$getMillis(value2));
    }

    @Override
    @NotNull
    public String nonNullValueAsDefaultString(@NotNull LocalDate value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        return DatabaseDialectKt.getCurrentDialect() instanceof PostgreSQLDialect ? this.nonNullValueToString(value2) + "::date" : super.nonNullValueAsDefaultString(value2);
    }

    private final LocalDate longToLocalDate(long instant) {
        return Instant.ofEpochMilli(instant).atZone(ZoneId.systemDefault()).toLocalDate();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0005\u001a\u00020\u00048\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/exposed/sql/javatime/JavaLocalDateColumnType$Companion;", "", "<init>", "()V", "Lorg/jetbrains/exposed/sql/javatime/JavaLocalDateColumnType;", "INSTANCE", "Lorg/jetbrains/exposed/sql/javatime/JavaLocalDateColumnType;", "getINSTANCE$exposed_java_time", "()Lorg/jetbrains/exposed/sql/javatime/JavaLocalDateColumnType;", "exposed-java-time"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JavaLocalDateColumnType getINSTANCE$exposed_java_time() {
            return INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

