/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.javatime;

import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.ColumnType;
import org.jetbrains.exposed.sql.IDateColumnType;
import org.jetbrains.exposed.sql.javatime.JavaDateColumnTypeKt;
import org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.H2Dialect;
import org.jetbrains.exposed.sql.vendors.H2Kt;
import org.jetbrains.exposed.sql.vendors.MysqlDialect;
import org.jetbrains.exposed.sql.vendors.OracleDialect;
import org.jetbrains.exposed.sql.vendors.PostgreSQLDialect;
import org.jetbrains.exposed.sql.vendors.SQLiteDialect;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000 \u001c2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u001cB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u000f\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0011\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u000bJ\u001f\u0010\u0015\u001a\n \u0014*\u0004\u0018\u00010\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0018\u001a\u00020\u00178\u0016X\u0096D\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/exposed/sql/javatime/JavaLocalTimeColumnType;", "Lorg/jetbrains/exposed/sql/ColumnType;", "Ljava/time/LocalTime;", "Lorg/jetbrains/exposed/sql/IDateColumnType;", "<init>", "()V", "", "sqlType", "()Ljava/lang/String;", "value", "nonNullValueToString", "(Ljava/time/LocalTime;)Ljava/lang/String;", "", "valueFromDB", "(Ljava/lang/Object;)Ljava/time/LocalTime;", "notNullValueToDB", "(Ljava/time/LocalTime;)Ljava/lang/Object;", "nonNullValueAsDefaultString", "", "millis", "kotlin.jvm.PlatformType", "longToLocalTime", "(J)Ljava/time/LocalTime;", "", "hasTimePart", "Z", "getHasTimePart", "()Z", "Companion", "exposed-java-time"})
public final class JavaLocalTimeColumnType
extends ColumnType<LocalTime>
implements IDateColumnType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean hasTimePart;
    @NotNull
    private static final JavaLocalTimeColumnType INSTANCE = new JavaLocalTimeColumnType();

    public JavaLocalTimeColumnType() {
        super(false, 1, null);
        this.hasTimePart = true;
    }

    @Override
    public boolean getHasTimePart() {
        return this.hasTimePart;
    }

    @Override
    @NotNull
    public String sqlType() {
        return DatabaseDialectKt.getCurrentDialect().getDataTypeProvider().timeType();
    }

    @Override
    @NotNull
    public String nonNullValueToString(@NotNull LocalTime value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        DatabaseDialect dialect = DatabaseDialectKt.getCurrentDialect();
        if (dialect instanceof OracleDialect || H2Kt.getH2Mode(dialect) == H2Dialect.H2CompatibilityMode.Oracle) {
            return "TIMESTAMP '" + JavaDateColumnTypeKt.access$getORACLE_TIME_STRING_FORMATTER().format(value2) + '\'';
        }
        return '\'' + JavaDateColumnTypeKt.access$getDEFAULT_TIME_STRING_FORMATTER().format(value2) + '\'';
    }

    @Override
    @NotNull
    public LocalTime valueFromDB(@NotNull Object value2) {
        LocalTime localTime;
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Object object = value2;
        if (object instanceof LocalTime) {
            localTime = (LocalTime)value2;
        } else if (object instanceof Time) {
            LocalTime localTime2 = ((Time)value2).toLocalTime();
            localTime = localTime2;
            Intrinsics.checkNotNullExpressionValue((Object)localTime2, (String)"toLocalTime(...)");
        } else if (object instanceof Timestamp) {
            LocalTime localTime3 = ((Timestamp)value2).toLocalDateTime().toLocalTime();
            localTime = localTime3;
            Intrinsics.checkNotNullExpressionValue((Object)localTime3, (String)"toLocalTime(...)");
        } else if (object instanceof Integer) {
            LocalTime localTime4 = this.longToLocalTime(((Number)value2).intValue());
            localTime = localTime4;
            Intrinsics.checkNotNullExpressionValue((Object)localTime4, (String)"longToLocalTime(...)");
        } else if (object instanceof Long) {
            LocalTime localTime5 = this.longToLocalTime(((Number)value2).longValue());
            localTime = localTime5;
            Intrinsics.checkNotNullExpressionValue((Object)localTime5, (String)"longToLocalTime(...)");
        } else if (object instanceof String) {
            DatabaseDialect dialect = DatabaseDialectKt.getCurrentDialect();
            DateTimeFormatter formatter = dialect instanceof OracleDialect || H2Kt.getH2Mode(dialect) == H2Dialect.H2CompatibilityMode.Oracle ? JavaDateColumnTypeKt.access$formatterForDateString((String)value2) : JavaDateColumnTypeKt.access$getDEFAULT_TIME_STRING_FORMATTER();
            LocalTime localTime6 = LocalTime.parse((CharSequence)value2, formatter);
            Intrinsics.checkNotNull((Object)localTime6);
            localTime = localTime6;
        } else {
            localTime = this.valueFromDB(value2.toString());
        }
        return localTime;
    }

    @Override
    @NotNull
    public Object notNullValueToDB(@NotNull LocalTime value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        return DatabaseDialectKt.getCurrentDialect() instanceof SQLiteDialect ? JavaDateColumnTypeKt.access$getDEFAULT_TIME_STRING_FORMATTER().format(value2) : (H2Kt.getH2Mode(DatabaseDialectKt.getCurrentDialect()) == H2Dialect.H2CompatibilityMode.Oracle ? JavaDateColumnTypeKt.access$getORACLE_TIME_STRING_FORMATTER().format(value2) : Time.valueOf(value2));
    }

    @Override
    @NotNull
    public String nonNullValueAsDefaultString(@NotNull LocalTime value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialect();
        return databaseDialect instanceof PostgreSQLDialect ? this.nonNullValueToString(value2) + "::time without time zone" : (databaseDialect instanceof MysqlDialect ? '\'' + JavaDateColumnTypeKt.access$getMYSQL_TIME_AS_DEFAULT_STRING_FORMATTER().format(value2) + '\'' : super.nonNullValueAsDefaultString(value2));
    }

    private final LocalTime longToLocalTime(long millis) {
        return Instant.ofEpochMilli(millis).atZone(ZoneId.systemDefault()).toLocalTime();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0005\u001a\u00020\u00048\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/exposed/sql/javatime/JavaLocalTimeColumnType$Companion;", "", "<init>", "()V", "Lorg/jetbrains/exposed/sql/javatime/JavaLocalTimeColumnType;", "INSTANCE", "Lorg/jetbrains/exposed/sql/javatime/JavaLocalTimeColumnType;", "getINSTANCE$exposed_java_time", "()Lorg/jetbrains/exposed/sql/javatime/JavaLocalTimeColumnType;", "exposed-java-time"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JavaLocalTimeColumnType getINSTANCE$exposed_java_time() {
            return INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

