/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.transactions;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.exceptions.ExposedSQLException;
import org.jetbrains.exposed.sql.Database;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.Schema;
import org.jetbrains.exposed.sql.SchemaUtils;
import org.jetbrains.exposed.sql.SqlLogger;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.StatementContext;
import org.jetbrains.exposed.sql.statements.api.PreparedStatementApi;
import org.jetbrains.exposed.sql.transactions.TransactionApiKt;
import org.jetbrains.exposed.sql.transactions.TransactionInterface;
import org.jetbrains.exposed.sql.transactions.TransactionManager;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\u001a8\u0010\u0007\u001a\u00028\u0000\"\u0004\b\u0000\u0010\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00012\u0017\u0010\u0006\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\u0002\b\u0005\u00a2\u0006\u0004\b\u0007\u0010\b\u001aJ\u0010\u0007\u001a\u00028\u0000\"\u0004\b\u0000\u0010\u00002\u0006\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\f\u001a\u00020\u000b2\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00012\u0017\u0010\u0006\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\u0002\b\u0005\u00a2\u0006\u0004\b\u0007\u0010\r\u001aV\u0010\u000f\u001a\u00028\u0000\"\u0004\b\u0000\u0010\u00002\u0006\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\f\u001a\u00020\u000b2\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u00042\u0017\u0010\u0006\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\u0002\b\u0005\u00a2\u0006\u0004\b\u000f\u0010\u0010\u001a/\u0010\u0013\u001a\u00028\u0000\"\u0004\b\u0000\u0010\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00012\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014\u001a'\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\tH\u0000\u00a2\u0006\u0004\b\u0019\u0010\u001a\u001a\u0017\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\u0004H\u0000\u00a2\u0006\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d"}, d2={"T", "Lorg/jetbrains/exposed/sql/Database;", "db", "Lkotlin/Function1;", "Lorg/jetbrains/exposed/sql/Transaction;", "Lkotlin/ExtensionFunctionType;", "statement", "transaction", "(Lorg/jetbrains/exposed/sql/Database;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "", "transactionIsolation", "", "readOnly", "(IZLorg/jetbrains/exposed/sql/Database;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "outerTransaction", "inTopLevelTransaction", "(IZLorg/jetbrains/exposed/sql/Database;Lorg/jetbrains/exposed/sql/Transaction;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "Lkotlin/Function0;", "block", "keepAndRestoreTransactionRefAfterRun", "(Lorg/jetbrains/exposed/sql/Database;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "Ljava/sql/SQLException;", "cause", "attempts", "", "handleSQLException", "(Ljava/sql/SQLException;Lorg/jetbrains/exposed/sql/Transaction;I)V", "closeStatementsAndConnection", "(Lorg/jetbrains/exposed/sql/Transaction;)V", "exposed-core"})
@SourceDebugExtension(value={"SMAP\nThreadLocalTransactionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThreadLocalTransactionManager.kt\norg/jetbrains/exposed/sql/transactions/ThreadLocalTransactionManagerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 TransactionApi.kt\norg/jetbrains/exposed/sql/transactions/TransactionApiKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,447:1\n1863#2:448\n808#2,11:449\n1863#2,2:460\n1864#2:462\n247#3,6:463\n1#4:469\n*S KotlinDebug\n*F\n+ 1 ThreadLocalTransactionManager.kt\norg/jetbrains/exposed/sql/transactions/ThreadLocalTransactionManagerKt\n*L\n420#1:448\n421#1:449,11\n421#1:460,2\n420#1:462\n443#1:463,6\n*E\n"})
public final class ThreadLocalTransactionManagerKt {
    public static final <T> T transaction(@Nullable Database db, @NotNull Function1<? super Transaction, ? extends T> statement) {
        Intrinsics.checkNotNullParameter(statement, (String)"statement");
        return ThreadLocalTransactionManagerKt.transaction(TransactionApiKt.getTransactionManager(db).getDefaultIsolationLevel(), TransactionApiKt.getTransactionManager(db).getDefaultReadOnly(), db, statement);
    }

    public static /* synthetic */ Object transaction$default(Database database, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            database = null;
        }
        return ThreadLocalTransactionManagerKt.transaction(database, function1);
    }

    public static final <T> T transaction(int transactionIsolation, boolean readOnly, @Nullable Database db, @NotNull Function1<? super Transaction, ? extends T> statement) {
        Intrinsics.checkNotNullParameter(statement, (String)"statement");
        return ThreadLocalTransactionManagerKt.keepAndRestoreTransactionRefAfterRun(db, () -> ThreadLocalTransactionManagerKt.transaction$lambda$5(db, transactionIsolation, readOnly, statement));
    }

    public static /* synthetic */ Object transaction$default(int n, boolean bl, Database database, Function1 function1, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        if ((n2 & 4) != 0) {
            database = null;
        }
        return ThreadLocalTransactionManagerKt.transaction(n, bl, database, function1);
    }

    public static final <T> T inTopLevelTransaction(int transactionIsolation, boolean readOnly, @Nullable Database db, @Nullable Transaction outerTransaction, @NotNull Function1<? super Transaction, ? extends T> statement) {
        Intrinsics.checkNotNullParameter(statement, (String)"statement");
        return ThreadLocalTransactionManagerKt.keepAndRestoreTransactionRefAfterRun(db, () -> ThreadLocalTransactionManagerKt.inTopLevelTransaction$lambda$11(outerTransaction, db, transactionIsolation, readOnly, statement));
    }

    public static /* synthetic */ Object inTopLevelTransaction$default(int n, boolean bl, Database database, Transaction transaction, Function1 function1, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        if ((n2 & 4) != 0) {
            database = null;
        }
        if ((n2 & 8) != 0) {
            transaction = null;
        }
        return ThreadLocalTransactionManagerKt.inTopLevelTransaction(n, bl, database, transaction, function1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final <T> T keepAndRestoreTransactionRefAfterRun(Database db, Function0<? extends T> block) {
        Object object;
        TransactionManager manager = TransactionApiKt.getTransactionManager(db);
        Transaction currentTransaction = manager.currentOrNull();
        try {
            object = block.invoke();
        }
        finally {
            manager.bindTransactionToThread(currentTransaction);
        }
        return (T)object;
    }

    static /* synthetic */ Object keepAndRestoreTransactionRefAfterRun$default(Database database, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            database = null;
        }
        return ThreadLocalTransactionManagerKt.keepAndRestoreTransactionRefAfterRun(database, function0);
    }

    /*
     * WARNING - void declaration
     */
    public static final void handleSQLException(@NotNull SQLException cause, @NotNull Transaction transaction, int attempts) {
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        ExposedSQLException exposedSQLException = cause instanceof ExposedSQLException ? (ExposedSQLException)cause : null;
        Object object = exposedSQLException;
        if (object == null || (object = ((ExposedSQLException)object).causedByQueries()) == null || (object = CollectionsKt.joinToString$default((Iterable)((Iterable)object), (CharSequence)";\n", null, null, (int)0, null, null, (int)62, null)) == null) {
            object = String.valueOf(transaction.getCurrentStatement());
        }
        Object queriesToLog = object;
        String message = "Transaction attempt #" + attempts + " failed: " + cause.getMessage() + ". Statement(s): " + (String)queriesToLog;
        Iterable<Throwable> iterable = exposedSQLException;
        if (iterable != null && (iterable = iterable.getContexts()) != null) {
            Iterable $this$forEach$iv = iterable;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$forEach$iv2;
                void $this$filterIsInstanceTo$iv$iv;
                StatementContext it = (StatementContext)element$iv;
                boolean bl = false;
                Iterable $this$filterIsInstance$iv = transaction.getInterceptors$exposed_core();
                boolean $i$f$filterIsInstance = false;
                Iterable iterable2 = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof SqlLogger)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    SqlLogger logger = (SqlLogger)element$iv2;
                    boolean bl2 = false;
                    logger.log(it, transaction);
                }
            }
        }
        SQLLogKt.getExposedLogger().warn(message, (Throwable)cause);
        TransactionApiKt.rollbackLoggingException(transaction, (Function1<? super Exception, Unit>)((Function1)ThreadLocalTransactionManagerKt::handleSQLException$lambda$14));
    }

    public static final void closeStatementsAndConnection(@NotNull Transaction transaction) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        PreparedStatementApi currentStatement = transaction.getCurrentStatement();
        try {
            PreparedStatementApi preparedStatementApi = currentStatement;
            if (preparedStatementApi != null) {
                PreparedStatementApi it = preparedStatementApi;
                boolean bl = false;
                it.closeIfPossible();
                transaction.setCurrentStatement(null);
            }
            transaction.closeExecutedStatements();
        }
        catch (Exception cause) {
            SQLLogKt.getExposedLogger().warn("Statements close failed", (Throwable)cause);
        }
        TransactionInterface $this$closeLoggingException$iv = transaction;
        boolean $i$f$closeLoggingException = false;
        try {
            $this$closeLoggingException$iv.close();
        }
        catch (Exception e$iv) {
            Exception it = e$iv;
            boolean bl = false;
            SQLLogKt.getExposedLogger().warn("Transaction close failed: " + it.getMessage() + ". Statement: " + currentStatement, (Throwable)it);
        }
    }

    private static final Unit transaction$lambda$5$lambda$1(PreparedStatementApi $currentStatement, Exception it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        SQLLogKt.getExposedLogger().warn("Transaction rollback failed: " + it.getMessage() + ". Statement: " + $currentStatement, (Throwable)it);
        return Unit.INSTANCE;
    }

    private static final Unit transaction$lambda$5$lambda$2(PreparedStatementApi $currentStatement, Exception it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        SQLLogKt.getExposedLogger().warn("Transaction rollback failed: " + it.getMessage() + ". Statement: " + $currentStatement, (Throwable)it);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Object transaction$lambda$5(Database $db, int $transactionIsolation, boolean $readOnly, Function1 $statement) {
        Object object;
        block19: {
            block20: {
                Object object2;
                Transaction outer;
                block18: {
                    Object object3;
                    Intrinsics.checkNotNullParameter((Object)$statement, (String)"$statement");
                    outer = TransactionManager.Companion.currentOrNull();
                    if (outer == null || $db != null && !Intrinsics.areEqual((Object)outer.getDb(), (Object)$db)) break block18;
                    TransactionManager outerManager = TransactionApiKt.getTransactionManager(outer.getDb());
                    Transaction transaction = outerManager.newTransaction($transactionIsolation, $readOnly, outer);
                    try {
                        Object it = object3 = $statement.invoke((Object)transaction);
                        boolean bl = false;
                        if (outer.getDb().getUseNestedTransactions()) {
                            transaction.commit();
                        }
                    }
                    catch (SQLException cause) {
                        PreparedStatementApi currentStatement = transaction.getCurrentStatement();
                        TransactionApiKt.rollbackLoggingException(transaction, (Function1<? super Exception, Unit>)((Function1)arg_0 -> ThreadLocalTransactionManagerKt.transaction$lambda$5$lambda$1(currentStatement, arg_0)));
                        throw cause;
                    }
                    catch (Throwable cause) {
                        if (outer.getDb().getUseNestedTransactions()) {
                            PreparedStatementApi currentStatement = transaction.getCurrentStatement();
                            TransactionApiKt.rollbackLoggingException(transaction, (Function1<? super Exception, Unit>)((Function1)arg_0 -> ThreadLocalTransactionManagerKt.transaction$lambda$5$lambda$2(currentStatement, arg_0)));
                        }
                        throw cause;
                    }
                    finally {
                        TransactionManager.Companion.resetCurrent(outerManager);
                    }
                    object = object3;
                    break block19;
                }
                Database database = $db;
                TransactionManager existingForDb = database != null ? TransactionApiKt.getTransactionManager(database) : null;
                object = existingForDb;
                if (object == null || (object = object.currentOrNull()) == null) break block20;
                Object transaction = object;
                boolean bl = false;
                Transaction transaction2 = outer;
                TransactionManager currentManager = TransactionApiKt.getTransactionManager(transaction2 != null ? transaction2.getDb() : null);
                try {
                    TransactionManager.Companion.resetCurrent(existingForDb);
                    Object it = object2 = $statement.invoke(transaction);
                    boolean bl2 = false;
                    if ($db.getUseNestedTransactions()) {
                        ((Transaction)transaction).commit();
                    }
                }
                finally {
                    TransactionManager.Companion.resetCurrent(currentManager);
                }
                Object object4 = object2;
                object = object4;
                if (object4 != null) break block19;
            }
            object = ThreadLocalTransactionManagerKt.inTopLevelTransaction($transactionIsolation, $readOnly, $db, null, $statement);
        }
        return object;
    }

    private static final Unit inTopLevelTransaction$run$lambda$10(PreparedStatementApi $currentStatement, Exception it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        SQLLogKt.getExposedLogger().warn("Transaction rollback failed: " + it.getMessage() + ". Statement: " + $currentStatement, (Throwable)it);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final <T> T inTopLevelTransaction$run(Transaction $outerTransaction, Database $db, int $transactionIsolation, boolean $readOnly, Function1<? super Transaction, ? extends T> $statement) {
        TransactionManager transactionManager;
        int attempts = 0;
        Transaction transaction = $outerTransaction;
        TransactionManager it = transactionManager = TransactionApiKt.getTransactionManager(transaction != null ? transaction.getDb() : null);
        boolean bl = false;
        TransactionManager outerManager = it.currentOrNull() != null ? transactionManager : null;
        long intermediateDelay = 0L;
        Long retryInterval = null;
        while (true) {
            if ($db != null) {
                boolean bl2 = false;
                TransactionManager m = TransactionApiKt.getTransactionManager($db);
                boolean bl3 = false;
                TransactionManager.Companion.resetCurrent(m);
            }
            Transaction transaction2 = TransactionApiKt.getTransactionManager($db).newTransaction($transactionIsolation, $readOnly, $outerTransaction);
            try {
                Schema schema = transaction2.getDb().getConfig().getDefaultSchema();
                if (schema != null) {
                    Schema it2 = schema;
                    boolean bl4 = false;
                    SchemaUtils.setSchema$default(SchemaUtils.INSTANCE, it2, false, 2, null);
                }
                Object answer = $statement.invoke((Object)transaction2);
                transaction2.commit();
                Object bl2 = answer;
                return (T)bl2;
            }
            catch (SQLException cause) {
                ThreadLocalTransactionManagerKt.handleSQLException(cause, transaction2, attempts);
                if (++attempts >= transaction2.getMaxAttempts()) {
                    throw cause;
                }
                if (retryInterval == null) {
                    retryInterval = transaction2.getRetryInterval$exposed_core();
                    intermediateDelay = transaction2.getMinRetryDelay();
                }
                long delay = transaction2.getMinRetryDelay() < transaction2.getMaxRetryDelay() ? ThreadLocalRandom.current().nextLong(intermediateDelay += retryInterval * (long)attempts, intermediateDelay + retryInterval) : (transaction2.getMinRetryDelay() == transaction2.getMaxRetryDelay() ? transaction2.getMinRetryDelay() : 0L);
                SQLLogKt.getExposedLogger().warn("Wait " + delay + " milliseconds before retrying");
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
            catch (Throwable cause) {
                PreparedStatementApi currentStatement = transaction2.getCurrentStatement();
                TransactionApiKt.rollbackLoggingException(transaction2, (Function1<? super Exception, Unit>)((Function1)arg_0 -> ThreadLocalTransactionManagerKt.inTopLevelTransaction$run$lambda$10(currentStatement, arg_0)));
                throw cause;
            }
            finally {
                TransactionManager.Companion.resetCurrent(outerManager);
                ThreadLocalTransactionManagerKt.closeStatementsAndConnection(transaction2);
                continue;
            }
            break;
        }
    }

    private static final Object inTopLevelTransaction$lambda$11(Transaction $outerTransaction, Database $db, int $transactionIsolation, boolean $readOnly, Function1 $statement) {
        Intrinsics.checkNotNullParameter((Object)$statement, (String)"$statement");
        return ThreadLocalTransactionManagerKt.inTopLevelTransaction$run($outerTransaction, $db, $transactionIsolation, $readOnly, $statement);
    }

    private static final Unit handleSQLException$lambda$14(Exception it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        SQLLogKt.getExposedLogger().warn("Transaction rollback failed: " + it.getMessage() + ". See previous log line for statement", (Throwable)it);
        return Unit.INSTANCE;
    }
}

