/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import java.util.Locale;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.vendors.DataTypeProvider;
import org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.H2DataTypeProvider;
import org.jetbrains.exposed.sql.vendors.H2Dialect;
import org.jetbrains.exposed.sql.vendors.H2Kt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\n\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\u0007\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\b\u0010\u0006J\u000f\u0010\t\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\t\u0010\u0006J\u000f\u0010\n\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\n\u0010\u0006J\u000f\u0010\u000b\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u000b\u0010\u0006J\u000f\u0010\f\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\f\u0010\u0006J\u000f\u0010\r\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\r\u0010\u0006J\u000f\u0010\u000e\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u0006J\u000f\u0010\u000f\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0006J\u000f\u0010\u0010\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0006J\u000f\u0010\u0011\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0006J\u0017\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0016\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0006J\u000f\u0010\u0017\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0006J\u000f\u0010\u0018\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0006J\u000f\u0010\u0019\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u0006J\u000f\u0010\u001a\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u0006J\u0017\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u0015J\u000f\u0010\u001c\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u0006J\u0017\u0010 \u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020\u001dH\u0016\u00a2\u0006\u0004\b \u0010!J\u000f\u0010\"\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\"\u0010\u0006J\u000f\u0010#\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b#\u0010\u0006J\u0017\u0010&\u001a\u00020\u00042\u0006\u0010%\u001a\u00020$H\u0016\u00a2\u0006\u0004\b&\u0010'J\u0017\u0010(\u001a\u00020$2\u0006\u0010\u001e\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b(\u0010)J\u000f\u0010*\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b*\u0010\u0006J\u0017\u0010,\u001a\u00020\u00042\u0006\u0010+\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b,\u0010-\u00a8\u0006."}, d2={"Lorg/jetbrains/exposed/sql/vendors/OracleDataTypeProvider;", "Lorg/jetbrains/exposed/sql/vendors/DataTypeProvider;", "<init>", "()V", "", "byteType", "()Ljava/lang/String;", "ubyteType", "shortType", "ushortType", "integerType", "integerAutoincType", "uintegerType", "uintegerAutoincType", "longType", "longAutoincType", "ulongType", "ulongAutoincType", "", "colLength", "varcharType", "(I)Ljava/lang/String;", "textType", "mediumTextType", "largeTextType", "timeType", "binaryType", "length", "uuidType", "Ljava/util/UUID;", "value", "", "uuidToDB", "(Ljava/util/UUID;)Ljava/lang/Object;", "dateTimeType", "booleanType", "", "bool", "booleanToStatementString", "(Z)Ljava/lang/String;", "booleanFromStringToBoolean", "(Ljava/lang/String;)Z", "jsonType", "hexString", "hexToDb", "(Ljava/lang/String;)Ljava/lang/String;", "exposed-core"})
public final class OracleDataTypeProvider
extends DataTypeProvider {
    @NotNull
    public static final OracleDataTypeProvider INSTANCE = new OracleDataTypeProvider();

    private OracleDataTypeProvider() {
    }

    @Override
    @NotNull
    public String byteType() {
        return H2Kt.getH2Mode(DatabaseDialectKt.getCurrentDialect()) == H2Dialect.H2CompatibilityMode.Oracle ? "TINYINT" : "NUMBER(3)";
    }

    @Override
    @NotNull
    public String ubyteType() {
        return "NUMBER(3)";
    }

    @Override
    @NotNull
    public String shortType() {
        return H2Kt.getH2Mode(DatabaseDialectKt.getCurrentDialect()) == H2Dialect.H2CompatibilityMode.Oracle ? "SMALLINT" : "NUMBER(5)";
    }

    @Override
    @NotNull
    public String ushortType() {
        return "NUMBER(5)";
    }

    @Override
    @NotNull
    public String integerType() {
        return H2Kt.getH2Mode(DatabaseDialectKt.getCurrentDialect()) == H2Dialect.H2CompatibilityMode.Oracle ? "INTEGER" : "NUMBER(10)";
    }

    @Override
    @NotNull
    public String integerAutoincType() {
        return this.integerType();
    }

    @Override
    @NotNull
    public String uintegerType() {
        return "NUMBER(10)";
    }

    @Override
    @NotNull
    public String uintegerAutoincType() {
        return "NUMBER(10)";
    }

    @Override
    @NotNull
    public String longType() {
        return "NUMBER(19)";
    }

    @Override
    @NotNull
    public String longAutoincType() {
        return "NUMBER(19)";
    }

    @Override
    @NotNull
    public String ulongType() {
        return "NUMBER(20)";
    }

    @Override
    @NotNull
    public String ulongAutoincType() {
        return "NUMBER(20)";
    }

    @Override
    @NotNull
    public String varcharType(int colLength) {
        return "VARCHAR2(" + colLength + " CHAR)";
    }

    @Override
    @NotNull
    public String textType() {
        return "CLOB";
    }

    @Override
    @NotNull
    public String mediumTextType() {
        return this.textType();
    }

    @Override
    @NotNull
    public String largeTextType() {
        return this.textType();
    }

    @Override
    @NotNull
    public String timeType() {
        return this.dateTimeType();
    }

    @Override
    @NotNull
    public String binaryType() {
        SQLLogKt.getExposedLogger().error("Binary type is unsupported for Oracle. Please use blob column type instead.");
        throw new IllegalStateException("Binary type is unsupported for Oracle. Please use blob column type instead.".toString());
    }

    @Override
    @NotNull
    public String binaryType(int length) {
        return length < 2000 ? "RAW (" + length + ')' : this.binaryType();
    }

    @Override
    @NotNull
    public String uuidType() {
        DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialect();
        H2Dialect h2Dialect = databaseDialect instanceof H2Dialect ? (H2Dialect)databaseDialect : null;
        if ((h2Dialect != null ? h2Dialect.getH2Mode() : null) != H2Dialect.H2CompatibilityMode.Oracle) {
            return "RAW(16)";
        }
        return "UUID";
    }

    @Override
    @NotNull
    public Object uuidToDB(@NotNull UUID value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialect();
        H2Dialect h2Dialect = databaseDialect instanceof H2Dialect ? (H2Dialect)databaseDialect : null;
        return (h2Dialect != null ? h2Dialect.getH2Mode() : null) == H2Dialect.H2CompatibilityMode.Oracle ? H2DataTypeProvider.INSTANCE.uuidToDB(value2) : super.uuidToDB(value2);
    }

    @Override
    @NotNull
    public String dateTimeType() {
        return "TIMESTAMP";
    }

    @Override
    @NotNull
    public String booleanType() {
        return "CHAR(1)";
    }

    @Override
    @NotNull
    public String booleanToStatementString(boolean bool) {
        return bool ? "1" : "0";
    }

    @Override
    public boolean booleanFromStringToBoolean(@NotNull String value2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        try {
            bl = Long.parseLong(value2) != 0L;
        }
        catch (NumberFormatException ex) {
            boolean bl2;
            try {
                String string = value2.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                bl2 = StringsKt.toBooleanStrict((String)string);
            }
            catch (IllegalArgumentException ex2) {
                throw new IllegalStateException(("Unexpected value of type Boolean: " + value2).toString());
            }
            bl = bl2;
        }
        return bl;
    }

    @Override
    @NotNull
    public String jsonType() {
        return "VARCHAR2(4000)";
    }

    @Override
    @NotNull
    public String hexToDb(@NotNull String hexString) {
        Intrinsics.checkNotNullParameter((Object)hexString, (String)"hexString");
        return "HEXTORAW('" + hexString + "')";
    }
}

