/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.ColumnDiff;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ReferenceOption;
import org.jetbrains.exposed.sql.Schema;
import org.jetbrains.exposed.sql.SchemaKt;
import org.jetbrains.exposed.sql.TableKt;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.OracleDataTypeProvider;
import org.jetbrains.exposed.sql.vendors.OracleFunctionProvider;
import org.jetbrains.exposed.sql.vendors.VendorDialect;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b \b\u0016\u0018\u0000 F2\u00020\u0001:\u0001FB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0007\u001a\u00020\u00062\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ/\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ)\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u00142\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u000f\u0010\u001a\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001c\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u001c\u0010\u0019J\u0017\u0010\u001f\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001dH\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u0017\u0010!\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001dH\u0016\u00a2\u0006\u0004\b!\u0010 J\u001f\u0010#\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b#\u0010$J\u0017\u0010(\u001a\u00020'2\u0006\u0010&\u001a\u00020%H\u0016\u00a2\u0006\u0004\b(\u0010)J\u0015\u0010*\u001a\b\u0012\u0004\u0012\u00020\t0\u0014H\u0016\u00a2\u0006\u0004\b*\u0010+R\u001a\u0010,\u001a\u00020\u00068\u0016X\u0096D\u00a2\u0006\f\n\u0004\b,\u0010-\u001a\u0004\b.\u0010/R\u001a\u00100\u001a\u00020\u00068\u0016X\u0096D\u00a2\u0006\f\n\u0004\b0\u0010-\u001a\u0004\b1\u0010/R\u001a\u00102\u001a\u00020'8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b2\u00103\u001a\u0004\b4\u00105R\u001a\u00106\u001a\u00020\u00068\u0016X\u0096D\u00a2\u0006\f\n\u0004\b6\u0010-\u001a\u0004\b7\u0010/R\u001a\u00108\u001a\u00020\u00068\u0016X\u0096D\u00a2\u0006\f\n\u0004\b8\u0010-\u001a\u0004\b9\u0010/R\u001a\u0010:\u001a\u00020\u00068\u0016X\u0096D\u00a2\u0006\f\n\u0004\b:\u0010-\u001a\u0004\b;\u0010/R\u001a\u0010<\u001a\u00020\u00068\u0016X\u0096D\u00a2\u0006\f\n\u0004\b<\u0010-\u001a\u0004\b=\u0010/R\u001a\u0010>\u001a\u00020\u00068\u0016X\u0096D\u00a2\u0006\f\n\u0004\b>\u0010-\u001a\u0004\b?\u0010/R\u001a\u0010@\u001a\u00020\u00068\u0016X\u0096D\u00a2\u0006\f\n\u0004\b@\u0010-\u001a\u0004\bA\u0010/R\u001a\u0010B\u001a\u00020\u00068\u0016X\u0096D\u00a2\u0006\f\n\u0004\bB\u0010-\u001a\u0004\bC\u0010/R\u001a\u0010D\u001a\u00020\u00068\u0016X\u0096D\u00a2\u0006\f\n\u0004\bD\u0010-\u001a\u0004\bE\u0010/\u00a8\u0006G"}, d2={"Lorg/jetbrains/exposed/sql/vendors/OracleDialect;", "Lorg/jetbrains/exposed/sql/vendors/VendorDialect;", "<init>", "()V", "Lorg/jetbrains/exposed/sql/Expression;", "e", "", "isAllowedAsColumnDefault", "(Lorg/jetbrains/exposed/sql/Expression;)Z", "", "tableName", "indexName", "isUnique", "isPartialOrFunctional", "dropIndex", "(Ljava/lang/String;Ljava/lang/String;ZZ)Ljava/lang/String;", "Lorg/jetbrains/exposed/sql/Column;", "column", "Lorg/jetbrains/exposed/sql/ColumnDiff;", "columnDiff", "", "modifyColumn", "(Lorg/jetbrains/exposed/sql/Column;Lorg/jetbrains/exposed/sql/ColumnDiff;)Ljava/util/List;", "name", "createDatabase", "(Ljava/lang/String;)Ljava/lang/String;", "listDatabases", "()Ljava/lang/String;", "dropDatabase", "Lorg/jetbrains/exposed/sql/Schema;", "schema", "setSchema", "(Lorg/jetbrains/exposed/sql/Schema;)Ljava/lang/String;", "createSchema", "cascade", "dropSchema", "(Lorg/jetbrains/exposed/sql/Schema;Z)Ljava/lang/String;", "", "refOption", "Lorg/jetbrains/exposed/sql/ReferenceOption;", "resolveRefOptionFromJdbc", "(I)Lorg/jetbrains/exposed/sql/ReferenceOption;", "sequences", "()Ljava/util/List;", "supportsIfNotExists", "Z", "getSupportsIfNotExists", "()Z", "needsSequenceToAutoInc", "getNeedsSequenceToAutoInc", "defaultReferenceOption", "Lorg/jetbrains/exposed/sql/ReferenceOption;", "getDefaultReferenceOption", "()Lorg/jetbrains/exposed/sql/ReferenceOption;", "needsQuotesWhenSymbolsInNames", "getNeedsQuotesWhenSymbolsInNames", "supportsMultipleGeneratedKeys", "getSupportsMultipleGeneratedKeys", "supportsOnlyIdentifiersInGeneratedKeys", "getSupportsOnlyIdentifiersInGeneratedKeys", "supportsDualTableConcept", "getSupportsDualTableConcept", "supportsOrderByNullsFirstLast", "getSupportsOrderByNullsFirstLast", "supportsOnUpdate", "getSupportsOnUpdate", "supportsSetDefaultReferenceOption", "getSupportsSetDefaultReferenceOption", "supportsRestrictReferenceOption", "getSupportsRestrictReferenceOption", "Companion", "exposed-core"})
@SourceDebugExtension(value={"SMAP\nOracleDialect.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OracleDialect.kt\norg/jetbrains/exposed/sql/vendors/OracleDialect\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,500:1\n1557#2:501\n1628#2,3:502\n1557#2:505\n1628#2,3:506\n*S KotlinDebug\n*F\n+ 1 OracleDialect.kt\norg/jetbrains/exposed/sql/vendors/OracleDialect\n*L\n431#1:501\n431#1:502,3\n436#1:505\n436#1:506,3\n*E\n"})
public class OracleDialect
extends VendorDialect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean supportsIfNotExists;
    private final boolean needsSequenceToAutoInc;
    @NotNull
    private final ReferenceOption defaultReferenceOption = ReferenceOption.NO_ACTION;
    private final boolean needsQuotesWhenSymbolsInNames;
    private final boolean supportsMultipleGeneratedKeys;
    private final boolean supportsOnlyIdentifiersInGeneratedKeys;
    private final boolean supportsDualTableConcept;
    private final boolean supportsOrderByNullsFirstLast;
    private final boolean supportsOnUpdate;
    private final boolean supportsSetDefaultReferenceOption;
    private final boolean supportsRestrictReferenceOption;

    public OracleDialect() {
        super(Companion.getDialectName(), OracleDataTypeProvider.INSTANCE, OracleFunctionProvider.INSTANCE);
        this.needsSequenceToAutoInc = true;
        this.supportsOnlyIdentifiersInGeneratedKeys = true;
        this.supportsDualTableConcept = true;
        this.supportsOrderByNullsFirstLast = true;
    }

    @Override
    public boolean getSupportsIfNotExists() {
        return this.supportsIfNotExists;
    }

    @Override
    public boolean getNeedsSequenceToAutoInc() {
        return this.needsSequenceToAutoInc;
    }

    @Override
    @NotNull
    public ReferenceOption getDefaultReferenceOption() {
        return this.defaultReferenceOption;
    }

    @Override
    public boolean getNeedsQuotesWhenSymbolsInNames() {
        return this.needsQuotesWhenSymbolsInNames;
    }

    @Override
    public boolean getSupportsMultipleGeneratedKeys() {
        return this.supportsMultipleGeneratedKeys;
    }

    @Override
    public boolean getSupportsOnlyIdentifiersInGeneratedKeys() {
        return this.supportsOnlyIdentifiersInGeneratedKeys;
    }

    @Override
    public boolean getSupportsDualTableConcept() {
        return this.supportsDualTableConcept;
    }

    @Override
    public boolean getSupportsOrderByNullsFirstLast() {
        return this.supportsOrderByNullsFirstLast;
    }

    @Override
    public boolean getSupportsOnUpdate() {
        return this.supportsOnUpdate;
    }

    @Override
    public boolean getSupportsSetDefaultReferenceOption() {
        return this.supportsSetDefaultReferenceOption;
    }

    @Override
    public boolean getSupportsRestrictReferenceOption() {
        return this.supportsRestrictReferenceOption;
    }

    @Override
    public boolean isAllowedAsColumnDefault(@NotNull Expression<?> e) {
        Intrinsics.checkNotNullParameter(e, (String)"e");
        return true;
    }

    @Override
    @NotNull
    public String dropIndex(@NotNull String tableName, @NotNull String indexName, boolean isUnique, boolean isPartialOrFunctional) {
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        Intrinsics.checkNotNullParameter((Object)indexName, (String)"indexName");
        return "DROP INDEX " + this.getIdentifierManager().quoteIfNecessary(indexName);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> modifyColumn(@NotNull Column<?> column, @NotNull ColumnDiff columnDiff) {
        List list2;
        Collection collection;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Intrinsics.checkNotNullParameter((Object)columnDiff, (String)"columnDiff");
        Iterable $this$map$iv = super.modifyColumn(column, columnDiff);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StringsKt.replace$default((String)it, (String)"MODIFY COLUMN", (String)"MODIFY", (boolean)false, (int)4, null));
        }
        List result = (List)destination$iv$iv;
        if (!columnDiff.getNullability()) {
            void $this$mapTo$iv$iv2;
            String nullableState = column.getColumnType().getNullable() ? "NULL " : "NOT NULL";
            Iterable $this$map$iv2 = result;
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                String bl = (String)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(StringsKt.replace$default((String)it, (String)nullableState, (String)"", (boolean)false, (int)4, null));
            }
            list2 = (List)destination$iv$iv2;
        } else {
            list2 = result;
        }
        return list2;
    }

    @Override
    @NotNull
    public String createDatabase(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return "CREATE DATABASE " + DatabaseDialectKt.inProperCase(name);
    }

    @Override
    @NotNull
    public String listDatabases() {
        throw new IllegalStateException("This operation is not supported by Oracle dialect".toString());
    }

    @Override
    @NotNull
    public String dropDatabase(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return "DROP DATABASE";
    }

    @Override
    @NotNull
    public String setSchema(@NotNull Schema schema) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        return "ALTER SESSION SET CURRENT_SCHEMA = " + schema.getIdentifier();
    }

    @Override
    @NotNull
    public String createSchema(@NotNull Schema schema) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        StringBuilder $this$createSchema_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (schema.getQuota() == null ^ schema.getOn() == null) {
            throw new IllegalArgumentException("You must either provide both <quota> and <on> options or non of them");
        }
        String[] stringArray = new String[]{"CREATE USER ", schema.getIdentifier()};
        StringsKt.append((StringBuilder)$this$createSchema_u24lambda_u242, (String[])stringArray);
        stringArray = new String[]{" IDENTIFIED BY ", schema.getPassword()};
        StringsKt.append((StringBuilder)$this$createSchema_u24lambda_u242, (String[])stringArray);
        SchemaKt.appendIfNotNull($this$createSchema_u24lambda_u242, " DEFAULT TABLESPACE ", schema.getDefaultTablespace());
        SchemaKt.appendIfNotNull($this$createSchema_u24lambda_u242, " TEMPORARY TABLESPACE ", schema.getTemporaryTablespace());
        SchemaKt.appendIfNotNull($this$createSchema_u24lambda_u242, " QUOTA ", schema.getQuota());
        SchemaKt.appendIfNotNull($this$createSchema_u24lambda_u242, " ON ", schema.getOn());
        return stringBuilder.toString();
    }

    @Override
    @NotNull
    public String dropSchema(@NotNull Schema schema, boolean cascade) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        StringBuilder $this$dropSchema_u24lambda_u243 = stringBuilder = new StringBuilder();
        boolean bl = false;
        String[] stringArray = new String[]{"DROP USER ", schema.getIdentifier()};
        StringsKt.append((StringBuilder)$this$dropSchema_u24lambda_u243, (String[])stringArray);
        if (cascade) {
            $this$dropSchema_u24lambda_u243.append(" CASCADE");
        }
        return stringBuilder.toString();
    }

    @Override
    @NotNull
    public ReferenceOption resolveRefOptionFromJdbc(int refOption) {
        ReferenceOption referenceOption;
        switch (refOption) {
            case 0: {
                referenceOption = ReferenceOption.CASCADE;
                break;
            }
            case 2: {
                referenceOption = ReferenceOption.SET_NULL;
                break;
            }
            case 1: {
                referenceOption = ReferenceOption.NO_ACTION;
                break;
            }
            default: {
                referenceOption = DatabaseDialectKt.getCurrentDialect().getDefaultReferenceOption();
            }
        }
        return referenceOption;
    }

    @Override
    @NotNull
    public List<String> sequences() {
        List sequences = new ArrayList();
        Transaction.exec$default(TransactionManager.Companion.current(), "SELECT SEQUENCE_NAME FROM USER_SEQUENCES", null, null, arg_0 -> OracleDialect.sequences$lambda$4(sequences, arg_0), 6, null);
        return sequences;
    }

    private static final Unit sequences$lambda$4(List $sequences, ResultSet rs) {
        Intrinsics.checkNotNullParameter((Object)$sequences, (String)"$sequences");
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        while (rs.next()) {
            String result = rs.getString("SEQUENCE_NAME");
            Intrinsics.checkNotNull((Object)result);
            String q = StringsKt.contains$default((CharSequence)result, (char)'.', (boolean)false, (int)2, null) && !TableKt.isAlreadyQuoted(result) ? "\"" : "";
            String sequenceName = q + result + q;
            $sequences.add(sequenceName);
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/exposed/sql/vendors/OracleDialect$Companion;", "Lorg/jetbrains/exposed/sql/vendors/VendorDialect$DialectNameProvider;", "<init>", "()V", "exposed-core"})
    public static final class Companion
    extends VendorDialect.DialectNameProvider {
        private Companion() {
            super("Oracle");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

