/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.Index;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.SQLiteDataTypeProvider;
import org.jetbrains.exposed.sql.vendors.SQLiteFunctionProvider;
import org.jetbrains.exposed.sql.vendors.VendorDialect;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u001a\b\u0016\u0018\u0000 $2\u00020\u0001:\u0001$B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0007\u001a\u00020\u00062\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ/\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0017\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0019\u0010\u0016R\u001a\u0010\u001a\u001a\u00020\u00068\u0016X\u0096D\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u00068\u0016X\u0096D\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001b\u001a\u0004\b\u001f\u0010\u001dR\u001a\u0010 \u001a\u00020\u00068\u0016X\u0096D\u00a2\u0006\f\n\u0004\b \u0010\u001b\u001a\u0004\b!\u0010\u001dR\u001a\u0010\"\u001a\u00020\u00068\u0016X\u0096D\u00a2\u0006\f\n\u0004\b\"\u0010\u001b\u001a\u0004\b#\u0010\u001d\u00a8\u0006%"}, d2={"Lorg/jetbrains/exposed/sql/vendors/SQLiteDialect;", "Lorg/jetbrains/exposed/sql/vendors/VendorDialect;", "<init>", "()V", "Lorg/jetbrains/exposed/sql/Expression;", "e", "", "isAllowedAsColumnDefault", "(Lorg/jetbrains/exposed/sql/Expression;)Z", "Lorg/jetbrains/exposed/sql/Index;", "index", "", "createIndex", "(Lorg/jetbrains/exposed/sql/Index;)Ljava/lang/String;", "tableName", "indexName", "isUnique", "isPartialOrFunctional", "dropIndex", "(Ljava/lang/String;Ljava/lang/String;ZZ)Ljava/lang/String;", "name", "createDatabase", "(Ljava/lang/String;)Ljava/lang/String;", "listDatabases", "()Ljava/lang/String;", "dropDatabase", "supportsCreateSequence", "Z", "getSupportsCreateSequence", "()Z", "supportsMultipleGeneratedKeys", "getSupportsMultipleGeneratedKeys", "supportsCreateSchema", "getSupportsCreateSchema", "supportsWindowFrameGroupsMode", "getSupportsWindowFrameGroupsMode", "Companion", "exposed-core"})
public class SQLiteDialect
extends VendorDialect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean supportsCreateSequence;
    private final boolean supportsMultipleGeneratedKeys;
    private final boolean supportsCreateSchema;
    private final boolean supportsWindowFrameGroupsMode;
    @NotNull
    private static final Lazy<Boolean> ENABLE_UPDATE_DELETE_LIMIT$delegate = LazyKt.lazy(SQLiteDialect::ENABLE_UPDATE_DELETE_LIMIT_delegate$lambda$1);

    public SQLiteDialect() {
        super(Companion.getDialectName(), SQLiteDataTypeProvider.INSTANCE, SQLiteFunctionProvider.INSTANCE);
        this.supportsWindowFrameGroupsMode = true;
    }

    @Override
    public boolean getSupportsCreateSequence() {
        return this.supportsCreateSequence;
    }

    @Override
    public boolean getSupportsMultipleGeneratedKeys() {
        return this.supportsMultipleGeneratedKeys;
    }

    @Override
    public boolean getSupportsCreateSchema() {
        return this.supportsCreateSchema;
    }

    @Override
    public boolean getSupportsWindowFrameGroupsMode() {
        return this.supportsWindowFrameGroupsMode;
    }

    @Override
    public boolean isAllowedAsColumnDefault(@NotNull Expression<?> e) {
        Intrinsics.checkNotNullParameter(e, (String)"e");
        return true;
    }

    @Override
    @NotNull
    public String createIndex(@NotNull Index index) {
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        if (index.getIndexType() != null) {
            SQLLogKt.getExposedLogger().warn("Index of type " + index.getIndexType() + " on " + index.getTable().getTableName() + " for " + CollectionsKt.joinToString$default((Iterable)index.getColumns(), null, null, null, (int)0, null, SQLiteDialect::createIndex$lambda$0, (int)31, null) + " can't be created in SQLite");
            return "";
        }
        String originalCreateIndex = super.createIndex(Index.copy$default(index, null, false, null, null, null, null, null, 125, null));
        return index.getUnique() ? StringsKt.replace$default((String)originalCreateIndex, (String)"CREATE INDEX", (String)"CREATE UNIQUE INDEX", (boolean)false, (int)4, null) : originalCreateIndex;
    }

    @Override
    @NotNull
    public String dropIndex(@NotNull String tableName, @NotNull String indexName, boolean isUnique, boolean isPartialOrFunctional) {
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        Intrinsics.checkNotNullParameter((Object)indexName, (String)"indexName");
        return "DROP INDEX IF EXISTS " + this.getIdentifierManager().quoteIfNecessary(indexName);
    }

    @Override
    @NotNull
    public String createDatabase(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        StringBuilder stringBuilder = new StringBuilder().append("ATTACH DATABASE '");
        String string = name.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return stringBuilder.append(string).append(".db' AS ").append(DatabaseDialectKt.inProperCase(name)).toString();
    }

    @Override
    @NotNull
    public String listDatabases() {
        return "SELECT name FROM pragma_database_list";
    }

    @Override
    @NotNull
    public String dropDatabase(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return "DETACH DATABASE " + DatabaseDialectKt.inProperCase(name);
    }

    private static final CharSequence createIndex$lambda$0(Column it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean ENABLE_UPDATE_DELETE_LIMIT_delegate$lambda$1() {
        boolean bl;
        block8: {
            Connection conn = null;
            Statement stmt = null;
            ResultSet rs = null;
            try {
                Connection connection = conn = DriverManager.getConnection("jdbc:sqlite::memory:");
                Intrinsics.checkNotNull((Object)connection);
                Statement statement = stmt = connection.createStatement();
                Intrinsics.checkNotNull((Object)statement);
                ResultSet resultSet = rs = statement.executeQuery("SELECT sqlite_compileoption_used(\"ENABLE_UPDATE_DELETE_LIMIT\");");
                Intrinsics.checkNotNull((Object)resultSet);
                bl = resultSet.next() ? rs.getBoolean(1) : false;
                rs.close();
            }
            catch (Exception e) {
                bl = false;
                break block8;
            }
            finally {
                ResultSet resultSet = rs;
                if (resultSet != null) {
                    resultSet.close();
                }
                Statement statement = stmt;
                if (statement != null) {
                    statement.close();
                }
                Connection connection = conn;
                if (connection != null) {
                    connection.close();
                }
            }
            stmt.close();
            conn.close();
        }
        return bl;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001b\u0010\t\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\n"}, d2={"Lorg/jetbrains/exposed/sql/vendors/SQLiteDialect$Companion;", "Lorg/jetbrains/exposed/sql/vendors/VendorDialect$DialectNameProvider;", "<init>", "()V", "", "ENABLE_UPDATE_DELETE_LIMIT$delegate", "Lkotlin/Lazy;", "getENABLE_UPDATE_DELETE_LIMIT", "()Z", "ENABLE_UPDATE_DELETE_LIMIT", "exposed-core"})
    public static final class Companion
    extends VendorDialect.DialectNameProvider {
        private Companion() {
            super("SQLite");
        }

        public final boolean getENABLE_UPDATE_DELETE_LIMIT() {
            Lazy lazy2 = ENABLE_UPDATE_DELETE_LIMIT$delegate;
            return (Boolean)lazy2.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

