/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.ColumnDiff;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ExpressionWithColumnType;
import org.jetbrains.exposed.sql.ForeignKeyConstraint;
import org.jetbrains.exposed.sql.Function;
import org.jetbrains.exposed.sql.Index;
import org.jetbrains.exposed.sql.LiteralOp;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.QueryBuilder;
import org.jetbrains.exposed.sql.ReferenceOption;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.Schema;
import org.jetbrains.exposed.sql.Sequence;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.api.ExposedConnection;
import org.jetbrains.exposed.sql.statements.api.ExposedDatabaseMetadata;
import org.jetbrains.exposed.sql.statements.api.IdentifierManagerApi;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.ColumnMetadata;
import org.jetbrains.exposed.sql.vendors.DataTypeProvider;
import org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.FunctionProvider;
import org.jetbrains.exposed.sql.vendors.MysqlDialect;
import org.jetbrains.exposed.sql.vendors.OracleDialect;
import org.jetbrains.exposed.sql.vendors.PostgreSQLDialect;
import org.jetbrains.exposed.sql.vendors.PrimaryKeyMetadata;
import org.jetbrains.exposed.sql.vendors.SQLServerDialect;
import org.jetbrains.exposed.sql.vendors.SQLiteDialect;
import org.jetbrains.exposed.sql.vendors.SchemaMetadata;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010%\n\u0002\u0010\u001e\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001:\u0001uB\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ!\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000b0\nH\u0004\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u000fJ\u0015\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0013\u0010\u000fJ\u0017\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J#\u0010\u001a\u001a\u00020\u0016*\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0014H\u0014\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001cH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0017\u0010!\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u001fH\u0016\u00a2\u0006\u0004\b!\u0010\"J5\u0010&\u001a\u0014\u0012\u0004\u0012\u00020\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020%0\u000b0\n2\u0012\u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140#\"\u00020\u0014H\u0016\u00a2\u0006\u0004\b&\u0010'JY\u0010-\u001a8\u0012(\u0012&\u0012\u0004\u0012\u00020\u0014\u0012\u001c\u0012\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030*0)j\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030*`+0(\u0012\n\u0012\b\u0012\u0004\u0012\u00020,0\u000b0\n2\u0012\u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140#\"\u00020\u0014H\u0016\u00a2\u0006\u0004\b-\u0010'J5\u0010/\u001a\u0014\u0012\u0004\u0012\u00020\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020.0\u000b0\n2\u0012\u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140#\"\u00020\u0014H\u0016\u00a2\u0006\u0004\b/\u0010'J1\u00101\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0006\u0012\u0004\u0018\u0001000\n2\u0012\u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140#\"\u00020\u0014H\u0016\u00a2\u0006\u0004\b1\u0010'J\u0015\u00102\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bH\u0016\u00a2\u0006\u0004\b2\u0010\u000fJ\u000f\u00103\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b3\u00104J\u001b\u00107\u001a\u00020\u0002*\u00020\u00022\u0006\u00106\u001a\u000205H\u0004\u00a2\u0006\u0004\b7\u00108J\u001d\u0010:\u001a\u0002092\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00140\u000bH\u0014\u00a2\u0006\u0004\b:\u0010;J\u000f\u0010<\u001a\u000209H\u0016\u00a2\u0006\u0004\b<\u0010=J\u000f\u0010>\u001a\u000209H\u0016\u00a2\u0006\u0004\b>\u0010=J\u0017\u0010@\u001a\u0004\u0018\u00010\u00022\u0006\u0010?\u001a\u00020.\u00a2\u0006\u0004\b@\u0010AJ\u001b\u0010D\u001a\u00020\u00022\n\u0010C\u001a\u0006\u0012\u0002\b\u00030BH\u0002\u00a2\u0006\u0004\bD\u0010EJ\u0017\u0010F\u001a\u00020\u00022\u0006\u0010?\u001a\u00020.H\u0016\u00a2\u0006\u0004\bF\u0010AJ7\u0010I\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010G\u001a\u00020\u00022\u0006\u0010H\u001a\u00020\u00022\u0006\u0010@\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\bI\u0010JJ/\u0010O\u001a\u00020\u00022\u0006\u0010K\u001a\u00020\u00022\u0006\u0010L\u001a\u00020\u00022\u0006\u0010M\u001a\u00020\u00162\u0006\u0010N\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\bO\u0010PJ)\u0010T\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b2\n\u0010Q\u001a\u0006\u0012\u0002\b\u00030*2\u0006\u0010S\u001a\u00020RH\u0016\u00a2\u0006\u0004\bT\u0010UJ=\u0010X\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00142\b\u0010V\u001a\u0004\u0018\u00010\u00022\u001a\u0010W\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030*0#\"\u0006\u0012\u0002\b\u00030*H\u0016\u00a2\u0006\u0004\bX\u0010YR\u001a\u0010\u0003\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010Z\u001a\u0004\b[\u0010\u0011R\u001a\u0010\u0005\u001a\u00020\u00048\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\\\u001a\u0004\b]\u0010^R\u001a\u0010\u0007\u001a\u00020\u00068\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010_\u001a\u0004\b`\u0010aR\u0014\u0010e\u001a\u00020b8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\bc\u0010dR*\u0010f\u001a\u0016\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000b\u0018\u00010\n8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bf\u0010gR\u001e\u0010h\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u000b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bh\u0010iR\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\bj\u0010\u000fR\u001a\u0010k\u001a\u00020\u00168\u0016X\u0096D\u00a2\u0006\f\n\u0004\bk\u0010l\u001a\u0004\bm\u00104R\u001b\u00103\u001a\u00020\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bn\u0010o\u001a\u0004\bp\u00104R,\u0010s\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020,0r0q8\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\bs\u0010g\u001a\u0004\bt\u0010\r\u00a8\u0006v"}, d2={"Lorg/jetbrains/exposed/sql/vendors/VendorDialect;", "Lorg/jetbrains/exposed/sql/vendors/DatabaseDialect;", "", "name", "Lorg/jetbrains/exposed/sql/vendors/DataTypeProvider;", "dataTypeProvider", "Lorg/jetbrains/exposed/sql/vendors/FunctionProvider;", "functionProvider", "<init>", "(Ljava/lang/String;Lorg/jetbrains/exposed/sql/vendors/DataTypeProvider;Lorg/jetbrains/exposed/sql/vendors/FunctionProvider;)V", "", "", "getAllTableNamesCache", "()Ljava/util/Map;", "getAllSchemaNamesCache", "()Ljava/util/List;", "getDatabase", "()Ljava/lang/String;", "allTablesNames", "allTablesNamesInAllSchemas", "Lorg/jetbrains/exposed/sql/Table;", "table", "", "tableExists", "(Lorg/jetbrains/exposed/sql/Table;)Z", "schema", "metadataMatchesTable", "(Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/exposed/sql/Table;)Z", "Lorg/jetbrains/exposed/sql/Schema;", "schemaExists", "(Lorg/jetbrains/exposed/sql/Schema;)Z", "Lorg/jetbrains/exposed/sql/Sequence;", "sequence", "sequenceExists", "(Lorg/jetbrains/exposed/sql/Sequence;)Z", "", "tables", "Lorg/jetbrains/exposed/sql/vendors/ColumnMetadata;", "tableColumns", "([Lorg/jetbrains/exposed/sql/Table;)Ljava/util/Map;", "Lkotlin/Pair;", "Ljava/util/LinkedHashSet;", "Lorg/jetbrains/exposed/sql/Column;", "Lkotlin/collections/LinkedHashSet;", "Lorg/jetbrains/exposed/sql/ForeignKeyConstraint;", "columnConstraints", "Lorg/jetbrains/exposed/sql/Index;", "existingIndices", "Lorg/jetbrains/exposed/sql/vendors/PrimaryKeyMetadata;", "existingPrimaryKeys", "sequences", "supportsSelectForUpdate", "()Z", "Lorg/jetbrains/exposed/sql/Transaction;", "tr", "quoteIdentifierWhenWrongCaseOrNecessary", "(Ljava/lang/String;Lorg/jetbrains/exposed/sql/Transaction;)Ljava/lang/String;", "", "fillConstraintCacheForTables", "(Ljava/util/List;)V", "resetCaches", "()V", "resetSchemaCaches", "index", "filterCondition", "(Lorg/jetbrains/exposed/sql/Index;)Ljava/lang/String;", "Lorg/jetbrains/exposed/sql/Function;", "function", "indexFunctionToString", "(Lorg/jetbrains/exposed/sql/Function;)Ljava/lang/String;", "createIndex", "columns", "type", "createIndexWithType", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "tableName", "indexName", "isUnique", "isPartialOrFunctional", "dropIndex", "(Ljava/lang/String;Ljava/lang/String;ZZ)Ljava/lang/String;", "column", "Lorg/jetbrains/exposed/sql/ColumnDiff;", "columnDiff", "modifyColumn", "(Lorg/jetbrains/exposed/sql/Column;Lorg/jetbrains/exposed/sql/ColumnDiff;)Ljava/util/List;", "pkName", "pkColumns", "addPrimaryKey", "(Lorg/jetbrains/exposed/sql/Table;Ljava/lang/String;[Lorg/jetbrains/exposed/sql/Column;)Ljava/lang/String;", "Ljava/lang/String;", "getName", "Lorg/jetbrains/exposed/sql/vendors/DataTypeProvider;", "getDataTypeProvider", "()Lorg/jetbrains/exposed/sql/vendors/DataTypeProvider;", "Lorg/jetbrains/exposed/sql/vendors/FunctionProvider;", "getFunctionProvider", "()Lorg/jetbrains/exposed/sql/vendors/FunctionProvider;", "Lorg/jetbrains/exposed/sql/statements/api/IdentifierManagerApi;", "getIdentifierManager", "()Lorg/jetbrains/exposed/sql/statements/api/IdentifierManagerApi;", "identifierManager", "_allTableNames", "Ljava/util/Map;", "_allSchemaNames", "Ljava/util/List;", "getAllTablesNames", "supportsMultipleGeneratedKeys", "Z", "getSupportsMultipleGeneratedKeys", "supportsSelectForUpdate$delegate", "Lkotlin/Lazy;", "getSupportsSelectForUpdate", "", "", "columnConstraintsCache", "getColumnConstraintsCache", "DialectNameProvider", "exposed-core"})
@SourceDebugExtension(value={"SMAP\nVendorDialect.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VendorDialect.kt\norg/jetbrains/exposed/sql/vendors/VendorDialect\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,255:1\n1368#2:256\n1454#2,5:257\n1755#2,3:262\n1755#2,3:265\n1755#2,3:268\n1755#2,3:271\n1863#2:278\n1864#2:286\n3829#3:274\n4344#3,2:275\n13402#3:277\n13403#3:287\n381#4,7:279\n1#5:288\n*S KotlinDebug\n*F\n+ 1 VendorDialect.kt\norg/jetbrains/exposed/sql/vendors/VendorDialect\n*L\n68#1:256\n68#1:257,5\n74#1:262,3\n81#1:265,3\n100#1:268,3\n104#1:271,3\n119#1:278\n119#1:286\n115#1:274\n115#1:275,2\n118#1:277\n118#1:287\n120#1:279,7\n*E\n"})
public abstract class VendorDialect
implements DatabaseDialect {
    @NotNull
    private final String name;
    @NotNull
    private final DataTypeProvider dataTypeProvider;
    @NotNull
    private final FunctionProvider functionProvider;
    @Nullable
    private Map<String, ? extends List<String>> _allTableNames;
    @Nullable
    private List<String> _allSchemaNames;
    private final boolean supportsMultipleGeneratedKeys;
    @NotNull
    private final Lazy supportsSelectForUpdate$delegate;
    @NotNull
    private final Map<String, Collection<ForeignKeyConstraint>> columnConstraintsCache;

    public VendorDialect(@NotNull String name, @NotNull DataTypeProvider dataTypeProvider, @NotNull FunctionProvider functionProvider) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)dataTypeProvider, (String)"dataTypeProvider");
        Intrinsics.checkNotNullParameter((Object)functionProvider, (String)"functionProvider");
        this.name = name;
        this.dataTypeProvider = dataTypeProvider;
        this.functionProvider = functionProvider;
        this.supportsMultipleGeneratedKeys = true;
        this.supportsSelectForUpdate$delegate = LazyKt.lazy(VendorDialect::supportsSelectForUpdate_delegate$lambda$21);
        this.columnConstraintsCache = new ConcurrentHashMap();
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public DataTypeProvider getDataTypeProvider() {
        return this.dataTypeProvider;
    }

    @Override
    @NotNull
    public FunctionProvider getFunctionProvider() {
        return this.functionProvider;
    }

    @NotNull
    protected final IdentifierManagerApi getIdentifierManager() {
        return TransactionManager.Companion.current().getDb().getIdentifierManager();
    }

    @NotNull
    public final List<String> getAllTablesNames() {
        ExposedConnection<?> connection = TransactionManager.Companion.current().getConnection();
        return (List)connection.metadata(arg_0 -> VendorDialect._get_allTablesNames_$lambda$0(this, arg_0));
    }

    @NotNull
    protected final Map<String, List<String>> getAllTableNamesCache() {
        if (this._allTableNames == null) {
            this._allTableNames = (Map)TransactionManager.Companion.current().getConnection().metadata(VendorDialect::getAllTableNamesCache$lambda$1);
        }
        Map<String, List<String>> map2 = this._allTableNames;
        Intrinsics.checkNotNull(map2);
        return map2;
    }

    private final List<String> getAllSchemaNamesCache() {
        if (this._allSchemaNames == null) {
            this._allSchemaNames = (List)TransactionManager.Companion.current().getConnection().metadata(VendorDialect::getAllSchemaNamesCache$lambda$2);
        }
        List<String> list2 = this._allSchemaNames;
        Intrinsics.checkNotNull(list2);
        return list2;
    }

    @Override
    public boolean getSupportsMultipleGeneratedKeys() {
        return this.supportsMultipleGeneratedKeys;
    }

    @Override
    @NotNull
    public String getDatabase() {
        return this.catalog(TransactionManager.Companion.current());
    }

    @Override
    @NotNull
    public List<String> allTablesNames() {
        return (List)TransactionManager.Companion.current().getConnection().metadata(VendorDialect::allTablesNames$lambda$3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> allTablesNamesInAllSchemas() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.getAllSchemaNamesCache();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String schema = (String)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = (Iterable)MapsKt.getValue(this.getAllTableNamesCache(), (Object)schema);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    public boolean tableExists(@NotNull Table table) {
        boolean bl;
        block8: {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            String string = table.getSchemaName();
            if (string != null) {
                String schema = string;
                boolean bl2 = false;
                Iterable $this$any$iv = (Iterable)MapsKt.getValue(this.getAllTableNamesCache(), (Object)DatabaseDialectKt.inProperCase(schema));
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it, (Object)table.nameInDatabaseCase())) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            } else {
                VendorDialect $this$tableExists_u24lambda_u249 = this;
                boolean bl4 = false;
                SchemaMetadata schemaMetadata = (SchemaMetadata)TransactionManager.Companion.current().getConnection().metadata(arg_0 -> VendorDialect.tableExists$lambda$9$lambda$7($this$tableExists_u24lambda_u249, arg_0));
                String schema = schemaMetadata.component1();
                List<String> allTables = schemaMetadata.component2();
                Iterable $this$any$iv = allTables;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl5 = false;
                        if (!$this$tableExists_u24lambda_u249.metadataMatchesTable(it, schema, table)) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
        }
        return bl;
    }

    protected boolean metadataMatchesTable(@NotNull String $this$metadataMatchesTable, @NotNull String schema, @NotNull Table table) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$metadataMatchesTable, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        if (((CharSequence)schema).length() == 0) {
            bl = Intrinsics.areEqual((Object)$this$metadataMatchesTable, (Object)table.nameInDatabaseCaseUnquoted());
        } else {
            String sanitizedTableName = table.getTableNameWithoutSchemeSanitized$exposed_core();
            String nameInDb = DatabaseDialectKt.inProperCase(schema + '.' + sanitizedTableName);
            bl = Intrinsics.areEqual((Object)$this$metadataMatchesTable, (Object)nameInDb);
        }
        return bl;
    }

    @Override
    public boolean schemaExists(@NotNull Schema schema) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            List<String> allSchemas = this.getAllSchemaNamesCache();
            Iterable $this$any$iv = allSchemas;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it, (Object)DatabaseDialectKt.inProperCase(schema.getIdentifier()))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public boolean sequenceExists(@NotNull Sequence sequence) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)sequence, (String)"sequence");
            Iterable $this$any$iv = this.sequences();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it, (Object)DatabaseDialectKt.inProperCase(sequence.getIdentifier()))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public Map<Table, List<ColumnMetadata>> tableColumns(Table ... tables) {
        Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
        return (Map)TransactionManager.Companion.current().getConnection().metadata(arg_0 -> VendorDialect.tableColumns$lambda$12(tables, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<Pair<Table, LinkedHashSet<Column<?>>>, List<ForeignKeyConstraint>> columnConstraints(Table ... tables) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
        HashMap constraints = new HashMap();
        Table[] $this$filter$iv = tables;
        boolean $i$f$filter = false;
        Table[] tableArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Iterable element$iv$iv : $this$filterTo$iv$iv) {
            void it = element$iv$iv;
            boolean bl = false;
            if (!(!this.columnConstraintsCache.containsKey(it.nameInDatabaseCaseUnquoted()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List tablesToLoad = (List)destination$iv$iv;
        this.fillConstraintCacheForTables(tablesToLoad);
        Table[] $this$forEach$iv = tables;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            void $this$forEach$iv2;
            Table element$iv;
            Iterable element$iv$iv;
            Table table = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            Collection collection = this.columnConstraintsCache.get(table.nameInDatabaseCaseUnquoted());
            if (collection == null) {
                collection = CollectionsKt.emptyList();
            }
            element$iv$iv = collection;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Object object;
                void $this$getOrPut$iv;
                ForeignKeyConstraint it = (ForeignKeyConstraint)element$iv2;
                boolean bl2 = false;
                Map map2 = constraints;
                Pair key$iv = TuplesKt.to((Object)table, it.getFrom());
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl3 = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((List)object).add(it);
            }
        }
        return constraints;
    }

    @Override
    @NotNull
    public Map<Table, List<Index>> existingIndices(Table ... tables) {
        Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
        return (Map)TransactionManager.Companion.current().getDb().metadata$exposed_core(arg_0 -> VendorDialect.existingIndices$lambda$17(tables, arg_0));
    }

    @Override
    @NotNull
    public Map<Table, PrimaryKeyMetadata> existingPrimaryKeys(Table ... tables) {
        Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
        return (Map)TransactionManager.Companion.current().getDb().metadata$exposed_core(arg_0 -> VendorDialect.existingPrimaryKeys$lambda$18(tables, arg_0));
    }

    @Override
    @NotNull
    public List<String> sequences() {
        return (List)TransactionManager.Companion.current().getDb().metadata$exposed_core(VendorDialect::sequences$lambda$19);
    }

    private final boolean getSupportsSelectForUpdate() {
        Lazy lazy2 = this.supportsSelectForUpdate$delegate;
        return (Boolean)lazy2.getValue();
    }

    @Override
    public boolean supportsSelectForUpdate() {
        return this.getSupportsSelectForUpdate();
    }

    @NotNull
    protected final String quoteIdentifierWhenWrongCaseOrNecessary(@NotNull String $this$quoteIdentifierWhenWrongCaseOrNecessary, @NotNull Transaction tr) {
        Intrinsics.checkNotNullParameter((Object)$this$quoteIdentifierWhenWrongCaseOrNecessary, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)tr, (String)"tr");
        return tr.getDb().getIdentifierManager().quoteIdentifierWhenWrongCaseOrNecessary($this$quoteIdentifierWhenWrongCaseOrNecessary);
    }

    @NotNull
    protected final Map<String, Collection<ForeignKeyConstraint>> getColumnConstraintsCache() {
        return this.columnConstraintsCache;
    }

    protected void fillConstraintCacheForTables(@NotNull List<? extends Table> tables) {
        Intrinsics.checkNotNullParameter(tables, (String)"tables");
        this.columnConstraintsCache.putAll((Map)TransactionManager.Companion.current().getDb().metadata$exposed_core(arg_0 -> VendorDialect.fillConstraintCacheForTables$lambda$22(tables, arg_0)));
    }

    @Override
    public void resetCaches() {
        this._allTableNames = null;
        this.columnConstraintsCache.clear();
        TransactionManager.Companion.current().getDb().metadata$exposed_core(VendorDialect::resetCaches$lambda$23);
    }

    @Override
    public void resetSchemaCaches() {
        this._allSchemaNames = null;
        this.resetCaches();
    }

    @Nullable
    public final String filterCondition(@NotNull Index index) {
        Op<Boolean> op;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)index, (String)"index");
                op = index.getFilterCondition();
                if (op == null) break block4;
                Op<Boolean> it = op;
                boolean bl = false;
                DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialect();
                if (!(databaseDialect instanceof PostgreSQLDialect || databaseDialect instanceof SQLServerDialect || databaseDialect instanceof SQLiteDialect)) {
                    SQLLogKt.getExposedLogger().warn("Index creation with a filter condition is not supported in " + DatabaseDialectKt.getCurrentDialect().getName());
                    return null;
                }
                String string = new QueryBuilder(false).append(" WHERE ").append((Expression)it).toString();
                op = string;
                if (string != null) break block5;
            }
            op = "";
        }
        return op;
    }

    private final String indexFunctionToString(Function<?> function) {
        String string;
        String baseString = function.toString();
        DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialect();
        if (databaseDialect instanceof SQLiteDialect || databaseDialect instanceof OracleDialect) {
            CharSequence charSequence = baseString;
            Regex regex = new Regex("^*[^( ]*\\.");
            String string2 = "";
            string = regex.replace(charSequence, string2);
        } else {
            string = databaseDialect instanceof MysqlDialect ? (StringsKt.first((CharSequence)baseString) != '(' ? '(' + baseString + ')' : baseString) : baseString;
        }
        return string;
    }

    @Override
    @NotNull
    public String createIndex(@NotNull Index index) {
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        Transaction t = TransactionManager.Companion.current();
        String quotedTableName = t.identity(index.getTable());
        String quotedIndexName = t.getDb().getIdentifierManager().cutIfNecessaryAndQuote(index.getIndexName());
        List<ExpressionWithColumnType<?>> list2 = index.getFunctions();
        List keyFields = CollectionsKt.plus((Collection)index.getColumns(), (Iterable)(list2 != null ? (Iterable)list2 : (Iterable)CollectionsKt.emptyList()));
        String fieldsList = CollectionsKt.joinToString$default((Iterable)keyFields, null, (CharSequence)"(", (CharSequence)")", (int)0, null, arg_0 -> VendorDialect.createIndex$lambda$25(t, this, arg_0), (int)25, null);
        List<ExpressionWithColumnType<?>> list3 = index.getFunctions();
        boolean includesOnlyColumns = !(list3 != null ? !list3.isEmpty() : false);
        String string = this.filterCondition(index);
        if (string == null) {
            return "";
        }
        String maybeFilterCondition = string;
        return index.getUnique() && ((CharSequence)maybeFilterCondition).length() == 0 && includesOnlyColumns ? "ALTER TABLE " + quotedTableName + " ADD CONSTRAINT " + quotedIndexName + " UNIQUE " + fieldsList : (index.getUnique() ? "CREATE UNIQUE INDEX " + quotedIndexName + " ON " + quotedTableName + ' ' + fieldsList + maybeFilterCondition : (index.getIndexType() != null ? this.createIndexWithType(quotedIndexName, quotedTableName, fieldsList, index.getIndexType(), maybeFilterCondition) : "CREATE INDEX " + quotedIndexName + " ON " + quotedTableName + ' ' + fieldsList + maybeFilterCondition));
    }

    @NotNull
    protected String createIndexWithType(@NotNull String name, @NotNull String table, @NotNull String columns, @NotNull String type, @NotNull String filterCondition) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)columns, (String)"columns");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)filterCondition, (String)"filterCondition");
        return "CREATE INDEX " + name + " ON " + table + ' ' + columns + " USING " + type + filterCondition;
    }

    @Override
    @NotNull
    public String dropIndex(@NotNull String tableName, @NotNull String indexName, boolean isUnique, boolean isPartialOrFunctional) {
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        Intrinsics.checkNotNullParameter((Object)indexName, (String)"indexName");
        return "ALTER TABLE " + this.getIdentifierManager().quoteIfNecessary(tableName) + " DROP CONSTRAINT " + this.getIdentifierManager().quoteIfNecessary(indexName);
    }

    @Override
    @NotNull
    public List<String> modifyColumn(@NotNull Column<?> column, @NotNull ColumnDiff columnDiff) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Intrinsics.checkNotNullParameter((Object)columnDiff, (String)"columnDiff");
        return CollectionsKt.listOf((Object)("ALTER TABLE " + TransactionManager.Companion.current().identity(column.getTable()) + " MODIFY COLUMN " + column.descriptionDdl(true)));
    }

    @Override
    @NotNull
    public String addPrimaryKey(@NotNull Table table, @Nullable String pkName, Column<?> ... pkColumns) {
        String string;
        String columns;
        Transaction transaction;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)table, (String)"table");
                Intrinsics.checkNotNullParameter(pkColumns, (String)"pkColumns");
                transaction = TransactionManager.Companion.current();
                columns = ArraysKt.joinToString$default((Object[])pkColumns, null, (CharSequence)"(", (CharSequence)")", (int)0, null, arg_0 -> VendorDialect.addPrimaryKey$lambda$26(transaction, arg_0), (int)25, null);
                string = pkName;
                if (string == null) break block2;
                String it = string;
                boolean bl = false;
                String string2 = " CONSTRAINT " + this.getIdentifierManager().quoteIfNecessary(it) + ' ';
                string = string2;
                if (string2 != null) break block3;
            }
            string = " ";
        }
        String constraint = string;
        return "ALTER TABLE " + transaction.identity(table) + " ADD" + constraint + "PRIMARY KEY " + columns;
    }

    @Override
    public boolean getSupportsIfNotExists() {
        return DatabaseDialect.DefaultImpls.getSupportsIfNotExists(this);
    }

    @Override
    public boolean getSupportsCreateSequence() {
        return DatabaseDialect.DefaultImpls.getSupportsCreateSequence(this);
    }

    @Override
    public boolean getNeedsSequenceToAutoInc() {
        return DatabaseDialect.DefaultImpls.getNeedsSequenceToAutoInc(this);
    }

    @Override
    @NotNull
    public ReferenceOption getDefaultReferenceOption() {
        return DatabaseDialect.DefaultImpls.getDefaultReferenceOption(this);
    }

    @Override
    public boolean getNeedsQuotesWhenSymbolsInNames() {
        return DatabaseDialect.DefaultImpls.getNeedsQuotesWhenSymbolsInNames(this);
    }

    @Override
    public boolean getSupportsSequenceAsGeneratedKeys() {
        return DatabaseDialect.DefaultImpls.getSupportsSequenceAsGeneratedKeys(this);
    }

    @Override
    public boolean getSupportsOnlyIdentifiersInGeneratedKeys() {
        return DatabaseDialect.DefaultImpls.getSupportsOnlyIdentifiersInGeneratedKeys(this);
    }

    @Override
    public boolean getSupportsTernaryAffectedRowValues() {
        return DatabaseDialect.DefaultImpls.getSupportsTernaryAffectedRowValues(this);
    }

    @Override
    public boolean getSupportsCreateSchema() {
        return DatabaseDialect.DefaultImpls.getSupportsCreateSchema(this);
    }

    @Override
    public boolean getSupportsSubqueryUnions() {
        return DatabaseDialect.DefaultImpls.getSupportsSubqueryUnions(this);
    }

    @Override
    public boolean getSupportsDualTableConcept() {
        return DatabaseDialect.DefaultImpls.getSupportsDualTableConcept(this);
    }

    @Override
    public boolean getSupportsOrderByNullsFirstLast() {
        return DatabaseDialect.DefaultImpls.getSupportsOrderByNullsFirstLast(this);
    }

    @Override
    public boolean getSupportsWindowFrameGroupsMode() {
        return DatabaseDialect.DefaultImpls.getSupportsWindowFrameGroupsMode(this);
    }

    @Override
    public boolean getSupportsOnUpdate() {
        return DatabaseDialect.DefaultImpls.getSupportsOnUpdate(this);
    }

    @Override
    public boolean getSupportsSetDefaultReferenceOption() {
        return DatabaseDialect.DefaultImpls.getSupportsSetDefaultReferenceOption(this);
    }

    @Override
    public boolean getSupportsRestrictReferenceOption() {
        return DatabaseDialect.DefaultImpls.getSupportsRestrictReferenceOption(this);
    }

    @Override
    @NotNull
    public Map<Character, Character> getLikePatternSpecialChars() {
        return DatabaseDialect.DefaultImpls.getLikePatternSpecialChars(this);
    }

    @Override
    public boolean getRequiresAutoCommitOnCreateDrop() {
        return DatabaseDialect.DefaultImpls.getRequiresAutoCommitOnCreateDrop(this);
    }

    @Override
    public boolean checkTableMapping(@NotNull Table table) {
        return DatabaseDialect.DefaultImpls.checkTableMapping(this, table);
    }

    @Override
    public boolean isAllowedAsColumnDefault(@NotNull Expression<?> e) {
        return DatabaseDialect.DefaultImpls.isAllowedAsColumnDefault(this, e);
    }

    @Override
    @NotNull
    public String catalog(@NotNull Transaction transaction) {
        return DatabaseDialect.DefaultImpls.catalog(this, transaction);
    }

    @Override
    @NotNull
    public String createDatabase(@NotNull String name) {
        return DatabaseDialect.DefaultImpls.createDatabase(this, name);
    }

    @Override
    @NotNull
    public String listDatabases() {
        return DatabaseDialect.DefaultImpls.listDatabases(this);
    }

    @Override
    @NotNull
    public String dropDatabase(@NotNull String name) {
        return DatabaseDialect.DefaultImpls.dropDatabase(this, name);
    }

    @Override
    @NotNull
    public String setSchema(@NotNull Schema schema) {
        return DatabaseDialect.DefaultImpls.setSchema(this, schema);
    }

    @Override
    @NotNull
    public String createSchema(@NotNull Schema schema) {
        return DatabaseDialect.DefaultImpls.createSchema(this, schema);
    }

    @Override
    @NotNull
    public String dropSchema(@NotNull Schema schema, boolean cascade) {
        return DatabaseDialect.DefaultImpls.dropSchema(this, schema, cascade);
    }

    @Override
    @NotNull
    public ReferenceOption resolveRefOptionFromJdbc(int refOption) {
        return DatabaseDialect.DefaultImpls.resolveRefOptionFromJdbc(this, refOption);
    }

    private static final List _get_allTablesNames_$lambda$0(VendorDialect this$0, ExposedDatabaseMetadata $this$metadata) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$this$metadata, (String)"$this$metadata");
        return $this$metadata.tableNamesByCurrentSchema(this$0.getAllTableNamesCache()).getTableNames();
    }

    private static final Map getAllTableNamesCache$lambda$1(ExposedDatabaseMetadata $this$metadata) {
        Intrinsics.checkNotNullParameter((Object)$this$metadata, (String)"$this$metadata");
        return $this$metadata.getTableNames();
    }

    private static final List getAllSchemaNamesCache$lambda$2(ExposedDatabaseMetadata $this$metadata) {
        Intrinsics.checkNotNullParameter((Object)$this$metadata, (String)"$this$metadata");
        return $this$metadata.getSchemaNames();
    }

    private static final List allTablesNames$lambda$3(ExposedDatabaseMetadata $this$metadata) {
        Intrinsics.checkNotNullParameter((Object)$this$metadata, (String)"$this$metadata");
        return $this$metadata.tableNamesByCurrentSchema(null).getTableNames();
    }

    private static final SchemaMetadata tableExists$lambda$9$lambda$7(VendorDialect $this_run, ExposedDatabaseMetadata $this$metadata) {
        Intrinsics.checkNotNullParameter((Object)$this_run, (String)"$this_run");
        Intrinsics.checkNotNullParameter((Object)$this$metadata, (String)"$this$metadata");
        return $this$metadata.tableNamesByCurrentSchema($this_run.getAllTableNamesCache());
    }

    private static final Map tableColumns$lambda$12(Table[] $tables, ExposedDatabaseMetadata $this$metadata) {
        Intrinsics.checkNotNullParameter((Object)$tables, (String)"$tables");
        Intrinsics.checkNotNullParameter((Object)$this$metadata, (String)"$this$metadata");
        return $this$metadata.columns(Arrays.copyOf($tables, $tables.length));
    }

    private static final Map existingIndices$lambda$17(Table[] $tables, ExposedDatabaseMetadata $this$metadata) {
        Intrinsics.checkNotNullParameter((Object)$tables, (String)"$tables");
        Intrinsics.checkNotNullParameter((Object)$this$metadata, (String)"$this$metadata");
        return $this$metadata.existingIndices(Arrays.copyOf($tables, $tables.length));
    }

    private static final Map existingPrimaryKeys$lambda$18(Table[] $tables, ExposedDatabaseMetadata $this$metadata) {
        Intrinsics.checkNotNullParameter((Object)$tables, (String)"$tables");
        Intrinsics.checkNotNullParameter((Object)$this$metadata, (String)"$this$metadata");
        return $this$metadata.existingPrimaryKeys(Arrays.copyOf($tables, $tables.length));
    }

    private static final List sequences$lambda$19(ExposedDatabaseMetadata $this$metadata) {
        Intrinsics.checkNotNullParameter((Object)$this$metadata, (String)"$this$metadata");
        return $this$metadata.sequences();
    }

    private static final boolean supportsSelectForUpdate_delegate$lambda$21$lambda$20(ExposedDatabaseMetadata $this$metadata) {
        Intrinsics.checkNotNullParameter((Object)$this$metadata, (String)"$this$metadata");
        return $this$metadata.getSupportsSelectForUpdate();
    }

    private static final boolean supportsSelectForUpdate_delegate$lambda$21() {
        return (Boolean)TransactionManager.Companion.current().getDb().metadata$exposed_core(VendorDialect::supportsSelectForUpdate_delegate$lambda$21$lambda$20);
    }

    private static final Map fillConstraintCacheForTables$lambda$22(List $tables, ExposedDatabaseMetadata $this$metadata) {
        Intrinsics.checkNotNullParameter((Object)$tables, (String)"$tables");
        Intrinsics.checkNotNullParameter((Object)$this$metadata, (String)"$this$metadata");
        return $this$metadata.tableConstraints($tables);
    }

    private static final Unit resetCaches$lambda$23(ExposedDatabaseMetadata $this$metadata) {
        Intrinsics.checkNotNullParameter((Object)$this$metadata, (String)"$this$metadata");
        $this$metadata.cleanCache();
        return Unit.INSTANCE;
    }

    private static final CharSequence createIndex$lambda$25(Transaction $t, VendorDialect this$0, ExpressionWithColumnType it) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)$t, (String)"$t");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ExpressionWithColumnType expressionWithColumnType = it;
        if (expressionWithColumnType instanceof Column) {
            charSequence = $t.identity((Column)it);
        } else if (expressionWithColumnType instanceof Function) {
            charSequence = this$0.indexFunctionToString((Function)it);
        } else if (expressionWithColumnType instanceof LiteralOp) {
            char[] cArray = new char[]{'\"'};
            charSequence = StringsKt.trim((String)String.valueOf(((LiteralOp)it).getValue()), (char[])cArray);
        } else {
            SQLLogKt.getExposedLogger().warn("Unexpected defining key field will be passed as String: " + it);
            charSequence = it.toString();
        }
        return charSequence;
    }

    private static final CharSequence addPrimaryKey$lambda$26(Transaction $transaction, Column it) {
        Intrinsics.checkNotNullParameter((Object)$transaction, (String)"$transaction");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $transaction.identity(it);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/exposed/sql/vendors/VendorDialect$DialectNameProvider;", "", "", "dialectName", "<init>", "(Ljava/lang/String;)V", "Ljava/lang/String;", "getDialectName", "()Ljava/lang/String;", "exposed-core"})
    public static abstract class DialectNameProvider {
        @NotNull
        private final String dialectName;

        public DialectNameProvider(@NotNull String dialectName) {
            Intrinsics.checkNotNullParameter((Object)dialectName, (String)"dialectName");
            this.dialectName = dialectName;
        }

        @NotNull
        public final String getDialectName() {
            return this.dialectName;
        }
    }
}

