/*
 * Decompiled with CFR 0.152.
 */
package dev.ashhhleyyy.playerpronouns.impl;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.ashhhleyyy.playerpronouns.api.Pronoun;
import dev.ashhhleyyy.playerpronouns.impl.PlayerPronouns;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;

public class Config {
    private static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("allow_custom").forGetter(config -> config.allowCustom), (App)Codec.BOOL.fieldOf("enable_pronoundb_sync").forGetter(config -> config.enablePronounDBSync), (App)Pronoun.CODEC.listOf().fieldOf("single").forGetter(config -> config.single), (App)Pronoun.CODEC.listOf().fieldOf("pairs").forGetter(config -> config.pairs), (App)Codec.STRING.optionalFieldOf("default_placeholder", (Object)"Unknown").forGetter(config -> config.defaultPlaceholder)).apply((Applicative)instance, Config::new));
    private final boolean allowCustom;
    private final boolean enablePronounDBSync;
    private final List<Pronoun> single;
    private final List<Pronoun> pairs;
    private final String defaultPlaceholder;

    private Config(boolean allowCustom, boolean enablePronounDBSync, List<Pronoun> single, List<Pronoun> pairs, String defaultPlaceholder) {
        this.allowCustom = allowCustom;
        this.enablePronounDBSync = enablePronounDBSync;
        this.single = single;
        this.pairs = pairs;
        this.defaultPlaceholder = defaultPlaceholder;
    }

    private Config() {
        this(true, true, Collections.emptyList(), Collections.emptyList(), "Unknown");
    }

    public boolean allowCustom() {
        return this.allowCustom;
    }

    public boolean enablePronounDBSync() {
        return this.enablePronounDBSync;
    }

    public List<Pronoun> getSingle() {
        return this.single;
    }

    public List<Pronoun> getPairs() {
        return this.pairs;
    }

    public String getDefaultPlaceholder() {
        return this.defaultPlaceholder;
    }

    public static Config load() {
        Path path = FabricLoader.getInstance().getConfigDir().resolve("player-pronouns.json");
        if (!Files.exists(path, new LinkOption[0])) {
            Config config = new Config();
            Optional result = CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)config).result();
            if (result.isPresent()) {
                try {
                    Files.writeString(path, (CharSequence)new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)result.get()), new OpenOption[0]);
                }
                catch (IOException e2) {
                    PlayerPronouns.LOGGER.warn("Failed to save default config!", (Throwable)e2);
                }
            } else {
                PlayerPronouns.LOGGER.warn("Failed to save default config!");
            }
            return new Config();
        }
        try {
            String s = Files.readString(path);
            JsonElement ele = JsonParser.parseString((String)s);
            DataResult result = CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)ele).map(Pair::getFirst);
            Optional err = result.error();
            err.ifPresent(e -> PlayerPronouns.LOGGER.warn("Failed to load config: {}", (Object)e.message()));
            return result.result().orElseGet(Config::new);
        }
        catch (IOException e3) {
            PlayerPronouns.LOGGER.warn("Failed to load config!", (Throwable)e3);
            return new Config();
        }
    }
}

