/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.fabric_1_20;

import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2784;
import net.minecraft.class_2902;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import org.dynmap.DynmapChunk;
import org.dynmap.DynmapLocation;
import org.dynmap.DynmapWorld;
import org.dynmap.fabric_1_20.DynmapPlugin;
import org.dynmap.fabric_1_20.FabricMapChunkCache;
import org.dynmap.utils.MapChunkCache;
import org.dynmap.utils.Polygon;

public class FabricWorld
extends DynmapWorld {
    public static final String SAVED_WORLDS_FILE = "fabricworlds.yml";
    private final DynmapPlugin plugin;
    private class_1937 world;
    private final boolean skylight;
    private final boolean isnether;
    private final boolean istheend;
    private final String env;
    private DynmapLocation spawnloc = new DynmapLocation();
    private static int maxWorldHeight = 320;

    public static int getMaxWorldHeight() {
        return maxWorldHeight;
    }

    public static void setMaxWorldHeight(int h) {
        maxWorldHeight = h;
    }

    public static String getWorldName(DynmapPlugin plugin, class_1937 w) {
        class_5321 rk = w.method_27983();
        if (rk == class_1937.field_25179) {
            return w.method_8503().method_27728().method_150();
        }
        if (rk == class_1937.field_25181) {
            return "DIM1";
        }
        if (rk == class_1937.field_25180) {
            return "DIM-1";
        }
        return rk.method_29177().method_12836() + "_" + rk.method_29177().method_12832();
    }

    public void updateWorld(class_1937 w) {
        this.updateWorldHeights(w.method_31605(), w.method_31607(), w.method_8615());
    }

    public FabricWorld(DynmapPlugin plugin, class_1937 w) {
        this(plugin, FabricWorld.getWorldName(plugin, w), w.method_31605(), w.method_8615(), w.method_27983() == class_1937.field_25180, w.method_27983() == class_1937.field_25181, w.method_27983().method_29177().method_12832(), w.method_31607());
        this.setWorldLoaded(w);
    }

    public FabricWorld(DynmapPlugin plugin, String name, int height, int sealevel, boolean nether, boolean the_end, String deftitle, int miny) {
        super(name, height > maxWorldHeight ? maxWorldHeight : height, sealevel, miny);
        this.plugin = plugin;
        this.world = null;
        this.setTitle(deftitle);
        this.isnether = nether;
        this.istheend = the_end;
        boolean bl = this.skylight = !this.isnether && !this.istheend;
        this.env = this.isnether ? "nether" : (this.istheend ? "the_end" : "normal");
    }

    @Override
    public boolean isNether() {
        return this.isnether;
    }

    public boolean isTheEnd() {
        return this.istheend;
    }

    @Override
    public DynmapLocation getSpawnLocation() {
        if (this.world != null) {
            this.spawnloc.x = this.world.method_8401().method_215();
            this.spawnloc.y = this.world.method_8401().method_144();
            this.spawnloc.z = this.world.method_8401().method_166();
            this.spawnloc.world = this.getName();
        }
        return this.spawnloc;
    }

    @Override
    public long getTime() {
        if (this.world != null) {
            return this.world.method_8532();
        }
        return -1L;
    }

    @Override
    public boolean hasStorm() {
        if (this.world != null) {
            return this.world.method_8419();
        }
        return false;
    }

    @Override
    public boolean isThundering() {
        if (this.world != null) {
            return this.world.method_8546();
        }
        return false;
    }

    @Override
    public boolean isLoaded() {
        return this.world != null;
    }

    @Override
    public void setWorldUnloaded() {
        this.getSpawnLocation();
        this.world = null;
    }

    public void setWorldLoaded(class_1937 w) {
        this.world = w;
        this.sealevel = w.method_8615();
        for (int lightLevel = 0; lightLevel < 16; ++lightLevel) {
            float value = (float)lightLevel / 15.0f;
            float brightness = value / (4.0f - 3.0f * value);
            this.setBrightnessTableEntry(lightLevel, class_3532.method_16439((float)w.method_8597().comp_656(), (float)brightness, (float)1.0f));
        }
    }

    @Override
    public int getLightLevel(int x, int y, int z) {
        if (this.world != null) {
            return this.world.method_22339(new class_2338(x, y, z));
        }
        return -1;
    }

    @Override
    public int getHighestBlockYAt(int x, int z) {
        if (this.world != null) {
            return this.world.method_8497(x >> 4, z >> 4).method_12032(class_2902.class_2903.field_13197).method_12603(x & 0xF, z & 0xF);
        }
        return -1;
    }

    @Override
    public boolean canGetSkyLightLevel() {
        return this.skylight;
    }

    @Override
    public int getSkyLightLevel(int x, int y, int z) {
        if (this.world != null) {
            return this.world.method_8314(class_1944.field_9284, new class_2338(x, y, z));
        }
        return -1;
    }

    @Override
    public String getEnvironment() {
        return this.env;
    }

    @Override
    public MapChunkCache getChunkCache(List<DynmapChunk> chunks) {
        if (this.world != null) {
            FabricMapChunkCache c = new FabricMapChunkCache(this.plugin);
            c.setChunks(this, chunks);
            return c;
        }
        return null;
    }

    public class_1937 getWorld() {
        return this.world;
    }

    @Override
    public Polygon getWorldBorder() {
        class_2784 wb;
        if (this.world != null && (wb = this.world.method_8621()) != null && wb.method_11965() < 5.9E7) {
            Polygon p = new Polygon();
            p.addVertex(wb.method_11976(), wb.method_11958());
            p.addVertex(wb.method_11976(), wb.method_11977());
            p.addVertex(wb.method_11963(), wb.method_11977());
            p.addVertex(wb.method_11963(), wb.method_11958());
            return p;
        }
        return null;
    }
}

