/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap.renderer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import org.dynmap.renderer.CustomRenderer;
import org.dynmap.renderer.MapDataContext;
import org.dynmap.renderer.RenderPatch;
import org.dynmap.renderer.RenderPatchFactory;

public class ImmibisMicroRenderer
extends CustomRenderer {
    private static final String[] tileFields = new String[]{"ICMP"};
    private static final int NUM_TEXTURES = 102;
    private static final int[][] materialTextureMap = new int[][]{{0}, {0}, {0}, {1}, {2}, {3}, {4}, {5}, {6}, {7}, {8}, {9}, {10}, {11}, {12}, {13, 13, 14, 14, 14, 14}, {13, 13, 15, 15, 15, 15}, {13, 13, 16, 16, 16, 16}, {13, 13, 17, 17, 17, 17}, {0}, {0}, {0}, {0}, {18}, {19}, {20}, {21}, {22, 22, 23, 24, 24, 24}, {25, 26, 27, 27, 27, 27}, {28}, {29, 30, 31, 31, 31, 31}, {32, 33, 31, 31, 31, 31}, {34}, {35}, {36}, {37}, {38}, {39}, {40}, {41}, {42}, {43}, {44}, {45}, {46}, {47}, {48}, {49}, {50}, {51}, {52}, {53}, {3, 3, 54, 54, 54, 54}, {55}, {56}, {57}, {58}, {59}, {60, 60, 61, 61, 62, 62}, {22, 22, 63, 64, 64, 64}, {65}, {66}, {67}, {68, 68, 69, 69, 69, 69}, {70, 70, 71, 71, 71, 71}, {72}, {73}, {74}, {70, 70, 75, 71, 71, 71}, {76}, {77, 77, 78, 78, 78, 78}, {1, 79, 80, 80, 80, 80}, {81}, {82}, {82}, {83}, {84}, {85}, {26, 26, 86, 86, 86, 86}, {26, 26, 87, 87, 87, 87}, {88}, {89}, {90}, {91}, {92}, {93}, {94, 95, 96, 96, 96, 96}, {94, 97, 98, 98, 98, 98}, {99, 99, 100, 100, 100, 100}, {22, 101, 22, 22, 22, 22}};
    private static final AxisPos[][] axes_by_pos = new AxisPos[][]{{AxisPos.CENTER, AxisPos.CENTER, AxisPos.CENTER}, {AxisPos.NEGATIVE, AxisPos.SPAN, AxisPos.SPAN}, {AxisPos.POSITIVE, AxisPos.SPAN, AxisPos.SPAN}, {AxisPos.SPAN, AxisPos.NEGATIVE, AxisPos.SPAN}, {AxisPos.SPAN, AxisPos.POSITIVE, AxisPos.SPAN}, {AxisPos.SPAN, AxisPos.SPAN, AxisPos.NEGATIVE}, {AxisPos.SPAN, AxisPos.SPAN, AxisPos.POSITIVE}, {AxisPos.NEGATIVE, AxisPos.NEGATIVE, AxisPos.SPAN}, {AxisPos.NEGATIVE, AxisPos.POSITIVE, AxisPos.SPAN}, {AxisPos.POSITIVE, AxisPos.NEGATIVE, AxisPos.SPAN}, {AxisPos.POSITIVE, AxisPos.POSITIVE, AxisPos.SPAN}, {AxisPos.NEGATIVE, AxisPos.SPAN, AxisPos.NEGATIVE}, {AxisPos.NEGATIVE, AxisPos.SPAN, AxisPos.POSITIVE}, {AxisPos.POSITIVE, AxisPos.SPAN, AxisPos.NEGATIVE}, {AxisPos.POSITIVE, AxisPos.SPAN, AxisPos.POSITIVE}, {AxisPos.SPAN, AxisPos.NEGATIVE, AxisPos.NEGATIVE}, {AxisPos.SPAN, AxisPos.NEGATIVE, AxisPos.POSITIVE}, {AxisPos.SPAN, AxisPos.POSITIVE, AxisPos.NEGATIVE}, {AxisPos.SPAN, AxisPos.POSITIVE, AxisPos.POSITIVE}, {AxisPos.NEGATIVE, AxisPos.NEGATIVE, AxisPos.NEGATIVE}, {AxisPos.NEGATIVE, AxisPos.NEGATIVE, AxisPos.POSITIVE}, {AxisPos.NEGATIVE, AxisPos.POSITIVE, AxisPos.NEGATIVE}, {AxisPos.NEGATIVE, AxisPos.POSITIVE, AxisPos.POSITIVE}, {AxisPos.POSITIVE, AxisPos.NEGATIVE, AxisPos.NEGATIVE}, {AxisPos.POSITIVE, AxisPos.NEGATIVE, AxisPos.POSITIVE}, {AxisPos.POSITIVE, AxisPos.POSITIVE, AxisPos.NEGATIVE}, {AxisPos.POSITIVE, AxisPos.POSITIVE, AxisPos.POSITIVE}, {AxisPos.SPAN, AxisPos.CENTER, AxisPos.CENTER}, {AxisPos.CENTER, AxisPos.SPAN, AxisPos.CENTER}, {AxisPos.CENTER, AxisPos.CENTER, AxisPos.SPAN}};

    @Override
    public boolean initializeRenderer(RenderPatchFactory rpf, String blkname, BitSet blockdatamask, Map<String, String> custparm) {
        if (!super.initializeRenderer(rpf, blkname, blockdatamask, custparm)) {
            return false;
        }
        for (int i = 0; i < materialTextureMap.length; ++i) {
            if (materialTextureMap[i].length >= 6) continue;
            int[] sides = new int[6];
            Arrays.fill(sides, materialTextureMap[i][0]);
            ImmibisMicroRenderer.materialTextureMap[i] = sides;
        }
        return true;
    }

    @Override
    public int getMaximumTextureCount() {
        return 102;
    }

    @Override
    public RenderPatch[] getRenderPatchList(MapDataContext ctx) {
        Object v = ctx.getBlockTileEntityField("ICMP");
        ArrayList<RenderPatch> list = new ArrayList<RenderPatch>();
        if (v != null && v instanceof List) {
            List lv = (List)v;
            for (Object lval : lv) {
                if (!(lval instanceof Map)) continue;
                Map mv = (Map)lval;
                Integer type = (Integer)mv.get("type");
                Byte pos = (Byte)mv.get("pos");
                if (type == null || pos == null) continue;
                this.addPatchesFor(ctx.getPatchFactory(), list, type, pos.byteValue());
            }
        }
        return list.toArray(new RenderPatch[list.size()]);
    }

    private boolean isHollow(int shape, int thickness) {
        return shape == 3;
    }

    private double getThickness(int shape, int thickness) {
        return 0.125 * (double)thickness;
    }

    private double getAxisMin(AxisPos ap, double thick) {
        switch (ap.ordinal()) {
            case 2: {
                return 1.0 - thick;
            }
            case 0: {
                return 0.5 - thick / 2.0;
            }
        }
        return 0.0;
    }

    private double getAxisMax(AxisPos ap, double thick) {
        switch (ap.ordinal()) {
            case 1: {
                return thick;
            }
            case 0: {
                return 0.5 + thick / 2.0;
            }
        }
        return 1.0;
    }

    private void addPatchesFor(RenderPatchFactory rpf, ArrayList<RenderPatch> list, int type, int pos) {
        int material = type >> 6 & 0xFFFF;
        int shape = type >> 3 & 7;
        int thickness = (type & 7) + 1;
        if (material < 0 || material >= materialTextureMap.length) {
            material = 0;
        }
        if (pos < 0 || pos >= axes_by_pos.length) {
            pos = 0;
        }
        int[] sides = materialTextureMap[material];
        double thick = this.getThickness(shape, thickness);
        if (thick <= 0.0) {
            return;
        }
        if (thick > 1.0) {
            thick = 1.0;
        }
        if (this.isHollow(shape, thickness)) {
            switch (pos) {
                case 1: {
                    CustomRenderer.addBox(rpf, list, 0.0, thick, 0.0, 0.75, 0.0, 0.25, sides);
                    CustomRenderer.addBox(rpf, list, 0.0, thick, 0.75, 1.0, 0.0, 0.75, sides);
                    CustomRenderer.addBox(rpf, list, 0.0, thick, 0.25, 1.0, 0.75, 1.0, sides);
                    CustomRenderer.addBox(rpf, list, 0.0, thick, 0.0, 0.25, 0.25, 1.0, sides);
                    break;
                }
                case 2: {
                    CustomRenderer.addBox(rpf, list, 1.0 - thick, 1.0, 0.0, 0.75, 0.0, 0.25, sides);
                    CustomRenderer.addBox(rpf, list, 1.0 - thick, 1.0, 0.75, 1.0, 0.0, 0.75, sides);
                    CustomRenderer.addBox(rpf, list, 1.0 - thick, 1.0, 0.25, 1.0, 0.75, 1.0, sides);
                    CustomRenderer.addBox(rpf, list, 1.0 - thick, 1.0, 0.0, 0.25, 0.25, 1.0, sides);
                    break;
                }
                case 3: {
                    CustomRenderer.addBox(rpf, list, 0.0, 0.75, 0.0, thick, 0.0, 0.25, sides);
                    CustomRenderer.addBox(rpf, list, 0.75, 1.0, 0.0, thick, 0.0, 0.75, sides);
                    CustomRenderer.addBox(rpf, list, 0.25, 1.0, 0.0, thick, 0.75, 1.0, sides);
                    CustomRenderer.addBox(rpf, list, 0.0, 0.25, 0.0, thick, 0.25, 1.0, sides);
                    break;
                }
                case 4: {
                    CustomRenderer.addBox(rpf, list, 0.0, 0.75, 1.0 - thick, 1.0, 0.0, 0.25, sides);
                    CustomRenderer.addBox(rpf, list, 0.75, 1.0, 1.0 - thick, 1.0, 0.0, 0.75, sides);
                    CustomRenderer.addBox(rpf, list, 0.25, 1.0, 1.0 - thick, 1.0, 0.75, 1.0, sides);
                    CustomRenderer.addBox(rpf, list, 0.0, 0.25, 1.0 - thick, 1.0, 0.25, 1.0, sides);
                    break;
                }
                case 5: {
                    CustomRenderer.addBox(rpf, list, 0.0, 0.75, 0.0, 0.25, 0.0, thick, sides);
                    CustomRenderer.addBox(rpf, list, 0.75, 1.0, 0.0, 0.75, 0.0, thick, sides);
                    CustomRenderer.addBox(rpf, list, 0.25, 1.0, 0.75, 1.0, 0.0, thick, sides);
                    CustomRenderer.addBox(rpf, list, 0.0, 0.25, 0.25, 1.0, 0.0, thick, sides);
                    break;
                }
                case 6: {
                    CustomRenderer.addBox(rpf, list, 0.0, 0.75, 0.0, 0.25, 1.0 - thick, 1.0, sides);
                    CustomRenderer.addBox(rpf, list, 0.75, 1.0, 0.0, 0.75, 1.0 - thick, 1.0, sides);
                    CustomRenderer.addBox(rpf, list, 0.25, 1.0, 0.75, 1.0, 1.0 - thick, 1.0, sides);
                    CustomRenderer.addBox(rpf, list, 0.0, 0.25, 0.25, 1.0, 1.0 - thick, 1.0, sides);
                }
            }
        } else {
            CustomRenderer.addBox(rpf, list, this.getAxisMin(axes_by_pos[pos][0], thick), this.getAxisMax(axes_by_pos[pos][0], thick), this.getAxisMin(axes_by_pos[pos][1], thick), this.getAxisMax(axes_by_pos[pos][1], thick), this.getAxisMin(axes_by_pos[pos][2], thick), this.getAxisMax(axes_by_pos[pos][2], thick), sides);
        }
    }

    @Override
    public String[] getTileEntityFieldsNeeded() {
        return tileFields;
    }

    private static enum AxisPos {
        CENTER,
        NEGATIVE,
        POSITIVE,
        SPAN;

    }
}

