/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.s3lite.api.response;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;

public class ResponseBytes<T> {
    private final T response;
    private final byte[] bytes;

    private ResponseBytes(T response, byte[] bytes) {
        this.response = response;
        this.bytes = bytes;
    }

    public T getResponse() {
        return this.response;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public String asString(Charset charset) {
        return new String(this.bytes, charset);
    }

    public String asUtf8String() {
        return this.asString(StandardCharsets.UTF_8);
    }

    public InputStream asInputStream() {
        return new ByteArrayInputStream(this.bytes);
    }

    public ByteBuffer asByteBuffer() {
        return ByteBuffer.wrap(this.bytes).asReadOnlyBuffer();
    }

    static <T> ResponseBytes<T> fromByteArray(T response, byte[] bytes) {
        return new ResponseBytes<T>(response, Arrays.copyOf(bytes, bytes.length));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ResponseBytes that = (ResponseBytes)obj;
        return Objects.equals(this.response, that.response) && Arrays.equals(this.bytes, that.bytes);
    }

    public int hashCode() {
        int result = Objects.hash(this.response);
        result = 31 * result + Arrays.hashCode(this.bytes);
        return result;
    }

    public String toString() {
        return "ResponseBytes{response=" + this.response + ", bytes=" + Arrays.toString(this.bytes) + '}';
    }
}

