/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.s3lite.http.spi.response;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.dynmap.s3lite.http.spi.HttpStatus;
import org.dynmap.s3lite.http.spi.response.DefaultImmutableResponse;

public interface ImmutableResponse {
    public HttpStatus getStatus();

    public Map<String, List<String>> getHeaders();

    public Optional<InputStream> getResponseBody();

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private HttpStatus status;
        private Map<String, List<String>> headers;
        private InputStream responseBody;

        Builder() {
        }

        public Builder status(HttpStatus status) {
            this.status = status;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder responseBody(InputStream responseBody) {
            this.responseBody = responseBody;
            return this;
        }

        public ImmutableResponse build() {
            return new DefaultImmutableResponse(this.status, this.headers, this.responseBody);
        }
    }
}

