/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.web;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;

public class BoundInputStream
extends InputStream {
    protected static final Logger log = Logger.getLogger("Minecraft");
    protected static final String LOG_PREFIX = "[dynmap] ";
    private InputStream base;
    private long bound;

    public BoundInputStream(InputStream base, long bound) {
        this.base = base;
        this.bound = bound;
    }

    @Override
    public int read() throws IOException {
        if (this.bound <= 0L) {
            return -1;
        }
        int r = this.base.read();
        if (r >= 0) {
            --this.bound;
        }
        return r;
    }

    @Override
    public int available() throws IOException {
        return (int)Math.min((long)this.base.available(), this.bound);
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.bound <= 0L) {
            return -1;
        }
        len = (int)Math.min(this.bound, (long)len);
        int r = this.base.read(b, off, len);
        this.bound -= (long)r;
        return r;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public long skip(long n) throws IOException {
        long r = this.base.skip(Math.min(this.bound, n));
        this.bound -= r;
        return r;
    }

    @Override
    public void close() throws IOException {
        this.base.close();
    }
}

