/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bukkit.features;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.placeholders.expansion.TabExpansion;
import me.neznamy.tab.shared.platform.TabPlayer;
import me.neznamy.tab.shared.util.ReflectionUtils;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BukkitTabExpansion
extends PlaceholderExpansion
implements TabExpansion {
    @NotNull
    private final List<String> placeholders = Collections.unmodifiableList(Arrays.asList("%tab_tabprefix%", "%tab_tabsuffix%", "%tab_tagprefix%", "%tab_tagsuffix%", "%tab_customtabname%", "%tab_customtagname%", "%tab_belowname%", "%tab_abovename%", "%tab_tabprefix_raw%", "%tab_tabsuffix_raw%", "%tab_tagprefix_raw%", "%tab_tagsuffix_raw%", "%tab_customtabname_raw%", "%tab_customtagname_raw%", "%tab_belowname_raw%", "%tab_abovename_raw%", "%tab_scoreboard_name%", "%tab_scoreboard_visible%", "%tab_bossbar_visible%", "%tab_nametag_preview%", "%tab_nametag_visibility%", "%tab_replace_<placeholder>%", "%tab_placeholder_<placeholder>%"));

    public boolean persist() {
        return true;
    }

    @NotNull
    public String getAuthor() {
        return "NEZNAMY";
    }

    @NotNull
    public String getIdentifier() {
        return "tab";
    }

    @NotNull
    public String getVersion() {
        return "4.1.6";
    }

    @NotNull
    public List<String> getPlaceholders() {
        return this.placeholders;
    }

    @Nullable
    public String onPlaceholderRequest(@Nullable Player player, @NotNull String identifier) {
        if (identifier.startsWith("replace_")) {
            String textBefore;
            String text = "%" + identifier.substring(8) + "%";
            do {
                textBefore = text;
                for (String placeholder : TAB.getInstance().getPlaceholderManager().detectPlaceholders(text)) {
                    text = text.replace(placeholder, TAB.getInstance().getPlaceholderManager().findReplacement(placeholder, PlaceholderAPI.setPlaceholders((Player)player, (String)placeholder)));
                }
            } while (!textBefore.equals(text));
            return text;
        }
        if (identifier.startsWith("placeholder_")) {
            TAB.getInstance().getPlaceholderManager().addUsedPlaceholder("%" + identifier.substring("placeholder_".length()) + "%", TAB.getInstance().getPlaceholderManager());
        }
        if (player == null) {
            return "<Player cannot be null>";
        }
        TabPlayer p = TAB.getInstance().getPlayer(player.getUniqueId());
        if (p == null) {
            return "<Player is not loaded>";
        }
        return p.expansionValues.values.get(identifier);
    }

    @Override
    public void setValue(@NotNull TabPlayer player, @NotNull String key, @NotNull String value) {
        player.expansionValues.values.put(key, value);
    }

    @Override
    public void unregisterExpansion() {
        if (ReflectionUtils.methodExists(PlaceholderExpansion.class, "unregister", new Class[0])) {
            this.unregister();
        } else {
            PlaceholderAPI.unregisterExpansion((PlaceholderExpansion)this);
        }
    }
}

