/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.velocity;

import com.google.inject.Inject;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.player.TabList;
import java.nio.file.Path;
import java.util.UUID;
import me.neznamy.tab.libs.org.bstats.velocity.Metrics;
import me.neznamy.tab.platforms.velocity.VelocityPlatform;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.chat.EnumChatFormat;
import me.neznamy.tab.shared.util.ReflectionUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Plugin(id="tab", name="TAB", version="4.1.6", description="An all-in-one solution that works", url="https://github.com/NEZNAMY/TAB", authors={"NEZNAMY"})
public class VelocityTAB {
    @Inject
    private ProxyServer server;
    @Inject
    private Metrics.Factory metricsFactory;
    @Inject
    private Logger logger;
    @Inject
    @DataDirectory
    private Path dataFolder;

    @Subscribe
    public void onProxyInitialization(@Nullable ProxyInitializeEvent event) {
        if (!ReflectionUtils.methodExists(TabList.class, "getEntry", UUID.class)) {
            this.logger.warn(String.valueOf((Object)EnumChatFormat.RED) + "The plugin requires Velocity build #229 (released on February 20th, 2023) and up to work.");
            return;
        }
        TAB.create(new VelocityPlatform(this));
    }

    @Subscribe
    public void onProxyShutdown(@Nullable ProxyShutdownEvent event) {
        if (TAB.getInstance() == null) {
            return;
        }
        TAB.getInstance().getCPUManager().runTask(() -> TAB.getInstance().unload());
    }

    public ProxyServer getServer() {
        return this.server;
    }

    public Metrics.Factory getMetricsFactory() {
        return this.metricsFactory;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Path getDataFolder() {
        return this.dataFolder;
    }
}

