/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.backend.features.unlimitedtags;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.backend.BackendTabPlayer;
import me.neznamy.tab.shared.backend.Location;
import me.neznamy.tab.shared.backend.features.unlimitedtags.BackendArmorStandManager;
import me.neznamy.tab.shared.backend.features.unlimitedtags.BackendNameTagX;
import me.neznamy.tab.shared.features.types.JoinListener;
import me.neznamy.tab.shared.features.types.Loadable;
import me.neznamy.tab.shared.features.types.QuitListener;
import me.neznamy.tab.shared.features.types.TabFeature;
import me.neznamy.tab.shared.platform.TabPlayer;
import org.jetbrains.annotations.NotNull;

public class PacketListener
extends TabFeature
implements JoinListener,
QuitListener,
Loadable {
    protected final BackendNameTagX nameTagX;
    private final Map<Integer, TabPlayer> entityIdMap = new ConcurrentHashMap<Integer, TabPlayer>();

    @Override
    public void load() {
        for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
            this.entityIdMap.put(this.nameTagX.getEntityId(all), all);
        }
    }

    @Override
    public void onJoin(@NotNull TabPlayer connectedPlayer) {
        this.entityIdMap.put(this.nameTagX.getEntityId(connectedPlayer), connectedPlayer);
    }

    @Override
    public void onQuit(@NotNull TabPlayer disconnectedPlayer) {
        this.entityIdMap.remove(this.nameTagX.getEntityId(disconnectedPlayer));
    }

    public void onPacketSend(@NotNull BackendTabPlayer receiver, @NotNull Object packet) {
        if (receiver.getEntityView().isBundlePacket(packet)) {
            for (Object wrappedPacket : receiver.getEntityView().getPackets(packet)) {
                this.checkPacket(receiver, wrappedPacket);
            }
        } else {
            this.checkPacket(receiver, packet);
        }
    }

    private void checkPacket(@NotNull BackendTabPlayer player, @NotNull Object packet) {
        if (player.getEntityView().isMovePacket(packet) && !player.getEntityView().isLookPacket(packet)) {
            this.onEntityMove(player, player.getEntityView().getMoveEntityId(packet), player.getEntityView().getMoveDiff(packet));
        } else if (player.getEntityView().isTeleportPacket(packet)) {
            this.onEntityTeleport(player, player.getEntityView().getTeleportEntityId(packet));
        } else if (player.getEntityView().isNamedEntitySpawnPacket(packet)) {
            this.onEntitySpawn(player, player.getEntityView().getSpawnedPlayer(packet));
        } else if (player.getEntityView().isDestroyPacket(packet)) {
            this.onEntityDestroy(player, player.getEntityView().getDestroyedEntities(packet));
        }
    }

    public void onEntitySpawn(@NotNull BackendTabPlayer receiver, int entityId) {
        TabPlayer spawnedPlayer = this.entityIdMap.get(entityId);
        if (spawnedPlayer != null && spawnedPlayer.isLoaded() && !this.nameTagX.isPlayerDisabled(spawnedPlayer)) {
            TAB.getInstance().getCPUManager().runMeasuredTask(this.getFeatureName(), "Processing entity spawn", () -> this.nameTagX.getArmorStandManager(spawnedPlayer).spawn(receiver));
        }
    }

    public void onEntityMove(@NotNull BackendTabPlayer receiver, int entityId, Location positionDiff) {
        TabPlayer pl = this.entityIdMap.get(entityId);
        if (pl != null) {
            if (this.nameTagX.isPlayerDisabled(pl) || !pl.isLoaded()) {
                return;
            }
            BackendArmorStandManager asm = this.nameTagX.getArmorStandManager(pl);
            TAB.getInstance().getCPUManager().runMeasuredTask(this.getFeatureName(), "Processing player move", () -> asm.move(receiver, positionDiff));
        } else {
            for (Integer entity : this.nameTagX.getVehicleManager().getVehicles().getOrDefault(entityId, Collections.emptyList())) {
                BackendArmorStandManager asm;
                TabPlayer passenger = this.entityIdMap.get(entity);
                if (passenger == null || (asm = this.nameTagX.getArmorStandManager(passenger)) == null) continue;
                TAB.getInstance().getCPUManager().runMeasuredTask(this.getFeatureName(), "Processing entity move (with player passenger)", () -> asm.move(receiver, positionDiff));
            }
        }
    }

    public void onEntityTeleport(@NotNull BackendTabPlayer receiver, int entityId) {
        TabPlayer pl = this.entityIdMap.get(entityId);
        if (pl != null) {
            if (this.nameTagX.isPlayerDisabled(pl) || !pl.isLoaded()) {
                return;
            }
            BackendArmorStandManager asm = this.nameTagX.getArmorStandManager(pl);
            TAB.getInstance().getCPUManager().runMeasuredTask(this.getFeatureName(), "Processing player move", () -> asm.teleport(receiver));
        } else {
            for (Integer entity : this.nameTagX.getVehicleManager().getVehicles().getOrDefault(entityId, Collections.emptyList())) {
                BackendArmorStandManager asm;
                TabPlayer passenger = this.entityIdMap.get(entity);
                if (passenger == null || (asm = this.nameTagX.getArmorStandManager(passenger)) == null) continue;
                TAB.getInstance().getCPUManager().runMeasuredTask(this.getFeatureName(), "Processing entity move (with player passenger)", () -> asm.teleport(receiver));
            }
        }
    }

    public void onEntityDestroy(@NotNull BackendTabPlayer receiver, int ... entities) {
        for (int entity : entities) {
            TabPlayer deSpawnedPlayer = this.entityIdMap.get(entity);
            if (deSpawnedPlayer == null || !deSpawnedPlayer.isLoaded() || this.nameTagX.isPlayerDisabled(deSpawnedPlayer)) continue;
            BackendArmorStandManager asm = this.nameTagX.getArmorStandManager(deSpawnedPlayer);
            TAB.getInstance().getCPUManager().runMeasuredTask(this.getFeatureName(), "Processing entity destroy", () -> asm.destroy(receiver));
        }
    }

    @Override
    @NotNull
    public String getFeatureName() {
        return this.nameTagX.getExtraFeatureName();
    }

    public PacketListener(BackendNameTagX nameTagX) {
        this.nameTagX = nameTagX;
    }
}

