/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.config.helper;

import java.util.Map;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.chat.EnumChatFormat;
import me.neznamy.tab.shared.chat.SimpleComponent;
import org.jetbrains.annotations.NotNull;

public class HintPrinter {
    public void checkHeaderFooterForRedundancy(@NotNull Map<String, Object> configSection) {
        Map map;
        String defaultHeader = String.valueOf(configSection.get("header"));
        String defaultFooter = String.valueOf(configSection.get("footer"));
        if (configSection.get("per-world") instanceof Map) {
            map = (Map)configSection.get("per-world");
            for (Map.Entry entry : map.entrySet()) {
                String world = (String)entry.getKey();
                if (String.valueOf(((Map)entry.getValue()).getOrDefault("header", "-")).equals(defaultHeader)) {
                    this.hint("Per-world header for world \"" + world + "\" is identical to default header. This is redundant and can be removed for cleaner config.");
                }
                if (!String.valueOf(((Map)entry.getValue()).getOrDefault("footer", "-")).equals(defaultFooter)) continue;
                this.hint("Per-world footer for world \"" + world + "\" is identical to default footer. This is redundant and can be removed for cleaner config.");
            }
        }
        if (configSection.get("per-server") instanceof Map) {
            map = (Map)configSection.get("per-server");
            for (Map.Entry entry : map.entrySet()) {
                String server = (String)entry.getKey();
                if (String.valueOf(((Map)entry.getValue()).getOrDefault("header", "-")).equals(defaultHeader)) {
                    this.hint("Per-server header for server \"" + server + "\" is identical to default header. This is redundant and can be removed for cleaner config.");
                }
                if (!String.valueOf(((Map)entry.getValue()).getOrDefault("footer", "-")).equals(defaultFooter)) continue;
                this.hint("Per-server footer for server \"" + server + "\" is identical to default footer. This is redundant and can be removed for cleaner config.");
            }
        }
    }

    public void layoutIncludesPreventSpectatorEffect() {
        this.hint("Layout feature automatically includes prevent-spectator-effect, therefore the feature can be disabled for better performance, as it is not needed at all (assuming it is configured to always display some layout).");
    }

    public void redundantRefreshInterval(@NotNull String placeholder) {
        this.hint("Refresh interval of " + placeholder + " is same as default interval, therefore there is no need to override it.");
    }

    public void checkForRedundantElseReplacement(@NotNull Map<Object, Object> replacementMap) {
        for (Map.Entry<Object, Object> entry : replacementMap.entrySet()) {
            String placeholder = String.valueOf(entry.getKey());
            if (!(entry.getValue() instanceof Map)) continue;
            for (Map.Entry pattern : ((Map)entry.getValue()).entrySet()) {
                if (!pattern.getKey().equals("else") || !pattern.getValue().equals(placeholder)) continue;
                this.hint(String.format("Placeholder %s has configured \"else -> %s\" replacement pattern, but this is already the default behavior and therefore this pattern can be removed.", placeholder, placeholder));
            }
        }
    }

    private void hint(@NotNull String message) {
        TAB.getInstance().getPlatform().logInfo(new SimpleComponent((Object)((Object)EnumChatFormat.GOLD) + "[Hint] " + message));
    }
}

