/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.cpu;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.cpu.CpuReport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CpuManager {
    private final int UPDATE_RATE_SECONDS = 10;
    private volatile Map<String, Map<String, AtomicLong>> featureUsageCurrent = new ConcurrentHashMap<String, Map<String, AtomicLong>>();
    private volatile Map<String, AtomicLong> placeholderUsageCurrent = new ConcurrentHashMap<String, AtomicLong>();
    @Nullable
    private CpuReport lastReport;
    private final ScheduledExecutorService processingThread = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("TAB Processing Thread").build());
    private final ScheduledExecutorService placeholderThread = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("TAB Placeholder Refreshing Thread").build());
    private final Queue<Runnable> taskQueue = new ConcurrentLinkedQueue<Runnable>();
    private volatile boolean enabled;
    private boolean trackUsage;

    public boolean enableTracking() {
        if (this.trackUsage) {
            return false;
        }
        this.trackUsage = true;
        this.startRepeatingTask((int)TimeUnit.SECONDS.toMillis(10L), () -> {
            this.lastReport = new CpuReport(10, this.featureUsageCurrent, this.placeholderUsageCurrent);
            this.featureUsageCurrent = new ConcurrentHashMap<String, Map<String, AtomicLong>>();
            this.placeholderUsageCurrent = new ConcurrentHashMap<String, AtomicLong>();
        });
        return true;
    }

    public void cancelAllTasks() {
        this.processingThread.shutdownNow();
        this.placeholderThread.shutdownNow();
    }

    public void enable() {
        Runnable r;
        this.enabled = true;
        while ((r = this.taskQueue.poll()) != null) {
            this.submit(r);
        }
    }

    private void submit(@NotNull Runnable task) {
        if (this.processingThread.isShutdown()) {
            return;
        }
        if (!this.enabled) {
            this.taskQueue.add(task);
            return;
        }
        this.processingThread.submit(() -> this.run(task));
    }

    public void addTime(@NotNull String feature, @NotNull String type, long nanoseconds) {
        if (!this.trackUsage) {
            return;
        }
        this.featureUsageCurrent.computeIfAbsent(feature, f -> new ConcurrentHashMap()).computeIfAbsent(type, t -> new AtomicLong()).addAndGet(nanoseconds);
    }

    public void addPlaceholderTime(@NotNull String placeholder, long nanoseconds) {
        if (!this.trackUsage) {
            return;
        }
        this.placeholderUsageCurrent.computeIfAbsent(placeholder, l -> new AtomicLong()).addAndGet(nanoseconds);
    }

    public void addPlaceholderTimes(@NotNull Map<String, Long> times) {
        if (!this.trackUsage) {
            return;
        }
        for (Map.Entry<String, Long> entry : times.entrySet()) {
            this.placeholderUsageCurrent.computeIfAbsent(entry.getKey(), l -> new AtomicLong()).addAndGet(entry.getValue());
        }
    }

    public void runMeasuredTask(@NotNull String feature, @NotNull String type, @NotNull Runnable task) {
        this.submit(() -> this.runAndMeasure(task, feature, type));
    }

    public void runTask(@NotNull Runnable task) {
        this.submit(task);
    }

    public void startRepeatingMeasuredTask(int intervalMilliseconds, @NotNull String feature, @NotNull String type, @NotNull Runnable task) {
        if (this.processingThread.isShutdown()) {
            return;
        }
        this.processingThread.scheduleAtFixedRate(() -> this.runAndMeasure(task, feature, type), intervalMilliseconds, intervalMilliseconds, TimeUnit.MILLISECONDS);
    }

    public void startRepeatingTask(int intervalMilliseconds, @NotNull Runnable task) {
        if (this.processingThread.isShutdown()) {
            return;
        }
        this.processingThread.scheduleAtFixedRate(() -> this.run(task), intervalMilliseconds, intervalMilliseconds, TimeUnit.MILLISECONDS);
    }

    public void runTaskLater(int delayMilliseconds, @NotNull String feature, @NotNull String type, @NotNull Runnable task) {
        if (this.processingThread.isShutdown()) {
            return;
        }
        this.processingThread.schedule(() -> this.runAndMeasure(task, feature, type), (long)delayMilliseconds, TimeUnit.MILLISECONDS);
    }

    public void runAndMeasure(@NotNull Runnable task, @NotNull String feature, @NotNull String type) {
        if (!this.trackUsage) {
            this.run(task);
            return;
        }
        long time = System.nanoTime();
        this.run(task);
        this.addTime(feature, type, System.nanoTime() - time);
    }

    private void run(@NotNull Runnable task) {
        try {
            task.run();
        }
        catch (Exception | LinkageError | StackOverflowError e) {
            TAB.getInstance().getErrorManager().taskThrewError(e);
        }
    }

    @Nullable
    public CpuReport getLastReport() {
        return this.lastReport;
    }

    public ScheduledExecutorService getPlaceholderThread() {
        return this.placeholderThread;
    }

    public boolean isTrackUsage() {
        return this.trackUsage;
    }
}

