/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features.redis.feature;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import java.util.Collections;
import java.util.UUID;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.chat.EnumChatFormat;
import me.neznamy.tab.shared.features.nametags.NameTag;
import me.neznamy.tab.shared.features.redis.RedisPlayer;
import me.neznamy.tab.shared.features.redis.RedisSupport;
import me.neznamy.tab.shared.features.redis.feature.RedisFeature;
import me.neznamy.tab.shared.features.redis.message.RedisMessage;
import me.neznamy.tab.shared.platform.Scoreboard;
import me.neznamy.tab.shared.platform.TabPlayer;
import org.jetbrains.annotations.NotNull;

public class RedisTeams
extends RedisFeature {
    private final RedisSupport redisSupport;
    private final NameTag nameTags;

    public RedisTeams(@NotNull RedisSupport redisSupport, @NotNull NameTag nameTags) {
        this.redisSupport = redisSupport;
        this.nameTags = nameTags;
        redisSupport.registerMessage("teams", Update.class, () -> new Update());
    }

    @Override
    public void onJoin(@NotNull TabPlayer player) {
        for (RedisPlayer redis : this.redisSupport.getRedisPlayers().values()) {
            player.getScoreboard().registerTeam(redis.getTeamName(), redis.getTagPrefix(), redis.getTagSuffix(), redis.getNameVisibility(), Scoreboard.CollisionRule.ALWAYS, Collections.singletonList(redis.getNickname()), 2, EnumChatFormat.lastColorsOf(redis.getTagPrefix()));
        }
    }

    @Override
    public void onJoin(@NotNull RedisPlayer player) {
        for (TabPlayer viewer : TAB.getInstance().getOnlinePlayers()) {
            viewer.getScoreboard().registerTeam(player.getTeamName(), player.getTagPrefix(), player.getTagSuffix(), player.getNameVisibility(), Scoreboard.CollisionRule.ALWAYS, Collections.singletonList(player.getNickname()), 2, EnumChatFormat.lastColorsOf(player.getTagPrefix()));
        }
    }

    @Override
    public void onQuit(@NotNull RedisPlayer player) {
        for (TabPlayer viewer : TAB.getInstance().getOnlinePlayers()) {
            viewer.getScoreboard().unregisterTeam(player.getTeamName());
        }
    }

    @Override
    public void write(@NotNull ByteArrayDataOutput out, @NotNull TabPlayer player) {
        out.writeUTF(player.sortingData.getShortTeamName());
        out.writeUTF(player.getProperty("tagprefix").get());
        out.writeUTF(player.getProperty("tagsuffix").get());
        out.writeUTF((this.nameTags.getTeamVisibility(player, player) ? Scoreboard.NameVisibility.ALWAYS : Scoreboard.NameVisibility.NEVER).toString());
    }

    @Override
    public void read(@NotNull ByteArrayDataInput in, @NotNull RedisPlayer player) {
        String teamName = in.readUTF();
        teamName = this.checkTeamName(player, teamName.substring(0, teamName.length() - 1), 65);
        player.setTeamName(teamName);
        player.setTagPrefix(in.readUTF());
        player.setTagSuffix(in.readUTF());
        player.setNameVisibility(Scoreboard.NameVisibility.getByName(in.readUTF()));
    }

    @Override
    public void onLoginPacket(@NotNull TabPlayer player) {
        this.onJoin(player);
    }

    @NotNull
    private String checkTeamName(@NotNull RedisPlayer player, @NotNull String currentName15, int id) {
        String potentialTeamName = currentName15 + (char)id;
        for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
            if (!all.sortingData.getShortTeamName().equals(potentialTeamName)) continue;
            return this.checkTeamName(player, currentName15, id + 1);
        }
        for (RedisPlayer all : this.redisSupport.getRedisPlayers().values()) {
            if (all == player || !potentialTeamName.equals(all.getTeamName())) continue;
            return this.checkTeamName(player, currentName15, id + 1);
        }
        return potentialTeamName;
    }

    public RedisSupport getRedisSupport() {
        return this.redisSupport;
    }

    public NameTag getNameTags() {
        return this.nameTags;
    }

    public class Update
    extends RedisMessage {
        private UUID playerId;
        private String teamName;
        private String prefix;
        private String suffix;
        private Scoreboard.NameVisibility nameVisibility;

        @Override
        public void write(@NotNull ByteArrayDataOutput out) {
            this.writeUUID(out, this.playerId);
            out.writeUTF(this.teamName);
            out.writeUTF(this.prefix);
            out.writeUTF(this.suffix);
            out.writeUTF(this.nameVisibility.toString());
        }

        @Override
        public void read(@NotNull ByteArrayDataInput in) {
            this.playerId = this.readUUID(in);
            this.teamName = in.readUTF();
            this.prefix = in.readUTF();
            this.suffix = in.readUTF();
            this.nameVisibility = Scoreboard.NameVisibility.getByName(in.readUTF());
        }

        @Override
        public void process(@NotNull RedisSupport redisSupport) {
            RedisPlayer target = redisSupport.getRedisPlayers().get(this.playerId);
            if (target == null) {
                return;
            }
            String oldTeamName = target.getTeamName();
            String newTeamName = RedisTeams.this.checkTeamName(target, this.teamName.substring(0, this.teamName.length() - 1), 65);
            target.setTeamName(newTeamName);
            target.setTagPrefix(this.prefix);
            target.setTagSuffix(this.suffix);
            if (!oldTeamName.equals(newTeamName)) {
                for (TabPlayer viewer : TAB.getInstance().getOnlinePlayers()) {
                    viewer.getScoreboard().unregisterTeam(oldTeamName);
                    viewer.getScoreboard().registerTeam(newTeamName, this.prefix, this.suffix, this.nameVisibility, Scoreboard.CollisionRule.ALWAYS, Collections.singletonList(target.getNickname()), 2, EnumChatFormat.lastColorsOf(this.prefix));
                }
            } else {
                for (TabPlayer viewer : TAB.getInstance().getOnlinePlayers()) {
                    viewer.getScoreboard().updateTeam(oldTeamName, this.prefix, this.suffix, this.nameVisibility, Scoreboard.CollisionRule.ALWAYS, 2, EnumChatFormat.lastColorsOf(this.prefix));
                }
            }
        }

        public Update() {
        }

        public Update(UUID playerId, String teamName, String prefix, String suffix, Scoreboard.NameVisibility nameVisibility) {
            this.playerId = playerId;
            this.teamName = teamName;
            this.prefix = prefix;
            this.suffix = suffix;
            this.nameVisibility = nameVisibility;
        }
    }
}

