/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.platform.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.neznamy.tab.api.bossbar.BarColor;
import me.neznamy.tab.api.bossbar.BarStyle;
import me.neznamy.tab.shared.chat.TabComponent;
import me.neznamy.tab.shared.platform.BossBar;
import me.neznamy.tab.shared.platform.TabPlayer;
import me.neznamy.tab.shared.util.ReflectionUtils;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;

public class AdventureBossBar
implements BossBar {
    private static final boolean available = ReflectionUtils.classExists("net.kyori.adventure.bossbar.BossBar");
    private final TabPlayer player;
    private final Map<UUID, net.kyori.adventure.bossbar.BossBar> bossBars = new HashMap<UUID, net.kyori.adventure.bossbar.BossBar>();
    private boolean frozen;

    @Override
    public void create(@NotNull UUID id, @NotNull String title, float progress, @NotNull BarColor color, @NotNull BarStyle style) {
        if (this.frozen) {
            return;
        }
        net.kyori.adventure.bossbar.BossBar bar = net.kyori.adventure.bossbar.BossBar.bossBar((Component)((Component)TabComponent.optimized(title).convert(this.player.getVersion())), (float)progress, (BossBar.Color)BossBar.Color.valueOf((String)color.name()), (BossBar.Overlay)BossBar.Overlay.valueOf((String)style.name()));
        this.bossBars.put(id, bar);
        ((Audience)this.player.getPlayer()).showBossBar(bar);
    }

    @Override
    public void update(@NotNull UUID id, @NotNull String title) {
        if (this.frozen) {
            return;
        }
        this.bossBars.get(id).name((Component)TabComponent.optimized(title).convert(this.player.getVersion()));
    }

    @Override
    public void update(@NotNull UUID id, float progress) {
        if (this.frozen) {
            return;
        }
        this.bossBars.get(id).progress(progress);
    }

    @Override
    public void update(@NotNull UUID id, @NotNull BarStyle style) {
        if (this.frozen) {
            return;
        }
        this.bossBars.get(id).overlay(BossBar.Overlay.valueOf((String)style.name()));
    }

    @Override
    public void update(@NotNull UUID id, @NotNull BarColor color) {
        if (this.frozen) {
            return;
        }
        this.bossBars.get(id).color(BossBar.Color.valueOf((String)color.name()));
    }

    @Override
    public void remove(@NotNull UUID id) {
        if (this.frozen) {
            return;
        }
        ((Audience)this.player.getPlayer()).hideBossBar(this.bossBars.remove(id));
    }

    @Override
    public void freeze() {
        this.bossBars.clear();
        this.frozen = true;
    }

    @Override
    public void unfreeze() {
        this.frozen = false;
    }

    public AdventureBossBar(TabPlayer player) {
        this.player = player;
    }

    public static boolean isAvailable() {
        return available;
    }
}

